/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.schedule;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.DeployServiceV4;
import com.digiwin.athena.athenadeployer.service.impl.DeployServiceImplV3;
import com.digiwin.athena.athenadeployer.utils.RedisCache;
import jakarta.annotation.Resource;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DeployLogCheckSchedule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployLogCheckSchedule.class);
    @Autowired
    private DeployServiceV4 deployServiceV4;
    @Autowired
    private RedisCache redisCache;
    @Resource
    private RedissonClient redissonClient;
    public static final String DEPLOY_LOG_CHECK_SCHEDULE_LOCK = "ATHENA_DEPLOYER_DEPLOY_LOG_CHECK_SCHEDULE_LOCK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${jobCron.DeployLogCheckSchedule}")
    public void run() {
        block9: {
            log.info("DeployLogCheckSchedule start");
            try {
                RLock rLock = this.redissonClient.getLock("ATHENA_DEPLOYER_DEPLOY_LOG_CHECK_SCHEDULE_LOCK");
                boolean isLock = rLock.tryLock();
                log.info("lock result:" + isLock);
                if (!isLock) break block9;
                try {
                    List deployLogList = this.deployServiceV4.getNeedCheckDeployLog();
                    log.info("deployLogList size:" + deployLogList.size());
                    if (!deployLogList.isEmpty()) {
                        List publishAllElements = this.redisCache.getAllListElements(DeployServiceImplV3.DEPLOY_LIST_KEY);
                        List switchAllElements = this.redisCache.getAllListElements(DeployServiceImplV3.SWITCH_LIST_KEY);
                        HashSet allKeys = new HashSet();
                        allKeys.addAll(publishAllElements.stream().map(o -> {
                            DeployParamV3 deployParamV3 = (DeployParamV3)JSONObject.parseObject((String)JSONObject.toJSONString((Object)o), DeployParamV3.class);
                            String appCode = ((ApplicationData)deployParamV3.getApplicationDataList().get(0)).getApplication();
                            return "athena_deployer_deploy_lock__" + deployParamV3.getEnv() + "__" + appCode;
                        }).collect(Collectors.toList()));
                        allKeys.addAll(switchAllElements.stream().map(o -> {
                            DeployParamV3 deployParamV3 = (DeployParamV3)JSONObject.parseObject((String)JSONObject.toJSONString((Object)o), DeployParamV3.class);
                            String appCode = ((ApplicationData)deployParamV3.getApplicationDataList().get(0)).getApplication();
                            return "athena_deployer_switch_lock__" + deployParamV3.getEnv() + "__" + appCode;
                        }).collect(Collectors.toList()));
                        deployLogList = deployLogList.stream().filter(l -> !allKeys.contains(DeployLogCheckSchedule.generateKey((DeployLog)l))).collect(Collectors.toList());
                        Set searchKeys = deployLogList.stream().map(deployLog -> DeployLogCheckSchedule.generateKey((DeployLog)deployLog)).collect(Collectors.toSet());
                        if (!searchKeys.isEmpty()) {
                            searchKeys = searchKeys.stream().filter(k -> {
                                Map value = (Map)this.redisCache.getHashEntries(k);
                                return CollectionUtils.isEmpty((Map)value);
                            }).collect(Collectors.toSet());
                        }
                        for (DeployLog deployLog2 : deployLogList) {
                            if (!searchKeys.contains(DeployLogCheckSchedule.generateKey((DeployLog)deployLog2))) continue;
                            log.info(String.format("DeployLogCheckSchedule \u91cd\u65b0\u653e\u5165:%s,%s", deployLog2.getApplication(), deployLog2.getDeployNo()));
                            if (EnvOperateEnum.PUBLISH.getOperate().equals(deployLog2.getType())) {
                                this.redisCache.rpush(DeployServiceImplV3.DEPLOY_LIST_KEY, (Object)deployLog2.getDeployParam(), 0L);
                                continue;
                            }
                            this.redisCache.rpush(DeployServiceImplV3.SWITCH_LIST_KEY, (Object)deployLog2.getDeployParam(), 0L);
                        }
                    }
                }
                finally {
                    rLock.unlock();
                }
            }
            catch (Exception e) {
                log.error("DeployLogCheckSchedule exception:" + e.getMessage(), (Throwable)e);
            }
        }
        log.info("DeployLogCheckSchedule end");
    }

    private static String generateKey(DeployLog deployLog) {
        DeployParamV3 deployParam = deployLog.getDeployParam();
        String appCode = ((ApplicationData)deployParam.getApplicationDataList().get(0)).getApplication();
        if (EnvOperateEnum.PUBLISH.getOperate().equals(deployLog.getType())) {
            return "athena_deployer_deploy_lock__" + deployParam.getEnv() + "__" + appCode;
        }
        return "athena_deployer_switch_lock__" + deployParam.getEnv() + "__" + appCode;
    }
}

