/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.schedule;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.athenadeployer.service.CronJobExecutionTimeService;
import com.digiwin.athena.athenadeployer.service.DeployServiceV4;
import java.util.Calendar;
import java.util.Date;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DeployTaskCleanSchedule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployTaskCleanSchedule.class);
    private RedissonClient redissonClient;
    private DeployServiceV4 deployServiceV4;
    private CronJobExecutionTimeService cronJobExecutionTimeService;
    public static final String DEPLOY_TASK_CLEAN_SCHEDULE_LOCK = "ATHENA_DEPLOYER_DEPLOY_TASK_CLEAN_SCHEDULE_LOCK";

    @Autowired
    public void setCronJobExecutionTimeService(CronJobExecutionTimeService cronJobExecutionTimeService) {
        this.cronJobExecutionTimeService = cronJobExecutionTimeService;
    }

    @Autowired
    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    @Autowired
    public void setDeployServiceV4(DeployServiceV4 deployServiceV4) {
        this.deployServiceV4 = deployServiceV4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${jobCron.DeployTaskCleanSchedule}")
    public void run() {
        block14: {
            log.info("DeployTaskCleanSchedule start");
            try {
                RLock rLock = this.redissonClient.getLock(DEPLOY_TASK_CLEAN_SCHEDULE_LOCK);
                boolean isLock = rLock.tryLock();
                if (!isLock) break block14;
                try {
                    Date cur = new Date();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(cur);
                    calendar.add(5, -30);
                    Date deployTaskEndTime = calendar.getTime();
                    this.deployServiceV4.deployTaskClean(deployTaskEndTime);
                    DateTime deployDetailEndTime = DateUtil.offsetMonth((Date)cur, (int)-6);
                    this.deployServiceV4.deployDetailClean((Date)deployDetailEndTime);
                    this.cronJobExecutionTimeService.updateLastExecuteTime("DeployTaskCleanSchedule", cur);
                }
                catch (Exception e) {
                    log.error("DeployTaskCleanSchedule \u5931\u8d25:" + e.getMessage(), (Throwable)e);
                }
                finally {
                    if (isLock) {
                        try {
                            rLock.unlock();
                        }
                        catch (IllegalMonitorStateException ime) {
                            log.warn("\u91ca\u653e\u9501\u5931\u8d25: " + ime.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error(String.format("DeployTaskStatusCheckSchedule \u5f02\u5e38:%s", e.getMessage()), (Throwable)e);
            }
        }
        log.info("DeployTaskCleanSchedule end");
    }

    public static void main(String[] args) {
        Date curExecuteTime = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curExecuteTime);
        calendar.add(5, -7);
        System.out.println(calendar.getTime());
    }
}

