/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.schedule;

import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.service.DeployServiceV4;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DeployTaskStatusCheckSchedule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployTaskStatusCheckSchedule.class);
    private RedissonClient redissonClient;
    private DeployServiceV4 deployServiceV4;
    public static final String DEPLOY_TASK_STATUS_CHECK_SCHEDULE_LOCK = "ATHENA_DEPLOYER_DEPLOY_TASK_STATUS_CHECK_SCHEDULE_LOCK";

    @Autowired
    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    @Autowired
    public void setDeployServiceV4(DeployServiceV4 deployServiceV4) {
        this.deployServiceV4 = deployServiceV4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${jobCron.DeployTaskStatusCheckSchedule}")
    public void run() {
        block8: {
            log.info("DeployTaskStatusCheckSchedule start");
            try {
                RLock rLock = this.redissonClient.getLock(DEPLOY_TASK_STATUS_CHECK_SCHEDULE_LOCK);
                boolean isLock = rLock.tryLock();
                if (!isLock) break block8;
                try {
                    List deployTaskList = this.deployServiceV4.getWaitingResultTask();
                    log.info("deployTaskList size:" + deployTaskList.size());
                    Map<String, List<DeployTask>> envMapTask = deployTaskList.stream().collect(Collectors.groupingBy(DeployTask::getEnv));
                    for (Map.Entry<String, List<DeployTask>> entry : envMapTask.entrySet()) {
                        try {
                            this.deployServiceV4.checkTaskStatus(entry.getKey(), entry.getValue());
                        }
                        catch (Exception e) {
                            log.error(String.format("checkTaskStatus \u5f02\u5e38:%s", e.getMessage()), (Throwable)e);
                        }
                    }
                }
                finally {
                    rLock.unlock();
                }
            }
            catch (Exception e) {
                log.error(String.format("DeployTaskStatusCheckSchedule \u5f02\u5e38:%s", e.getMessage()), (Throwable)e);
            }
        }
        log.info("DeployTaskStatusCheckSchedule end");
    }
}

