/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.schedule;

import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.service.DeployServiceV3;
import com.digiwin.athena.athenadeployer.utils.RedisCache;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ServiceOutageHandlerSchedule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceOutageHandlerSchedule.class);
    @Resource
    private RedissonClient redissonClient;
    @Resource
    private DeployServiceV3 deployServiceV3;
    @Autowired
    private RedisCache redisCache;

    public void execute() {
        RLock rLock = this.redissonClient.getLock("ServiceOutageHandlerSchedule");
        boolean locked = rLock.tryLock();
        if (locked) {
            try {
                log.info("ServiceOutageHandlerSchedule start==========");
                this.handleDeployType();
                this.handleSwitchType();
                log.info("ServiceOutageHandlerSchedule end==========");
            }
            finally {
                rLock.unlock();
            }
        }
    }

    private void handleSwitchType() {
        try {
            List switchLogList = this.deployServiceV3.getAllSwitchExecutingRecord();
            log.info("switchLogList size:" + switchLogList.size());
            this.handle(switchLogList, "athena_deployer_switch_lock__");
        }
        catch (Exception e) {
            log.error("handleSwitchType exception:" + e.getMessage(), (Throwable)e);
        }
    }

    private void handleDeployType() {
        try {
            List deployLogList = this.deployServiceV3.getAllDeployExecutingRecord();
            log.info("deployLogList size:" + deployLogList.size());
            this.handle(deployLogList, "athena_deployer_deploy_lock__");
        }
        catch (Exception e) {
            log.error("handleDeployType exception:" + e.getMessage(), (Throwable)e);
        }
    }

    private void handle(List<DeployLog> logList, String redisKeyPrefix) {
        if (CollectionUtils.isEmpty(logList)) {
            return;
        }
        Date curDate = new Date();
        logList = logList.stream().filter(deployLog -> {
            DeployParamV3 deployParam = deployLog.getDeployParam();
            if (deployParam == null || StringUtils.isBlank((CharSequence)deployParam.getEnv())) {
                return true;
            }
            Map value = (Map)this.redisCache.getHashEntries(redisKeyPrefix + deployParam.getEnv() + "__" + deployLog.getApplication());
            return value.isEmpty();
        }).collect(Collectors.toList());
        List logId = logList.stream().map(DeployLog::getId).collect(Collectors.toList());
        List latestDeployList = this.deployServiceV3.getDeployExecutingResultByIds(logId);
        log.info("\u8fc7\u6ee4\u540e\u7684size:" + latestDeployList.size());
        if (latestDeployList.isEmpty()) {
            return;
        }
        List latestDeployIds = latestDeployList.stream().map(DeployLog::getId).collect(Collectors.toList());
        List deployDetailV2List = latestDeployList.stream().map(deployLog -> new DeployDetailV2().setDeployNo(deployLog.getDeployNo()).setApplication(deployLog.getApplication()).setTime(curDate).setContent("Deployer\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5").setResult("fail")).collect(Collectors.toList());
        this.deployServiceV3.updateFailResultByIds(latestDeployIds);
        this.deployServiceV3.batchInsert(deployDetailV2List);
    }
}

