/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AbiReportAuthTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbiReportAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List statementList = parseCompileFileResult.getStatementList();
        if (CollUtil.isNotEmpty((Collection)statementList)) {
            List abiStatementList = statementList.stream().filter(t -> this.isAbiStatement(t.getString("pattern"), t.getString("category"))).collect(Collectors.toList());
            if (abiStatementList.isEmpty()) {
                return null;
            }
            List activityConfigList = parseCompileFileResult.getActivityConfigList();
            List needAuthorizeAbiStatements = this.deployServiceV4.filterNeedAuthStatements(activityConfigList, abiStatementList);
            DeployTask deployTask = this.initDeployTask(deployParam);
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            Boolean commonApp = this.getCommonApp(parseCompileFileResult);
            AbstractDeployTaskNode.AuthParam authParam = commonApp != false ? this.commonAllStatementAuthParam(deployParam, abiStatementList, needAuthorizeAbiStatements, applicationData, parseCompileFileResult) : this.standardAllStatementAuthParam(deployParam, abiStatementList, needAuthorizeAbiStatements, applicationData, this.getIamModuleId());
            List jsonObjects = this.filterNeedAuthSysStatements(needAuthorizeAbiStatements);
            jsonObjects.addAll(this.filterNoNeedAuthStatements(abiStatementList, jsonObjects));
            authParam.setNeedAuthorizeSys(jsonObjects);
            deployTask.compressSetPublishParam((Object)authParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List abiList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "needAuthorizeAbiStatements", null);
        if (abiList.isEmpty()) {
            return null;
        }
        List applications = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "application", null);
        JSONObject appJson = ((DeployParamRecord)applications.get(0)).getValue();
        Boolean commonApp = appJson.getBoolean("commonApp");
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AbstractDeployTaskNode.AuthParam authParam = new AbstractDeployTaskNode.AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        List assignmentList = abiList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        authParam.setCommonApp(commonApp);
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(user.getTenantId()).setAssignmentList(assignmentList).setToken(user.getToken()).setApplication(applicationData.getApplication()).setEnv(deployParam.getEnv()).setAppJson(appJson);
        authParam.setGmcUpdateParam(gmcUpdateParam);
        deployTask.compressSetPublishParam((Object)authParam);
        return deployTask;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("AbiReportAuthTask executing");
        AbstractDeployTaskNode.AuthParam abiReportAuthParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (abiReportAuthParam.getCommonApp().booleanValue()) {
            this.commonIamAssignmentAuthorize(task, abiReportAuthParam);
            this.commonIamAddPolicy(task, abiReportAuthParam);
        } else {
            this.iamAssignmentAuthorize(task, abiReportAuthParam);
            this.iamAddPolicy(task, abiReportAuthParam);
        }
        this.deployServiceV4.recordLatestDeployParam(abiReportAuthParam.getApplication(), abiReportAuthParam.getEnv(), task.getCompileDataCode(), "needAuthorizeAbiStatements", abiReportAuthParam.getNeedAuthorizeSys());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("AbiReportAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        GmcUpdateParam gmcUpdateParam = authParam.getGmcUpdateParam();
        if (authParam.getCommonApp().booleanValue()) {
            gmcUpdateParam.setVersion(EnvOperateEnum.SWITCH.getVersion());
            this.backendApiHelper.updateCommonGmcMoudle(gmcUpdateParam);
        } else {
            this.backendApiHelper.updateGmcMoudle(gmcUpdateParam);
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.ABI_REPORT_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.ABI_REPORT_AUTH;
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return true;
    }

    String getIamModuleId() {
        return "report";
    }
}

