/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.Env;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.service.EnvService;
import com.digiwin.athena.athenadeployer.service.deployTask.AbiReportPublishTask;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AbiReportPublishTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbiReportPublishTask.class);
    @Autowired
    private EnvService envService;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List statementList = parseCompileFileResult.getStatementList();
        if (CollUtil.isNotEmpty((Collection)statementList)) {
            List abiStatementList = statementList.stream().filter(t -> this.isAbiStatement(t.getString("pattern"), t.getString("category"))).collect(Collectors.toList());
            if (abiStatementList.isEmpty()) {
                return null;
            }
            List activityConfigList = parseCompileFileResult.getActivityConfigList();
            if (CollectionUtils.isEmpty((Collection)activityConfigList)) {
                return null;
            }
            DeployTask deployTask = this.initDeployTask(deployParam);
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            AbiReportPublishParam abiReportPublishParam = new AbiReportPublishParam();
            abiReportPublishParam.setEnv(deployParam.getEnv());
            abiReportPublishParam.setApplication(applicationData.getApplication());
            abiReportPublishParam.setUser(AthenaUserLocal.getUser());
            ArrayList resIds = new ArrayList();
            String isvCode = this.backendApiHelper.getIsvCode(AthenaUserLocal.getUser().getTenantId(), deployParam.getEnv());
            abiReportPublishParam.setResIds(resIds);
            for (JSONObject item : abiStatementList) {
                String code = item.getString("code");
                JSONObject activityConfig = activityConfigList.stream().filter(ac -> ac.getString("code").equals(code)).findFirst().orElse(null);
                if (activityConfig == null) continue;
                Map resIdMap = this.deployServiceV4.getResidByAc(activityConfig);
                log.info("resIdMap:" + JSONObject.toJSONString((Object)resIdMap));
                for (String resId : resIdMap.values()) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("isvCode", (Object)isvCode);
                    jsonObject.put("resid", (Object)resId);
                    jsonObject.put("tenantId", (Object)AthenaUserLocal.getUser().getTenantId());
                    jsonObject.put("token", (Object)AthenaUserLocal.getUser().getToken());
                    jsonObject.put("code", (Object)code);
                    jsonObject.put("appCode", (Object)applicationData.getApplication());
                    abiReportPublishParam.getAbiStatementList().add(jsonObject);
                    abiReportPublishParam.getResIds().add(resId);
                    log.info("abiReportPublishParam:" + JSONObject.toJSONString((Object)abiReportPublishParam));
                }
            }
            deployTask.compressSetPublishParam((Object)abiReportPublishParam);
            return deployTask;
        }
        return null;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("AbiReportPublishTask executing");
        this.syncAbi(task);
        this.publish(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(DeployTask task) {
        AbiReportPublishParam abiReportPublishParam = (AbiReportPublishParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Env envObj = this.envService.queryByEnvAndModule(abiReportPublishParam.getEnv(), "deploy_service");
        Boolean currentArea = envObj.getCurrentArea();
        if (currentArea != null && currentArea.booleanValue()) {
            DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent(), this.getDeployType().getLang());
            try {
                List abiStatementList = abiReportPublishParam.getAbiStatementList();
                for (JSONObject jsonObject : abiStatementList) {
                    this.backendApiHelper.abiStatementPublish(jsonObject, abiReportPublishParam.getUser().getToken(), abiReportPublishParam.getEnv());
                }
                deployDetailV2.setResult("success");
            }
            catch (Exception e) {
                deployDetailV2.setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString());
            }
            finally {
                this.finishUpdateDetail(deployDetailV2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAbi(DeployTask task) {
        AbiReportPublishParam abiReportPublishParam = (AbiReportPublishParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Env envObj = this.envService.queryByEnvAndModule(abiReportPublishParam.getEnv(), "deploy_service");
        Boolean currentArea = envObj.getCurrentArea();
        if (currentArea != null && currentArea.booleanValue()) {
            return;
        }
        List resIds = abiReportPublishParam.getResIds();
        if (!resIds.isEmpty()) {
            DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent(), this.getDeployType().getLang());
            try {
                AthenaUser user = abiReportPublishParam.getUser();
                this.backendApiHelper.syncAbi(abiReportPublishParam.getEnv(), resIds, abiReportPublishParam.getApplication(), user.getToken(), user.getTenantId());
                deployDetailV2.setResult("success");
            }
            catch (Exception e) {
                deployDetailV2.setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString());
            }
            finally {
                this.finishUpdateDetail(deployDetailV2);
            }
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.ABI_REPORT_PUBLISH;
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return true;
    }
}

