/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.athenadeployer.dao.mongo.ApplicationDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployDetailV2Dao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployLogDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployTaskDao;
import com.digiwin.athena.athenadeployer.dao.mongo.IamAuthInfoRecordDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.IamAuthInfoRecord;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.action.MultiLanguageDTO;
import com.digiwin.athena.athenadeployer.domain.deploy.AdTemplatePublishParam;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.IamAddPolicyParam;
import com.digiwin.athena.athenadeployer.domain.deploy.IamAssignmentAuthorizeParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Node;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.TenantPipeLine;
import com.digiwin.athena.athenadeployer.dto.deployer.AdTemplatePublishInfoDto;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.dto.designer.TenantInfo;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.http.deployService.DeployServiceApiHelper;
import com.digiwin.athena.athenadeployer.service.DeployServiceV4;
import com.digiwin.athena.athenadeployer.service.PresetDataService;
import com.digiwin.athena.athenadeployer.service.ReleasePipeLineService;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.DeployTaskFactory;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import com.digiwin.athena.athenadeployer.utils.LogUtils;
import com.digiwin.athena.athenadeployer.utils.RedisCache;
import com.digiwin.athena.athenadeployer.utils.TenantPipelineHelper;
import com.digiwin.athena.athenadeployer.utils.UserHelpUtils;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractDeployTaskNode<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDeployTaskNode.class);
    @Autowired
    protected DeployServiceV4 deployServiceV4;
    @Autowired
    protected PresetDataService presetDataService;
    @Autowired
    protected DeployDetailV2Dao deployDetailV2Dao;
    @Autowired
    protected DeployLogDao deployLogDao;
    @Autowired
    protected DeployTaskDao deployTaskDao;
    @Autowired
    protected DeployTaskFactory deployTaskFactory;
    @Autowired
    protected DeployServiceApiHelper deployServiceApiHelper;
    @Autowired
    protected BackendApiHelper backendApiHelper;
    @Autowired
    protected RedisCache redisCache;
    @Autowired
    protected ApplicationDao applicationDao;
    @Autowired
    private ReleasePipeLineService releasePipeLineService;
    @Autowired
    protected DesignerApiHelper designerApiHelper;
    protected IamAuthInfoRecordDao iamAuthInfoRecordDao;
    public static String DEPLOY_PROCESS_KEY = "ATHENA_DEPLOYER_DEPLOY_PROCESS_V2__";
    public static final List<String> PATTERN_TBB = Arrays.asList("STATEMENT", "MOBI-STATEMENT");
    public static final List<String> CATEGORY_TBB = Arrays.asList("STATEMENT");
    public static final List<String> PATTERN_ABI = Arrays.asList("STATEMENT");
    public static final List<String> CATEGORY_ABI = Arrays.asList("ABI-STATEMENT");
    public static final List<String> CATEGORY_CUSTOM = Arrays.asList("CUSTOM-STATEMENT-DETAIL", "CUSTOM-STATEMENT");
    public static final List<String> PATTERN_CUSTOM = Arrays.asList("STATEMENT");

    @Autowired
    public void setIamAuthInfoRecordDao(IamAuthInfoRecordDao iamAuthInfoRecordDao) {
        this.iamAuthInfoRecordDao = iamAuthInfoRecordDao;
    }

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        return null;
    }

    DeployTaskTypeEnum getDeployType() {
        return null;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return null;
    }

    String getIamModuleId() {
        return null;
    }

    void deployPreHandle(T task) {
        if (task instanceof DeployTask) {
            this.updateTaskStatus("executing", (DeployTask)task);
        }
    }

    void deployPostHandle(T task) {
        if (task instanceof DeployTask) {
            this.updateTaskStatus("success", (DeployTask)task);
            DeployTask t = (DeployTask)task;
            BigDecimal progress = new BigDecimal(this.getDeployType().ordinal() + 1).divide(new BigDecimal(DeployTaskTypeEnum.values().length), 2, 3);
            this.deployLogDao.updateProcessByApplicationAndId(t.getApplication(), t.getDeployNo(), progress);
        }
    }

    void deployTaskFailHandle(T task) {
        if (task instanceof DeployTask) {
            this.updateTaskStatus("fail", (DeployTask)task);
        }
    }

    void switchPreHandle(T task) {
        if (task instanceof DeployTask) {
            this.updateTaskStatus("executing", (DeployTask)task);
        }
    }

    void switchPostHandle(T task) {
        if (task instanceof DeployTask) {
            this.updateTaskStatus("success", (DeployTask)task);
            DeployTask t = (DeployTask)task;
            BigDecimal progress = new BigDecimal(this.getSwitchType().ordinal() + 1).divide(new BigDecimal(SwitchTaskTypeEnum.values().length), 2, 3);
            this.deployLogDao.updateProcessByApplicationAndId(t.getApplication(), t.getDeployNo(), progress);
        }
    }

    void switchTaskFailHandle(T task) {
        if (task instanceof DeployTask) {
            this.updateTaskStatus("fail", (DeployTask)task);
        }
    }

    public final void executeDeploy(T task) {
        try {
            this.deployPreHandle(task);
            this.doDeployExecute(task);
            this.deployPostHandle(task);
        }
        catch (Exception e) {
            log.error("executeDeploy\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            this.deployTaskFailHandle(task);
            throw e;
        }
    }

    public final void executeSwitch(T task) {
        try {
            this.switchPreHandle(task);
            this.doSwitchExecute(task);
            this.switchPostHandle(task);
        }
        catch (Exception e) {
            log.error("executeSwitch\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            this.switchTaskFailHandle(task);
            throw e;
        }
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return false;
    }

    public Boolean switchCustomCreateDeployDetailFlag() {
        return false;
    }

    public String deployDetailLevel() {
        return "fail";
    }

    protected void doDeployExecute(T task) {
    }

    protected void doSwitchExecute(T task) {
    }

    void updateTaskStatus(String status, DeployTask task) {
        task.setStatus(status);
        task.setEditDate(new Date());
        this.deployTaskDao.save(task);
    }

    DeployTask initDeployTask(DeployParamV3 deployParam) {
        DeployTask deployTask = this.getDeployTask(deployParam);
        deployTask.setType(this.getDeployType().getType());
        deployTask.setOrder(this.getDeployType().getOrder());
        return deployTask;
    }

    DeployTask initSwitchTask(DeployParamV3 deployParam) {
        DeployTask deployTask = this.getDeployTask(deployParam);
        deployTask.setType(this.getSwitchType().getType());
        deployTask.setOrder(this.getSwitchType().getOrder());
        return deployTask;
    }

    private DeployTask getDeployTask(DeployParamV3 deployParam) {
        DeployTask deployTask = new DeployTask();
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        deployTask.setApplication(applicationData.getApplication());
        deployTask.setDeployNo(deployParam.getId());
        deployTask.setStatus("waiting");
        deployTask.setEnv(deployParam.getEnv());
        deployTask.setCompileDataCode(applicationData.getCompileDataCode());
        deployTask.setTenantUsers(deployParam.getTenantUsers());
        deployTask.setEnvServiceId(deployParam.getEnvServiceId());
        deployTask.setApplicationInfoDto(applicationData.getApplicationInfoDto());
        deployTask.setCreateDate(new Date());
        deployTask.setEditDate(new Date());
        deployTask.setCreateBy("SYSTEM");
        deployTask.setEditBy("SYSTEM");
        return deployTask;
    }

    Boolean getCommonApp(ParseCompileFileResult parseCompileFileResult) {
        JSONObject appData = parseCompileFileResult.getApplication();
        Boolean commonApp = Optional.ofNullable(appData.getBoolean("commonApp")).orElse(false);
        return commonApp;
    }

    Boolean isAbiStatement(String pattern, String category) {
        return CATEGORY_ABI.contains(category) && PATTERN_ABI.contains(pattern);
    }

    Boolean isTbbStatement(String pattern, String category) {
        return CATEGORY_TBB.contains(category) && PATTERN_TBB.contains(pattern);
    }

    Boolean isCustomStatement(String pattern, String category) {
        return CATEGORY_CUSTOM.contains(category) && PATTERN_CUSTOM.contains(pattern);
    }

    JSONObject getApplication(ParseCompileFileResult parseCompileFileResult) {
        JSONObject application = parseCompileFileResult.getApplication();
        return application;
    }

    Boolean isIndividualApp(DeployParamV3 deployParam) {
        ApplicationInfoDto applicationInfoDto = ((ApplicationData)deployParam.getApplicationDataList().get(0)).getApplicationInfoDto();
        return applicationInfoDto != null && applicationInfoDto.isIndividual();
    }

    void iamAddPolicy(DeployTask task, AuthParam authParam) {
        Map orgLang = this.getDeployType().getLang();
        MultiLanguageDTO content = (MultiLanguageDTO)orgLang.get("content");
        String contentLang = String.format("{\"content\":{\"en_US\":\"%s Enable job tenant authorization\",\"zh_CN\":\"%s \u5f00\u542f\u4f5c\u4e1a\u79df\u6237\u6388\u6743\",\"zh_TW\":\"%s \u958b\u555f\u4f5c\u696d\u79df\u6236\u6388\u6b0a\"}}", content.getEn_US(), content.getZh_CN(), content.getZh_TW());
        Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + " \u5f00\u542f\u4f5c\u4e1a\u79df\u6237\u6388\u6743", lang);
        List iamAddPolicyParam = authParam.getIamAddPolicyParam();
        try {
            for (IamAddPolicyParam addPolicyParam : iamAddPolicyParam) {
                this.backendApiHelper.iamAddPolicy(addPolicyParam);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            String message = "\u8c03IAM\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
            String errorMsg = e.toString();
            errorMsg = this.getErrorMessage(message, task, "iamAddPolicy", LogUtils.AADC_500_0002, JSON.toJSONString((Object)authParam), errorMsg);
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(errorMsg);
            throw e;
        }
        finally {
            this.finishUpdateDetail(deployDetailV2);
        }
    }

    protected String getErrorMessage(String message, DeployTask task, String step, String code, String input, String errorMsg) {
        String messageId = IdUtil.fastUUID().replace("-", "");
        List agileTypes = DeployTaskTypeEnum.getAgileTypes();
        if (agileTypes.contains(task.getType())) {
            errorMsg = LogUtils.buildAgileLog((String)task.getApplication(), (String)LogUtils.MODULE_AADC, (String)step, (String)code, (String)input, (String)String.format(message, errorMsg), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
        }
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iamAssignmentAuthorize(DeployTask task, AuthParam authParam) {
        Map orgLang = this.getDeployType().getLang();
        MultiLanguageDTO content = (MultiLanguageDTO)orgLang.get("content");
        String contentLang = String.format("{\"content\":{\"en_US\":\"%s iam permission update\",\"zh_CN\":\"%s iam\u6743\u9650\u66f4\u65b0\",\"zh_TW\":\"%s iam\u6b0a\u9650\u66f4\u65b0\"}}", content.getEn_US(), content.getZh_CN(), content.getZh_TW());
        Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + " iam\u6743\u9650\u66f4\u65b0", lang);
        List iamAssignmentAuthorizeParams = authParam.getIamAssignmentAuthorizeParams();
        try {
            ArrayList<CallSite> errorCodeList = new ArrayList<CallSite>();
            for (IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam : iamAssignmentAuthorizeParams) {
                try {
                    this.backendApiHelper.iamAssignmentAuthorize(iamAssignmentAuthorizeParam);
                }
                catch (Exception e) {
                    errorCodeList.add((CallSite)((Object)(iamAssignmentAuthorizeParam.getAssignment().getString("code") + ":" + e.getMessage())));
                }
            }
            if (!CollectionUtils.isEmpty(errorCodeList)) {
                String message = "\u8c03IAM\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
                String errorMsg = String.join((CharSequence)"; ", errorCodeList);
                errorMsg = this.getErrorMessage(message, task, "iamAssignmentAuthorize", LogUtils.AADC_500_0001, JSON.toJSONString((Object)authParam), errorMsg);
                deployDetailV2.setResult("warn").setCause(errorMsg).setErrorMessage(errorMsg);
            } else {
                deployDetailV2.setResult("success");
            }
        }
        finally {
            this.finishUpdateDetail(deployDetailV2);
        }
    }

    void commonIamAddPolicy(DeployTask task, AuthParam authParam) {
        Map orgLang = this.getDeployType().getLang();
        MultiLanguageDTO content = (MultiLanguageDTO)orgLang.get("content");
        String contentLang = String.format("{\"content\":{\"en_US\":\"%s Enable job tenant authorization\",\"zh_CN\":\"%s \u5f00\u542f\u4f5c\u4e1a\u79df\u6237\u6388\u6743\",\"zh_TW\":\"%s \u958b\u555f\u4f5c\u696d\u79df\u6236\u6388\u6b0a\"}}", content.getEn_US(), content.getZh_CN(), content.getZh_TW());
        Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + " \u5f00\u542f\u4f5c\u4e1a\u79df\u6237\u6388\u6743", lang);
        List iamAddPolicyParam = authParam.getIamAddPolicyParam();
        try {
            for (IamAddPolicyParam addPolicyParam : iamAddPolicyParam) {
                this.backendApiHelper.commonIamAddPolicy(addPolicyParam);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString());
            throw e;
        }
        finally {
            this.finishUpdateDetail(deployDetailV2);
        }
    }

    void commonUpdateGmc(DeployTask task, AuthParam authParam) {
    }

    void commonIamAssignmentAuthorize(DeployTask task, AuthParam authParam) {
        Map orgLang = this.getDeployType().getLang();
        MultiLanguageDTO content = (MultiLanguageDTO)orgLang.get("content");
        String contentLang = String.format("{\"content\":{\"en_US\":\"%s iam permission update\",\"zh_CN\":\"%s iam\u6743\u9650\u66f4\u65b0\",\"zh_TW\":\"%s iam\u6b0a\u9650\u66f4\u65b0\"}}", content.getEn_US(), content.getZh_CN(), content.getZh_TW());
        Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + " iam\u6743\u9650\u66f4\u65b0", lang);
        ArrayList<CallSite> errorCodeList = new ArrayList<CallSite>();
        List iamAssignmentAuthorizeParams = authParam.getIamAssignmentAuthorizeParams();
        for (IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam : iamAssignmentAuthorizeParams) {
            try {
                this.backendApiHelper.commonIamAssignmentAuthorize(iamAssignmentAuthorizeParam);
            }
            catch (Exception e) {
                errorCodeList.add((CallSite)((Object)(iamAssignmentAuthorizeParam.getAssignment().getString("code") + ":" + e.getMessage())));
            }
        }
        if (!CollectionUtils.isEmpty(errorCodeList)) {
            deployDetailV2.setResult("warn").setCause(String.join((CharSequence)"; ", errorCodeList)).setErrorMessage(String.join((CharSequence)";", errorCodeList));
        } else {
            deployDetailV2.setResult("success");
        }
        this.finishUpdateDetail(deployDetailV2);
    }

    AuthParam commonStatementAuthParam(DeployParamV3 deployParam, List<JSONObject> assignmentList, ApplicationData applicationData, ParseCompileFileResult parseCompileFileResult) {
        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
        String applicationCode = applicationInfoDto.isIndividual() ? applicationInfoDto.getSourceApplicationCode() : applicationInfoDto.getCode();
        AuthParam authParam = new AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        authParam.setCommonApp(Boolean.valueOf(true));
        authParam.setUser(user);
        authParam.setApplication(applicationData.getApplication());
        authParam.setEnv(deployParam.getEnv());
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam();
        authParam.setGmcUpdateParam(gmcUpdateParam);
        IamAddPolicyParam iamAddPolicyParam = new IamAddPolicyParam();
        authParam.getIamAddPolicyParam().add(iamAddPolicyParam);
        gmcUpdateParam.setTenantId(user.getTenantId()).setToken(AthenaUserLocal.getUser().getToken()).setApplication(applicationCode).setEnv(deployParam.getEnv()).setAppJson(parseCompileFileResult.getApplication()).setVersion("1.0");
        iamAddPolicyParam.setToken(AthenaUserLocal.getUser().getToken()).setTenantUsers(deployParam.getTenantUsers()).setApplication(applicationCode).setEnv(deployParam.getEnv());
        Map actionCodeModleIdMap = this.getAppIamActionModelInfo(deployParam.getEnv(), applicationCode, null);
        for (JSONObject needAuthorizeStatement : assignmentList) {
            boolean isAbi = this.isAbiStatement(needAuthorizeStatement.getString("pattern"), needAuthorizeStatement.getString("category"));
            String modelId = needAuthorizeStatement.getString("modelId");
            String path = needAuthorizeStatement.getString("path");
            String actionCode = needAuthorizeStatement.getString("code");
            Set actionCodes = actionCodeModleIdMap.keySet();
            String iamModelId = null;
            String iamPath = null;
            JSONObject action = (JSONObject)actionCodeModleIdMap.get(actionCode);
            if (Objects.isNull(action) || action.size() == 0) {
                iamModelId = null;
                iamPath = null;
            } else {
                iamModelId = StrUtil.isEmpty((CharSequence)action.getString("modelId")) ? null : action.getString("modelId");
                JSONArray right = action.getJSONArray("paths");
                if (Objects.nonNull(right) && right.size() > 0) {
                    List stringList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)right), String.class);
                    iamPath = String.join((CharSequence)",", stringList);
                }
            }
            Boolean needUpsert = true;
            Boolean updateCommonAction = false;
            if (actionCodes.contains(actionCode)) {
                boolean pathIsChange;
                boolean modelIdIsChange = modelId == null && iamModelId == null || iamModelId != null && iamModelId.equals(modelId);
                boolean bl = pathIsChange = path == null && iamPath == null || iamPath != null && iamPath.equals(path);
                if (!isAbi) {
                    if (modelIdIsChange) {
                        needUpsert = false;
                    } else {
                        updateCommonAction = true;
                    }
                } else if (pathIsChange) {
                    needUpsert = false;
                } else {
                    updateCommonAction = true;
                }
            }
            JSONObject statement = new JSONObject();
            statement.put("code", (Object)actionCode);
            statement.put("id", needAuthorizeStatement.get((Object)"id"));
            statement.put("lang", needAuthorizeStatement.get((Object)"lang"));
            statement.put("name", needAuthorizeStatement.get((Object)"name"));
            if (!isAbi) {
                statement.put("modelId", (Object)modelId);
                if (this.isTbbStatement(needAuthorizeStatement.getString("pattern"), needAuthorizeStatement.getString("category")).booleanValue() || this.isCustomStatement(needAuthorizeStatement.getString("pattern"), needAuthorizeStatement.getString("category")).booleanValue()) {
                    statement.put("type", (Object)needAuthorizeStatement.getString("category"));
                }
            }
            statement.put("updateCommonAction", (Object)updateCommonAction);
            if (isAbi) {
                statement.put("type", (Object)"ABI-STATEMENT");
                statement.put("path", (Object)path);
            }
            gmcUpdateParam.getAssignmentList().add(statement);
            if (needUpsert.booleanValue()) {
                IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam = new IamAssignmentAuthorizeParam();
                iamAssignmentAuthorizeParam.setEnv(deployParam.getEnv()).setTenantUsers(deployParam.getTenantUsers()).setCurrentUser(AthenaUserLocal.getUser()).setApplication(applicationCode).setIndividual(Boolean.valueOf(applicationInfoDto != null ? applicationInfoDto.isIndividual() : false));
                iamAssignmentAuthorizeParam.setAssignment(statement);
                authParam.getIamAssignmentAuthorizeParams().add(iamAssignmentAuthorizeParam);
            }
            iamAddPolicyParam.getAssignmentList().add(statement);
        }
        return authParam;
    }

    AuthParam commonAllStatementAuthParam(DeployParamV3 deployParam, List<JSONObject> assignmentList, List<JSONObject> needAuthStatements, ApplicationData applicationData, ParseCompileFileResult parseCompileFileResult) {
        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
        String applicationCode = applicationInfoDto.isIndividual() ? applicationInfoDto.getSourceApplicationCode() : applicationInfoDto.getCode();
        AuthParam authParam = new AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        authParam.setCommonApp(Boolean.valueOf(true));
        authParam.setUser(user);
        authParam.setApplication(applicationData.getApplication());
        authParam.setEnv(deployParam.getEnv());
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam();
        authParam.setGmcUpdateParam(gmcUpdateParam);
        IamAddPolicyParam iamAddPolicyParam = new IamAddPolicyParam();
        authParam.getIamAddPolicyParam().add(iamAddPolicyParam);
        gmcUpdateParam.setTenantId(user.getTenantId()).setToken(AthenaUserLocal.getUser().getToken()).setApplication(applicationCode).setEnv(deployParam.getEnv()).setAppJson(parseCompileFileResult.getApplication()).setVersion("1.0");
        iamAddPolicyParam.setToken(AthenaUserLocal.getUser().getToken()).setTenantUsers(deployParam.getTenantUsers()).setApplication(applicationCode).setEnv(deployParam.getEnv());
        Set needAuthCodes = needAuthStatements.stream().map(j -> j.getString("code")).collect(Collectors.toSet());
        Map actionCodeModleIdMap = this.getAppIamActionModelInfo(deployParam.getEnv(), applicationCode, null);
        for (JSONObject authStatement : assignmentList) {
            boolean isAbi = this.isAbiStatement(authStatement.getString("pattern"), authStatement.getString("category"));
            String modelId = authStatement.getString("modelId");
            String path = authStatement.getString("path");
            String actionCode = authStatement.getString("code");
            Boolean regardlessAuth = !needAuthCodes.contains(actionCode);
            Set actionCodes = actionCodeModleIdMap.keySet();
            String iamModelId = null;
            String iamPath = null;
            Boolean iamRegardlessAuth = null;
            JSONObject action = (JSONObject)actionCodeModleIdMap.get(actionCode);
            if (Objects.isNull(action) || action.size() == 0) {
                iamModelId = null;
                iamPath = null;
                iamRegardlessAuth = null;
            } else {
                iamModelId = StrUtil.isEmpty((CharSequence)action.getString("modelId")) ? null : action.getString("modelId");
                iamRegardlessAuth = action.getBoolean("regardlessAuth");
                JSONArray right = action.getJSONArray("paths");
                if (Objects.nonNull(right) && right.size() > 0) {
                    List stringList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)right), String.class);
                    iamPath = String.join((CharSequence)",", stringList);
                }
            }
            Boolean needUpsert = true;
            Boolean updateCommonAction = false;
            if (actionCodes.contains(actionCode)) {
                boolean modelIdIsNoChange = modelId == null && iamModelId == null || iamModelId != null && iamModelId.equals(modelId);
                boolean pathIsNoChange = path == null && iamPath == null || iamPath != null && iamPath.equals(path);
                boolean regardlessAuthIsNoChange = regardlessAuth.equals(iamRegardlessAuth);
                if (modelIdIsNoChange && pathIsNoChange && regardlessAuthIsNoChange) {
                    needUpsert = false;
                } else {
                    updateCommonAction = true;
                }
            }
            JSONObject statement = new JSONObject();
            statement.put("code", (Object)actionCode);
            statement.put("id", authStatement.get((Object)"id"));
            statement.put("lang", authStatement.get((Object)"lang"));
            statement.put("name", authStatement.get((Object)"name"));
            statement.put("regardlessAuth", (Object)regardlessAuth);
            statement.put("updateCommonAction", (Object)updateCommonAction);
            if (!isAbi) {
                statement.put("modelId", (Object)modelId);
                if (this.isTbbStatement(authStatement.getString("pattern"), authStatement.getString("category")).booleanValue() || this.isCustomStatement(authStatement.getString("pattern"), authStatement.getString("category")).booleanValue()) {
                    statement.put("type", (Object)authStatement.getString("category"));
                }
            }
            if (isAbi) {
                statement.put("type", (Object)"ABI-STATEMENT");
                statement.put("path", (Object)path);
            }
            gmcUpdateParam.getAssignmentList().add(statement);
            if (needUpsert.booleanValue()) {
                IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam = new IamAssignmentAuthorizeParam();
                iamAssignmentAuthorizeParam.setEnv(deployParam.getEnv()).setTenantUsers(deployParam.getTenantUsers()).setCurrentUser(AthenaUserLocal.getUser()).setApplication(applicationCode).setIndividual(Boolean.valueOf(applicationInfoDto != null ? applicationInfoDto.isIndividual() : false));
                iamAssignmentAuthorizeParam.setAssignment(statement);
                authParam.getIamAssignmentAuthorizeParams().add(iamAssignmentAuthorizeParam);
            }
            if (!needAuthCodes.contains(actionCode)) continue;
            iamAddPolicyParam.getAssignmentList().add(statement);
        }
        return authParam;
    }

    AuthParam standardStatementAuthParam(DeployParamV3 deployParam, List<JSONObject> assignmentList, ApplicationData applicationData, String moduleId) {
        AuthParam authParam = new AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        authParam.setCommonApp(Boolean.valueOf(false));
        authParam.setUser(user);
        authParam.setApplication(applicationData.getApplication());
        authParam.setEnv(deployParam.getEnv());
        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
        List<JSONObject> sysStatements = assignmentList.stream().filter(data -> !this.deployServiceV4.isUcOrNot(data)).collect(Collectors.toList());
        Map actionCodeModleIdMap = this.getAppIamActionModelInfo(deployParam.getEnv(), applicationData.getApplication(), moduleId);
        for (JSONObject needAuthorizeAbiStatement : assignmentList) {
            boolean isAbi = this.isAbiStatement(needAuthorizeAbiStatement.getString("pattern"), needAuthorizeAbiStatement.getString("category"));
            String modelId = needAuthorizeAbiStatement.getString("modelId");
            String path = needAuthorizeAbiStatement.getString("path");
            String actionCode = needAuthorizeAbiStatement.getString("code");
            Set actionCodes = actionCodeModleIdMap.keySet();
            String iamModelId = null;
            String iamPath = null;
            JSONObject action = (JSONObject)actionCodeModleIdMap.get(actionCode);
            if (Objects.isNull(action) || action.size() == 0) {
                iamModelId = null;
                iamPath = null;
            } else {
                iamModelId = StrUtil.isEmpty((CharSequence)action.getString("modelId")) ? null : action.getString("modelId");
                JSONArray right = action.getJSONArray("paths");
                if (Objects.nonNull(right) && right.size() > 0) {
                    List stringList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)right), String.class);
                    iamPath = String.join((CharSequence)",", stringList);
                }
            }
            Boolean updateCommonAction = false;
            if (applicationInfoDto != null && (Objects.equals(applicationInfoDto.getAppType(), 6) || Objects.equals(applicationInfoDto.getAppType(), 12))) {
                updateCommonAction = true;
            } else if (actionCodes.contains(actionCode)) {
                boolean pathIsChange;
                boolean modelIdIsChange = modelId == null && iamModelId == null || iamModelId != null && iamModelId.equals(modelId);
                boolean bl = pathIsChange = path == null && iamPath == null || iamPath != null && iamPath.equals(path);
                if (!isAbi) {
                    if (modelIdIsChange) continue;
                    updateCommonAction = true;
                } else {
                    if (pathIsChange) continue;
                    updateCommonAction = true;
                }
            }
            IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam = new IamAssignmentAuthorizeParam();
            iamAssignmentAuthorizeParam.setEnv(deployParam.getEnv());
            iamAssignmentAuthorizeParam.setTenantUsers(deployParam.getTenantUsers());
            iamAssignmentAuthorizeParam.setCurrentUser(AthenaUserLocal.getUser());
            iamAssignmentAuthorizeParam.setApplication(applicationData.getApplication());
            iamAssignmentAuthorizeParam.setModuleId(this.getIamModuleId());
            iamAssignmentAuthorizeParam.setIndividual(Boolean.valueOf(applicationInfoDto != null ? applicationInfoDto.isIndividual() : false));
            JSONObject assignment = new JSONObject();
            assignment.put("code", (Object)actionCode);
            assignment.put("tenantId", needAuthorizeAbiStatement.get((Object)"tenantId"));
            assignment.put("name", needAuthorizeAbiStatement.get((Object)"name"));
            if (!isAbi) {
                assignment.put("modelId", (Object)modelId);
                if (this.isTbbStatement(needAuthorizeAbiStatement.getString("pattern"), needAuthorizeAbiStatement.getString("category")).booleanValue() || this.isCustomStatement(needAuthorizeAbiStatement.getString("pattern"), needAuthorizeAbiStatement.getString("category")).booleanValue()) {
                    assignment.put("type", (Object)needAuthorizeAbiStatement.getString("category"));
                }
            }
            assignment.put("modelId", (Object)modelId);
            if (StringUtils.isNotEmpty((CharSequence)needAuthorizeAbiStatement.getString("parentId"))) {
                assignment.put("parentId", needAuthorizeAbiStatement.get((Object)"parentId"));
            }
            assignment.put("updateCommonAction", (Object)updateCommonAction);
            if (isAbi) {
                assignment.put("type", (Object)"ABI-STATEMENT");
                assignment.put("path", (Object)path);
            }
            iamAssignmentAuthorizeParam.setAssignment(assignment);
            if (this.deployServiceV4.isUcOrNot(assignment)) {
                List users = this.deployServiceV4.getTenantUsersByTenantId(applicationData.getApplication(), assignment.getString("tenantId"), user.getToken(), deployParam.getEnv());
                iamAssignmentAuthorizeParam.setTenantUsers(users);
            }
            authParam.getIamAssignmentAuthorizeParams().add(iamAssignmentAuthorizeParam);
        }
        if (CollUtil.isNotEmpty(sysStatements)) {
            IamAddPolicyParam iamAddPolicyParam = new IamAddPolicyParam();
            iamAddPolicyParam.setToken(user.getToken()).setTenantUsers(deployParam.getTenantUsers()).setApplication(applicationData.getApplication()).setModuleId(this.getIamModuleId()).setEnv(deployParam.getEnv()).setIndividual(Boolean.valueOf(applicationInfoDto != null ? applicationInfoDto.isIndividual() : false));
            sysStatements.forEach(sysStatement -> {
                JSONObject statement = new JSONObject();
                statement.put("code", sysStatement.get((Object)"code"));
                statement.put("name", sysStatement.get((Object)"name"));
                iamAddPolicyParam.getAssignmentList().add(statement);
            });
            authParam.getIamAddPolicyParam().add(iamAddPolicyParam);
        }
        return authParam;
    }

    AuthParam standardAllStatementAuthParam(DeployParamV3 deployParam, List<JSONObject> assignmentList, List<JSONObject> needAuthStatements, ApplicationData applicationData, String moduleId) {
        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
        String applicationCode = applicationInfoDto.isIndividual() ? applicationInfoDto.getSourceApplicationCode() : applicationInfoDto.getCode();
        AuthParam authParam = new AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        authParam.setCommonApp(Boolean.valueOf(false));
        authParam.setUser(user);
        authParam.setApplication(applicationData.getApplication());
        authParam.setEnv(deployParam.getEnv());
        List<JSONObject> sysStatements = needAuthStatements.stream().filter(data -> !this.deployServiceV4.isUcOrNot(data)).collect(Collectors.toList());
        Set needAuthCodes = needAuthStatements.stream().map(j -> j.getString("code")).collect(Collectors.toSet());
        Map actionCodeModleIdMap = this.getAppIamActionModelInfo(deployParam.getEnv(), applicationCode, moduleId);
        for (JSONObject statement : assignmentList) {
            boolean isAbi = this.isAbiStatement(statement.getString("pattern"), statement.getString("category"));
            String modelId = statement.getString("modelId");
            String path = statement.getString("path");
            String actionCode = statement.getString("code");
            Boolean regardlessAuth = !needAuthCodes.contains(actionCode);
            Set actionCodes = actionCodeModleIdMap.keySet();
            String iamModelId = null;
            String iamPath = null;
            Boolean iamRegardlessAuth = null;
            JSONObject action = (JSONObject)actionCodeModleIdMap.get(actionCode);
            if (Objects.isNull(action) || action.size() == 0) {
                iamModelId = null;
                iamPath = null;
                iamRegardlessAuth = null;
            } else {
                iamModelId = StrUtil.isEmpty((CharSequence)action.getString("modelId")) ? null : action.getString("modelId");
                iamRegardlessAuth = action.getBoolean("regardlessAuth");
                JSONArray right = action.getJSONArray("paths");
                if (Objects.nonNull(right) && right.size() > 0) {
                    List stringList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)right), String.class);
                    iamPath = String.join((CharSequence)",", stringList);
                }
            }
            Boolean updateCommonAction = false;
            if (actionCodes.contains(actionCode)) {
                boolean modelIdIsNoChange = modelId == null && iamModelId == null || iamModelId != null && iamModelId.equals(modelId);
                boolean pathIsNoChange = path == null && iamPath == null || iamPath != null && iamPath.equals(path);
                boolean regardlessAuthIsNoChange = regardlessAuth.equals(iamRegardlessAuth);
                if (modelIdIsNoChange && pathIsNoChange && regardlessAuthIsNoChange) continue;
                updateCommonAction = true;
            }
            IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam = new IamAssignmentAuthorizeParam();
            iamAssignmentAuthorizeParam.setEnv(deployParam.getEnv());
            iamAssignmentAuthorizeParam.setTenantUsers(deployParam.getTenantUsers());
            iamAssignmentAuthorizeParam.setCurrentUser(AthenaUserLocal.getUser());
            iamAssignmentAuthorizeParam.setApplication(applicationCode);
            iamAssignmentAuthorizeParam.setModuleId(this.getIamModuleId());
            iamAssignmentAuthorizeParam.setIndividual(Boolean.valueOf(applicationInfoDto != null ? applicationInfoDto.isIndividual() : false));
            JSONObject assignment = new JSONObject();
            assignment.put("code", (Object)actionCode);
            assignment.put("tenantId", statement.get((Object)"tenantId"));
            assignment.put("name", statement.get((Object)"name"));
            assignment.put("regardlessAuth", (Object)regardlessAuth);
            if (!isAbi) {
                assignment.put("modelId", (Object)modelId);
                if (this.isTbbStatement(statement.getString("pattern"), statement.getString("category")).booleanValue() || this.isCustomStatement(statement.getString("pattern"), statement.getString("category")).booleanValue()) {
                    assignment.put("type", (Object)statement.getString("category"));
                }
            }
            assignment.put("modelId", (Object)modelId);
            if (StringUtils.isNotEmpty((CharSequence)statement.getString("parentId"))) {
                assignment.put("parentId", statement.get((Object)"parentId"));
            }
            assignment.put("updateCommonAction", (Object)updateCommonAction);
            if (isAbi) {
                assignment.put("type", (Object)"ABI-STATEMENT");
                assignment.put("path", (Object)path);
            }
            iamAssignmentAuthorizeParam.setAssignment(assignment);
            if (this.deployServiceV4.isUcOrNot(assignment)) {
                List users = this.deployServiceV4.getTenantUsersByTenantId(applicationCode, assignment.getString("tenantId"), user.getToken(), deployParam.getEnv());
                iamAssignmentAuthorizeParam.setTenantUsers(users);
            }
            authParam.getIamAssignmentAuthorizeParams().add(iamAssignmentAuthorizeParam);
        }
        if (CollUtil.isNotEmpty(sysStatements)) {
            IamAddPolicyParam iamAddPolicyParam = new IamAddPolicyParam();
            iamAddPolicyParam.setToken(user.getToken()).setTenantUsers(deployParam.getTenantUsers()).setApplication(applicationCode).setModuleId(this.getIamModuleId()).setEnv(deployParam.getEnv()).setIndividual(Boolean.valueOf(applicationInfoDto != null ? applicationInfoDto.isIndividual() : false));
            sysStatements.forEach(sysStatement -> {
                JSONObject statement = new JSONObject();
                statement.put("code", sysStatement.get((Object)"code"));
                statement.put("name", sysStatement.get((Object)"name"));
                iamAddPolicyParam.getAssignmentList().add(statement);
            });
            authParam.getIamAddPolicyParam().add(iamAddPolicyParam);
        }
        return authParam;
    }

    protected void individualIamAuth(DeployTask task, AuthParam authParam, List<TenantUser> testTenants) {
        if (authParam.getCommonApp().booleanValue()) {
            this.commonIamAssignmentAuthorize(task, authParam);
            if (CollUtil.isNotEmpty(testTenants)) {
                this.commonIamAddPolicy(task, authParam);
            }
        } else {
            this.iamAssignmentAuthorize(task, authParam);
            if (CollUtil.isNotEmpty(testTenants)) {
                this.iamAddPolicy(task, authParam);
            }
        }
    }

    protected DeployTask initIndividualIamAuthSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        DeployLog lastPublishLog = this.deployLogDao.findLastPublishLog(EnvOperateEnum.PUBLISH.getOperate(), env.getEnv(), applicationData.getApplication());
        DeployTask lastDeployTask = this.deployTaskDao.selectByApplicationAndDeployNoAndType(applicationData.getApplication(), lastPublishLog.getDeployNo(), this.getDeployType().getType());
        if (lastDeployTask == null) {
            return null;
        }
        List publishTenantUsers = lastDeployTask.getTenantUsers();
        DeployTask switchTask = this.initSwitchTask(deployParam);
        List switchTenantUsers = switchTask.getTenantUsers();
        for (TenantUser switchTenantUser : switchTenantUsers) {
            for (TenantUser publishTenantUser : publishTenantUsers) {
                if (!switchTenantUser.getTenantId().equals(publishTenantUser.getTenantId())) continue;
                switchTenantUser.setTenantSid(publishTenantUser.getTenantSid());
            }
        }
        switchTask.setPublishParam(lastDeployTask.getPublishParam());
        return switchTask;
    }

    protected void individualAuthSwitch(DeployTask task) {
        AuthParam basicDataEntryAuthParam = (AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List prodTenants = this.getProdTenants(task);
        List iamAssignmentAuthorizeParams = basicDataEntryAuthParam.getIamAssignmentAuthorizeParams();
        iamAssignmentAuthorizeParams.forEach(i -> i.setTenantUsers(prodTenants));
        List codes = iamAssignmentAuthorizeParams.stream().map(i -> i.getAssignment().getString("code")).collect(Collectors.toList());
        if (codes.isEmpty()) {
            return;
        }
        this.individualIamAuth(task, basicDataEntryAuthParam, null);
    }

    protected void individualIamAuthPublish(DeployTask task) {
        AuthParam authParam = (AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List testTenants = this.getTestTenants(task);
        List iamAddPolicyParam = authParam.getIamAddPolicyParam();
        iamAddPolicyParam.forEach(i -> i.setTenantUsers(testTenants));
        List iamAssignmentAuthorizeParams = authParam.getIamAssignmentAuthorizeParams();
        iamAssignmentAuthorizeParams.forEach(i -> i.setTenantUsers(testTenants));
        List codes = iamAssignmentAuthorizeParams.stream().map(i -> i.getAssignment().getString("code")).collect(Collectors.toList());
        if (codes.isEmpty()) {
            return;
        }
        this.individualIamAuth(task, authParam, testTenants);
    }

    protected void createIamAuthInfoRecord(DeployTask task, String type, EnvOperateEnum operateEnum) {
        List tenants;
        IamAuthInfoRecord iamAuthInfoRecord = this.iamAuthInfoRecordDao.selectByApplicationAndEnv(task.getApplication(), task.getEnv());
        AuthParam authParam = (AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List iamAssignmentAuthorizeParams = authParam.getIamAssignmentAuthorizeParams();
        List codes = iamAssignmentAuthorizeParams.stream().map(i -> i.getAssignment().getString("code")).collect(Collectors.toList());
        if (codes.isEmpty()) {
            return;
        }
        if (iamAuthInfoRecord == null) {
            ApplicationInfoDto applicationInfoDto = task.getApplicationInfoDto();
            iamAuthInfoRecord = IamAuthInfoRecord.create((String)task.getApplication(), (String)applicationInfoDto.getSourceApplicationCode(), (String)task.getEnv());
            this.iamAuthInfoRecordDao.insert(iamAuthInfoRecord);
        }
        List list = tenants = operateEnum == EnvOperateEnum.PUBLISH ? this.getTestTenants(task) : this.getProdTenants(task);
        if ("dataEntry".equals(type)) {
            AbstractDeployTaskNode.recodeAuthInfo((List)tenants, codes, (List)iamAuthInfoRecord.getDataEntry());
        } else if ("tbbReport".equals(type)) {
            AbstractDeployTaskNode.recodeAuthInfo((List)tenants, codes, (List)iamAuthInfoRecord.getTbbReport());
        } else if ("abiReport".equals(type)) {
            AbstractDeployTaskNode.recodeAuthInfo((List)tenants, codes, (List)iamAuthInfoRecord.getAbiReport());
        } else if ("otherReport".equals(type)) {
            AbstractDeployTaskNode.recodeAuthInfo((List)tenants, codes, (List)iamAuthInfoRecord.getOtherReport());
        } else if ("startProject".equals(type)) {
            AbstractDeployTaskNode.recodeAuthInfo((List)tenants, codes, (List)iamAuthInfoRecord.getStartProject());
        }
        UserHelpUtils.fillEditInfo((Object)iamAuthInfoRecord);
        this.iamAuthInfoRecordDao.save(iamAuthInfoRecord);
    }

    protected Map<String, JSONObject> getAppIamActionModelInfo(String env, String appCode, String moduleId) {
        HashMap<String, JSONObject> actionModelInfo = new HashMap<String, JSONObject>();
        List actionList = this.deployServiceApiHelper.getIamPublicActions(env, appCode);
        if (CollUtil.isNotEmpty((Collection)actionList)) {
            if (moduleId == null) {
                actionList.forEach(action -> actionModelInfo.put(action.getString("id"), (JSONObject)action));
            } else {
                actionList.forEach(action -> {
                    if (moduleId.equals(action.getString("moduleId"))) {
                        actionModelInfo.put(action.getString("id"), (JSONObject)action);
                    }
                });
            }
        }
        return actionModelInfo;
    }

    List<JSONObject> filterNeedAuthSysStatements(List<JSONObject> needAuthorizeStatements) {
        return needAuthorizeStatements.stream().filter(data -> !this.deployServiceV4.isUcOrNot(data)).map(data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)data.getString("code"));
            jsonObject.put("name", (Object)data.getString("name"));
            jsonObject.put("lang", (Object)data.getJSONObject("lang"));
            jsonObject.put("moduleId", (Object)this.getIamModuleId());
            jsonObject.put("regardlessAuth", (Object)false);
            return jsonObject;
        }).collect(Collectors.toList());
    }

    List<JSONObject> filterNoNeedAuthStatements(List<JSONObject> abiStatementList, List<JSONObject> needAuthStatementList) {
        Set needAuthCode = needAuthStatementList.stream().map(j -> j.getString("id")).collect(Collectors.toSet());
        return abiStatementList.stream().filter(data -> !needAuthCode.contains(data.getString("code"))).map(data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)data.getString("code"));
            jsonObject.put("name", (Object)data.getString("name"));
            jsonObject.put("lang", (Object)data.getJSONObject("lang"));
            jsonObject.put("moduleId", (Object)this.getIamModuleId());
            jsonObject.put("regardlessAuth", (Object)true);
            return jsonObject;
        }).collect(Collectors.toList());
    }

    List<JSONObject> filterNeedAuthSysDataAsk(List<JSONObject> needAuthorizeStatements) {
        return needAuthorizeStatements.stream().filter(data -> !this.deployServiceV4.isUcOrNot(data)).map(data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)data.getString("code"));
            jsonObject.put("name", (Object)data.getString("name"));
            jsonObject.put("lang", (Object)data.getJSONObject("lang"));
            jsonObject.put("moduleId", (Object)this.getIamModuleId());
            jsonObject.put("iamCondition", data.get((Object)"condition"));
            return jsonObject;
        }).collect(Collectors.toList());
    }

    List<JSONObject> filterNeedAuthSysDataEntry(List<JSONObject> needAuthorizeStatements, Map map) {
        return needAuthorizeStatements.stream().filter(data -> !this.deployServiceV4.isUcOrNot(data)).map(data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)data.getString("code"));
            jsonObject.put("name", (Object)data.getString("name"));
            jsonObject.put("lang", (Object)data.getJSONObject("lang"));
            jsonObject.put("moduleId", (Object)this.getIamModuleId());
            jsonObject.put("regardlessAuth", (Object)false);
            jsonObject.put("iamCondition", map.get(data.getString("code")));
            return jsonObject;
        }).collect(Collectors.toList());
    }

    protected Long calculateExecuteMills(Date time) {
        Date now = new Date();
        long mills = now.getTime() - time.getTime();
        return mills;
    }

    protected void finishUpdateDetail(DeployDetailV2 deployDetailV2) {
        long mills = this.calculateExecuteMills(deployDetailV2.getTime());
        deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
        this.insertDeployDetail(deployDetailV2);
    }

    protected void assistantPublish(String application, String env, DeployTask task, String cn, String tw, String us, String userId, String version) {
        String name = task.getApplicationInfoDto().getName();
        String v5ContentLang = String.format("{\"content\":{\"en_US\":\"%s :Nana Assistant Launch\",\"zh_CN\":\"%s :\u5a1c\u5a1c\u52a9\u7406\u53d1\u5e03\",\"zh_TW\":\"%s :\u5a1c\u5a1c\u52a9\u7406\u767c\u4f48\"}}", us, cn, tw);
        Map v5Lang = (Map)JSONObject.parseObject((String)v5ContentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV5 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + "-\u5a1c\u5a1c\u52a9\u7406\u53d1\u5e03", v5Lang);
        try {
            this.backendApiHelper.assistantPublish(application, env, name, userId, version);
            deployDetailV5.setResult("success");
        }
        catch (Exception e) {
            String message = "\u5a1c\u5a1c\u52a9\u7406\u53d1\u5e03\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
            String errorMsg = e.toString();
            errorMsg = this.getErrorMessage(message, task, "assistantPublish", LogUtils.AADC_500_0007, "", errorMsg);
            deployDetailV5.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(errorMsg);
            throw e;
        }
        finally {
            this.finishUpdateDetail(deployDetailV5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncBackUri(String appType, String env, DeployTask task, String cn, String tw, String us) {
        String lang = String.format("{\"content\":{\"en_US\":\"%s :Sync BackUri To Iam\",\"zh_CN\":\"%s :\u6743\u9650\u56de\u8c03\u5730\u5740\u63a8\u9001\",\"zh_TW\":\"%s :\u6b0a\u9650\u56de\u8abf\u5730\u5740\u63a8\u9001\"}}", us, cn, tw);
        Map langMap = (Map)JSONObject.parseObject((String)lang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV5 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + "-\u6743\u9650\u56de\u8c03\u5730\u5740\u63a8\u9001", langMap);
        try {
            this.backendApiHelper.syncBackUri(task.getApplication(), appType, env);
            deployDetailV5.setResult("success");
        }
        catch (Exception e) {
            String message = "\u8c03IAM\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
            String errorMsg = e.toString();
            errorMsg = this.getErrorMessage(message, task, "syncBackUri", LogUtils.AADC_500_0007, "", errorMsg);
            deployDetailV5.setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(errorMsg);
        }
        finally {
            this.finishUpdateDetail(deployDetailV5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncPushData(DeployTask task, List<TenantUser> tenantUsers, String tenantId, String version, String env, String cn, String tw, String us) {
        String kmContentLang = String.format("{\"content\":{\"en_US\":\"%s :Sync Metric Scene Screen Dataset Info\",\"zh_CN\":\"%s :\u901a\u77e5KM\u63a8\u9001\u6570\u636e\",\"zh_TW\":\"%s :\u901a\u77e5km\u63a8\u9001\u6578\u64da\"}}", us, cn, tw);
        Map kmLang = (Map)JSONObject.parseObject((String)kmContentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV4 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + "-\u901a\u77e5KM\u63a8\u9001\u6570\u636e", kmLang);
        try {
            this.backendApiHelper.syncPushData(task.getApplication(), env, tenantUsers, tenantId, version);
            deployDetailV4.setResult("success");
        }
        catch (Exception e) {
            String message = "\u8c03KM\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
            String errorMsg = e.toString();
            errorMsg = this.getErrorMessage(message, task, "syncPushData", LogUtils.AADC_500_0007, "", errorMsg);
            deployDetailV4.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(errorMsg);
        }
        finally {
            this.finishUpdateDetail(deployDetailV4);
        }
    }

    @Deprecated
    protected DeployDetailV2 createStartDeployDetail(String taskType, String deployNo, String application, String content) {
        DeployTaskTypeEnum deployType = this.getDeployType();
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setContent(content).setResult("start").setTaskType(taskType).setLang(deployType != null ? this.getDeployType().getLang() : null).setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        return deployDetailV2;
    }

    protected DeployDetailV2 createStartDeployDetail(String taskType, String deployNo, String application, String content, Map<String, MultiLanguageDTO> lang) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setContent(content).setResult("start").setTaskType(taskType).setLang(lang).setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        return deployDetailV2;
    }

    protected Env getPublishEnv(String application, String envServiceId) {
        TenantPipeLine tenantPipeLine = this.releasePipeLineService.queryTenantPipelineByApplication(application);
        Node node = TenantPipelineHelper.findNodeByServiceId((TenantPipeLine)tenantPipeLine, (String)envServiceId);
        Env env = node.getEnvByOperate(EnvOperateEnum.PUBLISH.getOperate());
        return env;
    }

    protected <E> List<TenantUser> getTestTenants(DeployTask task) {
        ApplicationInfoDto applicationInfoDto = task.getApplicationInfoDto();
        List useTenantInfos = applicationInfoDto.getUseTenantInfos();
        List<TenantUser> tenantUsers = task.getTenantUsers();
        String env = task.getEnv();
        List allTenantInfos = useTenantInfos.stream().filter(t -> env.startsWith(t.getServiceId())).collect(Collectors.toList());
        log.info("allTenantInfos:" + JSONObject.toJSONString(allTenantInfos));
        tenantUsers = tenantUsers.stream().filter(t -> {
            for (TenantInfo allTenantInfo : allTenantInfos) {
                if (!allTenantInfo.getTenantId().equals(t.getTenantId())) continue;
                return allTenantInfo.getCustomerTenant() == null || allTenantInfo.getCustomerTenant() == false;
            }
            return false;
        }).collect(Collectors.toList());
        log.info("testTenantUsers:" + JSONObject.toJSONString(tenantUsers));
        return tenantUsers;
    }

    protected List<TenantUser> getProdTenants(DeployTask task) {
        ApplicationInfoDto applicationInfoDto = task.getApplicationInfoDto();
        List useTenantInfos = applicationInfoDto.getUseTenantInfos();
        List<TenantUser> tenantUsers = task.getTenantUsers();
        String env = task.getEnv();
        List allTenantInfos = useTenantInfos.stream().filter(t -> env.startsWith(t.getServiceId())).collect(Collectors.toList());
        tenantUsers = tenantUsers.stream().filter(t -> {
            for (TenantInfo allTenantInfo : allTenantInfos) {
                if (!allTenantInfo.getTenantId().equals(t.getTenantId())) continue;
                return allTenantInfo.getCustomerTenant() != null && allTenantInfo.getCustomerTenant() != false;
            }
            return false;
        }).collect(Collectors.toList());
        return tenantUsers;
    }

    protected static void recodeAuthInfo(List<TenantUser> tenants, List<String> codes, List<IamAuthInfoRecord.AuthInfo> authInfoList) {
        authInfoList.clear();
        for (String code : codes) {
            for (TenantUser tenantUser : tenants) {
                IamAuthInfoRecord.AuthInfo authInfo = new IamAuthInfoRecord.AuthInfo();
                authInfo.setCode(code);
                authInfo.setTenantId(tenantUser.getTenantId());
                authInfoList.add(authInfo);
            }
        }
    }

    protected void insertDeployDetail(DeployDetailV2 deployDetailV2) {
        this.deployDetailV2Dao.insert(deployDetailV2);
    }

    protected List<AdTemplatePublishInfoDto> generatePublishRecord(List<String> tenantIds, List<JSONObject> adTemplateList) {
        ArrayList<AdTemplatePublishInfoDto> res = new ArrayList<AdTemplatePublishInfoDto>();
        if (CollectionUtils.isEmpty(tenantIds) || CollectionUtils.isEmpty(adTemplateList)) {
            return res;
        }
        for (String tenantId : tenantIds) {
            for (JSONObject jsonObject : adTemplateList) {
                AdTemplatePublishInfoDto adTemplatePublishInfoDto = new AdTemplatePublishInfoDto();
                adTemplatePublishInfoDto.setId(jsonObject.getString("id"));
                adTemplatePublishInfoDto.setTenantId(tenantId);
                res.add(adTemplatePublishInfoDto);
            }
        }
        return res;
    }

    protected void stopAdTemplate(List<AdTemplatePublishInfoDto> stopInfo, String env) {
        HashMap<String, AdTemplatePublishParam> standard = new HashMap<String, AdTemplatePublishParam>();
        HashMap<String, AdTemplatePublishParam> individual = new HashMap<String, AdTemplatePublishParam>();
        for (AdTemplatePublishInfoDto adTemplatePublishInfoDto : stopInfo) {
            String tenantId = adTemplatePublishInfoDto.getTenantId();
            String id = adTemplatePublishInfoDto.getId();
            AdTemplatePublishParam adTemplatePublishParam = new AdTemplatePublishParam();
            adTemplatePublishParam.setCurrentUser(AthenaUserLocal.getUser());
            adTemplatePublishParam.setEnv(env);
            adTemplatePublishParam.setIsCustom(adTemplatePublishInfoDto.getIsCustom());
            JSONObject adTemplate = new JSONObject();
            adTemplate.put("id", (Object)id);
            adTemplatePublishParam.setAdTemplate(adTemplate);
            if (adTemplatePublishInfoDto.getIsCustom().equals(0)) {
                if (!standard.containsKey(id)) {
                    adTemplatePublishParam.setTenantIds(new HashSet());
                    standard.put(id, adTemplatePublishParam);
                } else {
                    adTemplatePublishParam = (AdTemplatePublishParam)standard.get(id);
                }
                adTemplatePublishParam.getTenantIds().add(tenantId);
                continue;
            }
            if (!individual.containsKey(id)) {
                adTemplatePublishParam.setTenantIds(new HashSet());
                individual.put(id, adTemplatePublishParam);
            } else {
                adTemplatePublishParam = (AdTemplatePublishParam)individual.get(id);
            }
            adTemplatePublishParam.getTenantIds().add(tenantId);
        }
        standard.values().forEach(a -> this.backendApiHelper.disableTemplateAllVersion(a));
        individual.values().forEach(a -> this.backendApiHelper.disableTemplateAllVersion(a));
    }
}

