/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployParamRecordDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.AdTemplatePublishParam;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.dto.deployer.AdTemplatePublishInfoDto;
import com.digiwin.athena.athenadeployer.service.DeployServiceV3;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.AdTemplatePublishTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdTemplatePublishTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdTemplatePublishTask.class);
    @Autowired
    private DeployServiceV3 deployServiceV3;
    private DeployParamRecordDao deployParamRecordDao;

    @Autowired
    public void setDeployParamRecordDao(DeployParamRecordDao deployParamRecordDao) {
        this.deployParamRecordDao = deployParamRecordDao;
    }

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List adTemplateList = parseCompileFileResult.getAdTemplateList();
        List ucAdTemplateList = parseCompileFileResult.getUcAdTemplateList();
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        if (CollUtil.isNotEmpty((Collection)adTemplateList) || CollUtil.isNotEmpty((Collection)ucAdTemplateList)) {
            DeployTask deployTask = this.initDeployTask(deployParam);
            AdTemplatePublishParma adTemplatePublishParma = new AdTemplatePublishParma();
            adTemplatePublishParma.setAdTemplateList(adTemplateList);
            adTemplatePublishParma.setUcAdTemplateList(ucAdTemplateList);
            adTemplatePublishParma.setApplication(applicationData.getApplication());
            adTemplatePublishParma.setTenantUsers(deployParam.getTenantUsers());
            adTemplatePublishParma.setEnv(deployParam.getEnv());
            deployTask.compressSetPublishParam((Object)adTemplatePublishParma);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List adTemplateList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "adTemplate", null);
        if (adTemplateList.isEmpty()) {
            return null;
        }
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AdTemplateSwitchParam adTemplateSwitchParam = new AdTemplateSwitchParam();
        adTemplateSwitchParam.setApplication(applicationData.getApplication());
        adTemplateSwitchParam.setEnv(deployParam.getEnv());
        adTemplateSwitchParam.setUser(AthenaUserLocal.getUser());
        adTemplateSwitchParam.setTenantUsers(deployParam.getTenantUsers());
        adTemplateSwitchParam.setAdTemplateList(adTemplateList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList()));
        deployTask.compressSetPublishParam((Object)adTemplateSwitchParam);
        return deployTask;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("AdTemplatePublishTask executing");
        AdTemplatePublishParma adTemplatePublishParma = (AdTemplatePublishParma)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List adTemplateList = adTemplatePublishParma.getAdTemplateList();
        List ucAdTemplateList = adTemplatePublishParma.getUcAdTemplateList();
        DeployParamRecord oldDeployParamRecord = this.deployParamRecordDao.selectOneByApplicationAndEnvAndType(task.getApplication(), task.getEnv(), "adTemplateStopInfo");
        if (oldDeployParamRecord == null) {
            oldDeployParamRecord = new DeployParamRecord().setApplication(task.getApplication()).setEnv(task.getEnv()).setType("adTemplateStopInfo");
            this.deployParamRecordDao.insert(oldDeployParamRecord);
        }
        if (CollUtil.isNotEmpty((Collection)adTemplateList) || CollUtil.isNotEmpty((Collection)ucAdTemplateList)) {
            String application = adTemplatePublishParma.getApplication();
            String env = adTemplatePublishParma.getEnv();
            List tenantUsers = adTemplatePublishParma.getTenantUsers();
            this.deployServiceV4.recordLatestDeployParam(application, env, task.getCompileDataCode(), "adTemplate", adTemplateList);
            this.deployServiceV4.recordLatestDeployParam(application, env, task.getCompileDataCode(), "ucAdTemplate", ucAdTemplateList);
            this.adTemplatePublish(tenantUsers, env, adTemplateList);
            this.adTemplatePublish(tenantUsers, env, ucAdTemplateList);
            List adTemplatePublishInfos = this.convertAdTemplatePublishInfoDto(tenantUsers, adTemplateList, ucAdTemplateList);
            oldDeployParamRecord.setContent((Object)adTemplatePublishInfos);
        } else {
            oldDeployParamRecord.setContent(new ArrayList());
        }
        this.deployParamRecordDao.save(oldDeployParamRecord);
    }

    private List<AdTemplatePublishInfoDto> convertAdTemplatePublishInfoDto(List<TenantUser> tenantUsers, List<JSONObject> adTemplateList, List<JSONObject> ucAdTemplateList) {
        List adTemplatePublishInfos = this.generatePublishRecord(tenantUsers.stream().map(TenantUser::getTenantId).collect(Collectors.toList()), adTemplateList);
        adTemplatePublishInfos.forEach(a -> a.setIsCustom(Integer.valueOf(0)));
        if (!ucAdTemplateList.isEmpty()) {
            for (JSONObject jsonObject : ucAdTemplateList) {
                List ucAdTemplatePublishInfos = this.generatePublishRecord(Arrays.asList(jsonObject.getString("tenantId").split(";")), Arrays.asList(jsonObject));
                for (AdTemplatePublishInfoDto ucAdTemplatePublishInfo : ucAdTemplatePublishInfos) {
                    ucAdTemplatePublishInfo.setIsCustom(Integer.valueOf(1));
                    adTemplatePublishInfos.add(ucAdTemplatePublishInfo);
                }
            }
        }
        return adTemplatePublishInfos;
    }

    protected void doSwitchExecute(DeployTask task) {
        AdTemplateSwitchParam adTemplateSwitchParam = (AdTemplateSwitchParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List adTemplateList = adTemplateSwitchParam.getAdTemplateList();
        String env = adTemplateSwitchParam.getEnv();
        AthenaUser user = adTemplateSwitchParam.getUser();
        List tenantUsers = adTemplateSwitchParam.getTenantUsers();
        DeployParamRecord oldDeployParamRecord = this.deployParamRecordDao.selectOneByApplicationAndEnvAndType(task.getApplication(), task.getEnv(), "adTemplateStopInfo");
        if (oldDeployParamRecord == null) {
            oldDeployParamRecord = new DeployParamRecord().setApplication(task.getApplication()).setEnv(task.getEnv()).setType("adTemplateStopInfo");
            this.deployParamRecordDao.insert(oldDeployParamRecord);
        }
        ArrayList<AdTemplatePublishInfoDto> res = new ArrayList<AdTemplatePublishInfoDto>();
        oldDeployParamRecord.setContent(res);
        for (JSONObject adTemplate : adTemplateList) {
            AdTemplatePublishParam adTemplatePublishParam = new AdTemplatePublishParam();
            adTemplatePublishParam.setAdTemplate(adTemplate).setEnv(env).setCurrentUser(user).setTenantUsers(tenantUsers).setNeedRouterKey(Boolean.valueOf(true)).setIsCustom(Integer.valueOf(0));
            this.backendApiHelper.publishScDispatcherTemplate(adTemplatePublishParam);
            AdTemplatePublishInfoDto adTemplatePublishInfoDto = new AdTemplatePublishInfoDto();
            adTemplatePublishInfoDto.setId(adTemplate.getString("id"));
            adTemplatePublishInfoDto.setIsCustom(Integer.valueOf(0));
            res.add(adTemplatePublishInfoDto);
        }
        this.deployParamRecordDao.save(oldDeployParamRecord);
    }

    protected void adTemplatePublish(List<TenantUser> tenantUsers, String env, List<JSONObject> adTemplateList) {
        for (JSONObject adTemplate : adTemplateList) {
            AdTemplatePublishParam adTemplatePublishParam = new AdTemplatePublishParam();
            adTemplatePublishParam.setAdTemplate(adTemplate).setEnv(env).setCurrentUser(AthenaUserLocal.getUser()).setTenantUsers(tenantUsers);
            String tenantId = adTemplate.getString("tenantId");
            adTemplatePublishParam.setIsCustom(Integer.valueOf(0));
            if (tenantId != null && !tenantId.equals("SYSTEM")) {
                String[] ucTenantIdList = tenantId.split(";");
                ArrayList<TenantUser> ucTenantUsers = new ArrayList<TenantUser>();
                for (String ti : ucTenantIdList) {
                    ucTenantUsers.add(new TenantUser().setTenantId(ti));
                }
                adTemplatePublishParam.setTenantUsers(ucTenantUsers);
                adTemplatePublishParam.setIsCustom(Integer.valueOf(1));
            }
            this.backendApiHelper.adTemplatePublish(adTemplatePublishParam);
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.ADTEMPLATE_PUBLISH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.ADTEMPLATE_SWITCH;
    }
}

