/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployParamRecordDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.dto.deployer.AdTemplatePublishInfoDto;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AdTemplateStopTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdTemplateStopTask.class);
    private DeployParamRecordDao deployParamRecordDao;

    @Autowired
    public void setDeployParamRecordDao(DeployParamRecordDao deployParamRecordDao) {
        this.deployParamRecordDao = deployParamRecordDao;
    }

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List needStopTemplateInfo;
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        DeployParamRecord deployParamRecord = this.deployParamRecordDao.selectOneByApplicationAndEnvAndType(applicationData.getApplication(), deployParam.getEnv(), "adTemplateStopInfo");
        if (deployParamRecord == null) {
            return null;
        }
        List adTemplateList = parseCompileFileResult.getAdTemplateList();
        List ucAdTemplateList = parseCompileFileResult.getUcAdTemplateList();
        List adTemplatePublishInfos = this.generatePublishRecord(deployParam.getTenantUsers().stream().map(TenantUser::getTenantId).collect(Collectors.toList()), adTemplateList);
        adTemplatePublishInfos.forEach(a -> a.setIsCustom(Integer.valueOf(0)));
        if (!ucAdTemplateList.isEmpty()) {
            for (JSONObject jsonObject : ucAdTemplateList) {
                List ucAdTemplatePublishInfos = this.generatePublishRecord(Arrays.asList(jsonObject.getString("tenantId").split(";")), Arrays.asList(jsonObject));
                for (AdTemplatePublishInfoDto ucAdTemplatePublishInfo : ucAdTemplatePublishInfos) {
                    ucAdTemplatePublishInfo.setIsCustom(Integer.valueOf(1));
                    adTemplatePublishInfos.add(ucAdTemplatePublishInfo);
                }
            }
        }
        if ((needStopTemplateInfo = this.getNeedStopInfo(deployParamRecord, adTemplatePublishInfos)).isEmpty()) {
            return null;
        }
        DeployTask deployTask = this.initDeployTask(deployParam);
        deployTask.compressSetPublishParam((Object)needStopTemplateInfo);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        List<Object> oldAdTemplateSwitchInfos;
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        DeployParamRecord deployParamRecord = this.deployParamRecordDao.selectOneByApplicationAndEnvAndType(applicationData.getApplication(), env.getEnv(), "adTemplateStopInfo");
        DeployParamRecord switchParamRecord = this.deployParamRecordDao.selectOneByApplicationAndEnvAndType(applicationData.getApplication(), deployParam.getEnv(), "adTemplateStopInfo");
        List adTemplateParamRecords = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "adTemplate", null);
        List adTemplateList = adTemplateParamRecords.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        if (deployParamRecord == null && switchParamRecord == null) {
            return null;
        }
        ArrayList oldAdTemplatePublishInfos = deployParamRecord != null && deployParamRecord.getContent() != null ? (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)deployParamRecord.getContent()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]) : new ArrayList();
        List list = oldAdTemplateSwitchInfos = switchParamRecord != null && switchParamRecord.getContent() != null ? (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)switchParamRecord.getContent()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]) : new ArrayList();
        if (!CollectionUtils.isEmpty(adTemplateList)) {
            Set switchAdTemplateIds = adTemplateList.stream().map(a -> a.getString("id")).collect(Collectors.toSet());
            oldAdTemplateSwitchInfos = oldAdTemplateSwitchInfos.stream().filter(a -> !switchAdTemplateIds.contains(a.getId())).collect(Collectors.toList());
        }
        List needStopTemplateInfo = oldAdTemplatePublishInfos.stream().filter(a -> a.getIsCustom().equals(0)).collect(Collectors.toList());
        DeployTask deployTask = this.initSwitchTask(deployParam);
        HashMap<String, List<Object>> param = new HashMap<String, List<Object>>();
        if (oldAdTemplatePublishInfos.isEmpty() && needStopTemplateInfo.isEmpty()) {
            return null;
        }
        param.put("sysLevel", oldAdTemplateSwitchInfos);
        param.put("tenantLevel", needStopTemplateInfo);
        deployTask.compressSetPublishParam(param);
        return deployTask;
    }

    public static void main(String[] args) {
        List adTemplatePublishInfoDtos = (List)JSONObject.parseObject((String)JSONObject.toJSONString(null), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        ArrayList oldAdTemplateSwitchInfos = new ArrayList();
        ArrayList adTemplateList = new ArrayList();
        Set switchAdTemplateIds = adTemplateList.stream().map(a -> a.getString("id")).collect(Collectors.toSet());
        oldAdTemplateSwitchInfos.stream().filter(a -> !switchAdTemplateIds.contains(a.getId())).collect(Collectors.toList());
    }

    private List<AdTemplatePublishInfoDto> getNeedStopInfo(DeployParamRecord oldDeployParamRecord, List<AdTemplatePublishInfoDto> newAdTemplatePublishInfos) {
        List oldAdTemplatePublishInfos = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oldDeployParamRecord.getContent()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (CollectionUtils.isEmpty((Collection)oldAdTemplatePublishInfos)) {
            return new ArrayList<AdTemplatePublishInfoDto>();
        }
        return oldAdTemplatePublishInfos.stream().filter(o -> {
            for (AdTemplatePublishInfoDto newAdTemplatePublishInfo : newAdTemplatePublishInfos) {
                if (!newAdTemplatePublishInfo.getId().equals(o.getId()) || !newAdTemplatePublishInfo.getTenantId().equals(o.getTenantId()) || !newAdTemplatePublishInfo.getIsCustom().equals(o.getIsCustom())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.ADTEMPLATE_PUBLISH_STOP;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.ADTEMPLATE_SWITCH_STOP;
    }

    protected void doDeployExecute(DeployTask task) {
        List stopInfo = (List)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.stopAdTemplate(stopInfo, task.getEnv());
    }

    protected void doSwitchExecute(DeployTask task) {
        List sysLevelATemplatePublishInfos;
        Map stopInfo = (Map)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List tenantLevelATemplatePublishInfos = (List)stopInfo.get("tenantLevel");
        if (!CollectionUtils.isEmpty((Collection)tenantLevelATemplatePublishInfos)) {
            this.stopAdTemplate(tenantLevelATemplatePublishInfos, task.getEnv());
        }
        if (!CollectionUtils.isEmpty((Collection)(sysLevelATemplatePublishInfos = (List)stopInfo.get("sysLevel")))) {
            sysLevelATemplatePublishInfos.forEach(a -> a.setTenantId(""));
            this.stopAdTemplate(sysLevelATemplatePublishInfos, task.getEnv());
        }
    }
}

