/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.dao.mongo.AssetDefinitionRecordDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AssetDefinitionRecord;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AssetRefValidateTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetRefValidateTask.class);
    private AssetDefinitionRecordDao assetDefinitionRecordDao;

    @Autowired
    public void setAssetDefinitionRecordDao(AssetDefinitionRecordDao assetDefinitionRecordDao) {
        this.assetDefinitionRecordDao = assetDefinitionRecordDao;
    }

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List assetDefinitionList = parseCompileFileResult.getAssetDefinitionList();
        List assetRelationList = parseCompileFileResult.getAssetRelationList();
        if (assetDefinitionList.isEmpty() && assetRelationList.isEmpty()) {
            return null;
        }
        DeployTask deployTask = this.initDeployTask(deployParam);
        HashMap<String, List> param = new HashMap<String, List>();
        param.put("assetDefinitionList", assetDefinitionList);
        param.put("assetRelationList", assetRelationList);
        deployTask.compressSetPublishParam(param);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        DeployLog deployLog = this.deployLogDao.findLastPublishLog("publish", env.getEnv(), applicationData.getApplication());
        DeployTask deployTask = this.deployTaskDao.selectByApplicationAndDeployNoAndType(applicationData.getApplication(), deployLog.getDeployNo(), this.getDeployType().getType());
        if (deployTask == null) {
            return null;
        }
        DeployTask switchTask = this.initSwitchTask(deployParam);
        switchTask.setPublishParam(deployTask.getPublishParam());
        return switchTask;
    }

    protected void doDeployExecute(DeployTask task) {
        Map param = (Map)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.validate(task, param);
    }

    private void validate(DeployTask task, Map<String, List<JSONObject>> param) {
        List assetIds;
        List<JSONObject> assetDefinitionList = param.get("assetDefinitionList");
        List<JSONObject> assetRelationList = param.get("assetRelationList");
        ArrayList<AssetDefinitionRecord> assetDefinitionRecordList = new ArrayList<AssetDefinitionRecord>();
        for (JSONObject jsonObject : assetDefinitionList) {
            AssetDefinitionRecord assetDefinitionRecord = (AssetDefinitionRecord)JSONObject.parseObject((String)jsonObject.toJSONString(), AssetDefinitionRecord.class);
            assetDefinitionRecord.setEnv(task.getEnv());
            assetDefinitionRecordList.add(assetDefinitionRecord);
        }
        this.assetDefinitionRecordDao.deleteByApplicationAndEnv(task.getApplication(), task.getEnv());
        if (!assetDefinitionRecordList.isEmpty()) {
            this.assetDefinitionRecordDao.insertAll(assetDefinitionRecordList);
        }
        if (!(assetIds = assetRelationList.stream().map(a -> a.getString("assetId")).collect(Collectors.toList())).isEmpty()) {
            Collection existAssetIds = this.assetDefinitionRecordDao.selectByAssetIdAndEnv(assetIds, task.getEnv());
            Iterator<JSONObject> iterator = assetRelationList.iterator();
            while (iterator.hasNext()) {
                JSONObject next = iterator.next();
                if (!existAssetIds.contains(next.getString("assetId"))) continue;
                iterator.remove();
            }
            if (!assetRelationList.isEmpty()) {
                HashMap map = new HashMap();
                String message = "\u8d44\u4ea7id:%s,\u4e1a\u52a1code:%s \u672a\u53d1\u7248\u5230\u5bf9\u5e94\u7684\u73af\u5883";
                for (JSONObject jsonObject : assetRelationList) {
                    List<String> res;
                    String format = String.format(message, jsonObject.getString("assetId"), jsonObject.containsKey((Object)"code") ? jsonObject.getString("code") : "");
                    if (!map.containsKey(jsonObject.getString("type"))) {
                        res = new ArrayList<String>();
                        res.add(format);
                        map.put((CallSite)((Object)("\u8d44\u4ea7\u7c7b\u578b" + jsonObject.getString("bizType"))), res);
                        continue;
                    }
                    res = (List)map.get(jsonObject.getString("type"));
                    res.add(format);
                }
                throw new RuntimeException("\u5f15\u7528\u8d44\u4ea7\u6821\u9a8c\u5931\u8d25:" + JSONObject.toJSONString(map));
            }
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        Map param = (Map)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.validate(task, param);
    }

    public String deployDetailLevel() {
        return "warn";
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.ASSET_REF_VALIDATE;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.ASSET_REF_VALIDATE;
    }
}

