/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BasicDataEntryAuthTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicDataEntryAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List dataEntryList = parseCompileFileResult.getDataEntryList();
        List activityConfigList = parseCompileFileResult.getActivityConfigList();
        List needAuthorizeDataEntries = this.deployServiceV4.filterNeedAuthStatements(activityConfigList, dataEntryList);
        if (CollUtil.isNotEmpty((Collection)dataEntryList)) {
            DeployTask deployTask = this.initDeployTask(deployParam);
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            Boolean commonApp = this.getCommonApp(parseCompileFileResult);
            AbstractDeployTaskNode.AuthParam authParam = commonApp != false ? this.commonAllStatementAuthParam(deployParam, dataEntryList, needAuthorizeDataEntries, applicationData, parseCompileFileResult) : this.standardAllStatementAuthParam(deployParam, dataEntryList, needAuthorizeDataEntries, applicationData, this.getIamModuleId());
            Map<String, Object> codeIamMap = activityConfigList.stream().filter(config -> {
                String prefix = config.getString("authorityPrefix");
                Object iamCondition = config.get((Object)"iamCondition");
                return StrUtil.isNotBlank((CharSequence)prefix) && Objects.nonNull(iamCondition);
            }).collect(Collectors.toMap(config -> config.getString("code"), config -> config.get((Object)"iamCondition"), (oldValue, newValue) -> oldValue));
            List jsonObjects = this.filterNeedAuthSysDataEntry(needAuthorizeDataEntries, codeIamMap);
            jsonObjects.addAll(this.filterNoNeedAuthStatements(dataEntryList, jsonObjects));
            authParam.setNeedAuthorizeSys(jsonObjects);
            deployTask.compressSetPublishParam((Object)authParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List dataRntryList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "needAuthorizeDataEntrys", null);
        if (dataRntryList.isEmpty()) {
            return null;
        }
        List applications = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "application", null);
        JSONObject appJson = ((DeployParamRecord)applications.get(0)).getValue();
        Boolean commonApp = appJson.getBoolean("commonApp");
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AbstractDeployTaskNode.AuthParam authParam = new AbstractDeployTaskNode.AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        List assignmentList = dataRntryList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        authParam.setCommonApp(commonApp);
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(user.getTenantId()).setAssignmentList(assignmentList).setToken(user.getToken()).setApplication(applicationData.getApplication()).setEnv(deployParam.getEnv()).setAppJson(appJson).setNeedButtonAuth(Boolean.valueOf(true));
        authParam.setGmcUpdateParam(gmcUpdateParam);
        deployTask.compressSetPublishParam((Object)authParam);
        return deployTask;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("BasicDataEntryAuthTask executing");
        AbstractDeployTaskNode.AuthParam basicDataEntryAuthParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (basicDataEntryAuthParam.getCommonApp().booleanValue()) {
            this.commonIamAssignmentAuthorize(task, basicDataEntryAuthParam);
            this.commonIamAddPolicy(task, basicDataEntryAuthParam);
        } else {
            this.iamAssignmentAuthorize(task, basicDataEntryAuthParam);
            this.iamAddPolicy(task, basicDataEntryAuthParam);
        }
        this.deployServiceV4.recordLatestDeployParam(basicDataEntryAuthParam.getApplication(), basicDataEntryAuthParam.getEnv(), task.getCompileDataCode(), "needAuthorizeDataEntrys", basicDataEntryAuthParam.getNeedAuthorizeSys());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("BasicDataEntryAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        GmcUpdateParam gmcUpdateParam = authParam.getGmcUpdateParam();
        gmcUpdateParam.setNeedDelAuthKeyAssignMap(this.getAssignmentHistoryAuthKeyMap(task));
        log.info("BasicDataEntryAuthTask doSwitchExecute  updateGmcMoudle param= {}", (Object)JSONObject.toJSONString((Object)gmcUpdateParam));
        if (authParam.getCommonApp().booleanValue()) {
            gmcUpdateParam.setVersion(EnvOperateEnum.SWITCH.getVersion());
            this.backendApiHelper.updateCommonGmcMoudle(gmcUpdateParam);
        } else {
            this.backendApiHelper.updateGmcMoudle(gmcUpdateParam);
        }
        this.deployServiceV4.recordLatestDeployParam(gmcUpdateParam.getApplication(), gmcUpdateParam.getEnv(), task.getDeployNo(), "needAuthorizeKeyDataEntrys", gmcUpdateParam.getAssignmentList());
    }

    private JSONObject getAssignmentHistoryAuthKeyMap(DeployTask task) {
        JSONObject assignmentMap = new JSONObject();
        List dataRntryList = this.deployServiceV4.queryDeployParamRecords(task.getApplication(), task.getEnv(), "needAuthorizeKeyDataEntrys", null);
        List assignmentList = dataRntryList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        for (JSONObject assignment : assignmentList) {
            if (!CollectionUtil.isNotEmpty((Map)assignment)) continue;
            ArrayList<String> authKeyList = new ArrayList<String>();
            JSONArray iamCondition = assignment.getJSONArray("iamCondition");
            if (!Objects.nonNull(iamCondition) || iamCondition.isEmpty()) continue;
            for (Object object : iamCondition) {
                JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(object));
                authKeyList.add(jsonObject.getString("key"));
            }
            assignmentMap.put(assignment.getString("id"), authKeyList);
        }
        return assignmentMap;
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.BASIC_DATA_ENTRY_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.BASIC_DATA_ENTRY_AUTH;
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return true;
    }

    String getIamModuleId() {
        return "basicDataEntry";
    }
}

