/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.IamAssignmentAuthorizeParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ClassificationAuthTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassificationAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List metricAndScene;
        if (deployParam.getEnvServiceId().equals("HuaweiProd")) {
            return null;
        }
        List triggerList = parseCompileFileResult.getTriggerList();
        List classificationList = parseCompileFileResult.getClassificationList();
        if (!CollectionUtils.isEmpty((Collection)triggerList) && !CollectionUtils.isEmpty(metricAndScene = triggerList.stream().filter(trigger -> StringUtils.isNotEmpty((CharSequence)trigger.getString("authorityPrefix")) && (StringUtils.equals((CharSequence)trigger.getString("viewType"), (CharSequence)"metric") || StringUtils.equals((CharSequence)trigger.getString("viewType"), (CharSequence)"scene"))).collect(Collectors.toList()))) {
            DeployTask deployTask = this.initDeployTask(deployParam);
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            List newTriggerList = ClassificationAuthTask.processTriggerAndClassification(metricAndScene, (List)classificationList);
            AbstractDeployTaskNode.AuthParam authParam = this.standardStatementAuthParam(deployParam, newTriggerList, applicationData, this.getIamModuleId());
            List needAuthorizeSysTriggers = this.filterNeedAuthSysStatementsToClassification(newTriggerList);
            authParam.setNeedAuthorizeSys(needAuthorizeSysTriggers);
            deployTask.compressSetPublishParam((Object)authParam);
            return deployTask;
        }
        return null;
    }

    List<JSONObject> filterNeedAuthSysStatementsToClassification(List<JSONObject> needAuthorizeStatements) {
        return needAuthorizeStatements.stream().map(data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)data.getString("code"));
            jsonObject.put("name", (Object)data.getString("name"));
            jsonObject.put("parentId", (Object)data.getString("parentId"));
            jsonObject.put("lang", (Object)data.getJSONObject("lang"));
            jsonObject.put("moduleId", (Object)this.getIamModuleId());
            return jsonObject;
        }).collect(Collectors.toList());
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        if (deployParam.getEnvServiceId().equals("HuaweiProd")) {
            return null;
        }
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List recordList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "needAuthorizeClassificationData", null);
        if (recordList.isEmpty()) {
            return null;
        }
        List applications = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "application", null);
        JSONObject appJson = ((DeployParamRecord)applications.get(0)).getValue();
        Boolean commonApp = appJson.getBoolean("commonApp");
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AbstractDeployTaskNode.AuthParam authParam = new AbstractDeployTaskNode.AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        List assignmentList = recordList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        authParam.setCommonApp(commonApp);
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(user.getTenantId()).setAssignmentList(assignmentList).setToken(user.getToken()).setApplication(applicationData.getApplication()).setEnv(deployParam.getEnv()).setAppJson(appJson);
        authParam.setGmcUpdateParam(gmcUpdateParam);
        deployTask.compressSetPublishParam((Object)authParam);
        return deployTask;
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.AGILE_DATA_CLASSIFICATION_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.AGILE_DATA_CLASSIFICATION_AUTH;
    }

    String getIamModuleId() {
        return "classification";
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("ClassificationAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List sorted = ClassificationAuthTask.sortByLayer((List)authParam.getIamAssignmentAuthorizeParams());
        authParam.setIamAssignmentAuthorizeParams(sorted);
        this.iamAssignmentAuthorize(task, authParam);
        this.iamAddPolicy(task, authParam);
        this.deployServiceV4.recordLatestDeployParam(task.getApplication(), authParam.getEnv(), task.getCompileDataCode(), "needAuthorizeClassificationData", authParam.getNeedAuthorizeSys());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("ClassificationAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        GmcUpdateParam gmcUpdateParam = authParam.getGmcUpdateParam();
        this.backendApiHelper.updateGmcMoudle(gmcUpdateParam);
    }

    private static List<JSONObject> processTriggerAndClassification(List<JSONObject> triggerList, List<JSONObject> classificationList) {
        Map triggerMap = triggerList.stream().collect(Collectors.toMap(t -> t.getString("code"), Function.identity()));
        HashSet usedTriggerCodes = new HashSet();
        ArrayList<JSONObject> newTriggerList = new ArrayList<JSONObject>();
        newTriggerList.addAll(classificationList.stream().flatMap(classification -> {
            ArrayList<JSONObject> group = new ArrayList<JSONObject>();
            String classCode = classification.getString("code");
            String className = classification.getString("name");
            group.add(ClassificationAuthTask.createNode((String)classCode, (String)className));
            group.add(ClassificationAuthTask.createChildNode((String)classCode, (String)"metric", (String)"\u6307\u6807"));
            group.add(ClassificationAuthTask.createChildNode((String)classCode, (String)"scene", (String)"\u573a\u666f"));
            ClassificationAuthTask.processRelTriggers((JSONObject)classification, (String)"relMetric", (String)"metric", (String)classCode, (Map)triggerMap, (Set)usedTriggerCodes, group);
            ClassificationAuthTask.processRelTriggers((JSONObject)classification, (String)"relScene", (String)"scene", (String)classCode, (Map)triggerMap, (Set)usedTriggerCodes, group);
            return group.stream();
        }).collect(Collectors.toList()));
        boolean hasUnclassified = triggerList.stream().map(trigger -> trigger.getString("code")).anyMatch(code -> !usedTriggerCodes.contains(code));
        if (hasUnclassified) {
            newTriggerList.add(ClassificationAuthTask.createNode((String)"other", (String)"\u5176\u4ed6"));
            newTriggerList.add(ClassificationAuthTask.createChildNode((String)"other", (String)"metric", (String)"\u6307\u6807"));
            newTriggerList.add(ClassificationAuthTask.createChildNode((String)"other", (String)"scene", (String)"\u573a\u666f"));
            for (JSONObject trigger2 : triggerList) {
                String code2 = trigger2.getString("code");
                if (usedTriggerCodes.contains(code2)) continue;
                String viewType = trigger2.getString("viewType");
                String parentId = "other." + viewType;
                JSONObject copy = new JSONObject((Map)trigger2);
                copy.put("parentId", (Object)parentId);
                newTriggerList.add(copy);
            }
        }
        return newTriggerList;
    }

    private static JSONObject createNode(String code, String name) {
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)code);
        obj.put("name", (Object)name);
        return obj;
    }

    private static JSONObject createChildNode(String parentCode, String suffix, String name) {
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)(parentCode + "." + suffix));
        obj.put("name", (Object)name);
        obj.put("parentId", (Object)parentCode);
        return obj;
    }

    private static void processRelTriggers(JSONObject classification, String relKey, String viewType, String classCode, Map<String, JSONObject> triggerMap, Set<String> usedTriggerCodes, List<JSONObject> outputList) {
        JSONArray relArray = classification.getJSONArray(relKey);
        if (relArray == null || relArray.isEmpty()) {
            return;
        }
        List relCodes = relArray.toJavaList(String.class);
        String parentId = classCode + "." + viewType;
        for (String code : relCodes) {
            JSONObject trigger = triggerMap.get(code);
            if (trigger == null) continue;
            JSONObject copy = new JSONObject((Map)trigger);
            copy.put("parentId", (Object)parentId);
            outputList.add(copy);
            usedTriggerCodes.add(code);
        }
    }

    public static List<IamAssignmentAuthorizeParam> sortByLayer(List<IamAssignmentAuthorizeParam> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, IamAssignmentAuthorizeParam> codeToParam = new HashMap<String, IamAssignmentAuthorizeParam>();
        for (IamAssignmentAuthorizeParam param : list) {
            String code = param.getAssignment().getString("code");
            codeToParam.put(code, param);
        }
        HashMap<IamAssignmentAuthorizeParam, Integer> levelMap = new HashMap<IamAssignmentAuthorizeParam, Integer>();
        for (IamAssignmentAuthorizeParam param : list) {
            int level = 0;
            String parentId = param.getAssignment().getString("parentId");
            while (parentId != null) {
                ++level;
                IamAssignmentAuthorizeParam parent = (IamAssignmentAuthorizeParam)codeToParam.get(parentId);
                if (parent == null) break;
                parentId = parent.getAssignment().getString("parentId");
            }
            levelMap.put(param, level);
        }
        return list.stream().sorted(Comparator.comparingInt(levelMap::get).thenComparing(p -> ClassificationAuthTask.isOtherType((String)p.getAssignment().getString("code")) ? 1 : 0).thenComparing(p -> p.getAssignment().getString("code"))).collect(Collectors.toList());
    }

    private static boolean isOtherType(String code) {
        return code != null && code.toLowerCase().contains("other");
    }
}

