/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.enums.AppTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.ClearCacheTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClearCacheTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClearCacheTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        DeployTask deployTask = this.initDeployTask(deployParam);
        ClearCacheParam clearCacheParam = new ClearCacheParam();
        clearCacheParam.setEnv(deployParam.getEnv());
        clearCacheParam.setTenantId(AthenaUserLocal.getUser().getTenantId());
        clearCacheParam.setAppType(((ApplicationData)deployParam.getApplicationDataList().get(0)).getApplicationInfoDto().getAppType());
        deployTask.compressSetPublishParam((Object)clearCacheParam);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        DeployTask deployTask = this.initSwitchTask(deployParam);
        ClearCacheParam clearCacheParam = new ClearCacheParam();
        clearCacheParam.setEnv(deployParam.getEnv());
        clearCacheParam.setTenantId(AthenaUserLocal.getUser().getTenantId());
        clearCacheParam.setAppType(((ApplicationData)deployParam.getApplicationDataList().get(0)).getApplicationInfoDto().getAppType());
        deployTask.compressSetPublishParam((Object)clearCacheParam);
        return deployTask;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("ClearCacheTask executing");
        ClearCacheParam clearCacheParam = (ClearCacheParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Integer appType = clearCacheParam.getAppType();
        if (!Objects.equals(appType, AppTypeEnum.AGILE_INQUIRY.getAppType())) {
            this.backendApiHelper.kmCacheReset(clearCacheParam.getEnv(), clearCacheParam.getTenantId());
        }
        if (!Objects.equals(appType, AppTypeEnum.AGILE_DATA.getAppType()) && !Objects.equals(appType, AppTypeEnum.AGILE_INQUIRY.getAppType())) {
            this.backendApiHelper.atmcCacheReset(clearCacheParam.getEnv());
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        this.doDeployExecute(task);
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.CLEAR_CACHE;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.CLEAR_CACHE;
    }

    public String deployDetailLevel() {
        return "warn";
    }
}

