/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.ApplicationPO;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.PublishDataEntryAndModelDataParam;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.DataEntryModelRelationTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataEntryModelRelationTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEntryModelRelationTask.class);
    @Value(value="${privateEnv}")
    private Boolean privateEnv;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        try {
            List activityConfigList = parseCompileFileResult.getActivityConfigList();
            if (!CollectionUtils.isEmpty((Collection)activityConfigList)) {
                DeployTask deployTask = this.initDeployTask(deployParam);
                ArrayList<DataEntryModelRelationParam> dataEntryModelRelationParamList = new ArrayList<DataEntryModelRelationParam>();
                for (JSONObject activityConfigJSONObject : activityConfigList) {
                    DataEntryModelRelationParam param = new DataEntryModelRelationParam();
                    param.setCode(activityConfigJSONObject.getString("simpleModelCode"));
                    param.setApplication(activityConfigJSONObject.getString("application"));
                    param.setActivityId(activityConfigJSONObject.getString("code"));
                    param.setServiceCode(activityConfigJSONObject.getString("serviceCode"));
                    String modelType = activityConfigJSONObject.getString("modelType");
                    if (StringUtils.isBlank((CharSequence)modelType) || modelType.equals("api")) continue;
                    param.setModelType(modelType);
                    if (this.privateEnv.booleanValue()) {
                        String appToken = ((ApplicationData)deployParam.getApplicationDataList().get(0)).getApplicationInfoDto().getAppToken();
                        param.setAppToken(appToken);
                    }
                    dataEntryModelRelationParamList.add(param);
                }
                deployTask.compressSetPublishParam(dataEntryModelRelationParamList);
                return deployTask;
            }
        }
        catch (Exception e) {
            log.error("DataEntryModelRelationTask.createDeployTask \u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.DATA_ENTRY_MODEL_RELATION_PUBLISH;
    }

    protected void doDeployExecute(DeployTask task) {
        try {
            List filteredList;
            List dataEntryModelRelationParamList = (List)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            log.info("dataEntryModelRelationParamList value is:{}", (Object)JSONObject.toJSONString((Object)dataEntryModelRelationParamList));
            String env = task.getEnv();
            if (!CollectionUtils.isEmpty((Collection)dataEntryModelRelationParamList) && !CollectionUtils.isEmpty(filteredList = dataEntryModelRelationParamList.stream().filter(param -> !"api".equals(param.getModelType())).collect(Collectors.toList()))) {
                String appToken;
                AthenaUser user = AthenaUserLocal.getUser();
                String tenantId = user.getTenantId();
                String application = ((DataEntryModelRelationParam)filteredList.get(0)).getApplication();
                if (this.privateEnv.booleanValue()) {
                    appToken = ((DataEntryModelRelationParam)dataEntryModelRelationParamList.get(0)).getAppToken();
                } else {
                    ApplicationPO applicationPO = this.designerApiHelper.getApplicationByCode(application, AthenaUserLocal.getUser().getToken());
                    appToken = applicationPO.getAppToken();
                }
                dataEntryModelRelationParamList.stream().filter(param -> param.getServiceCode() != null).collect(Collectors.groupingBy(DataEntryModelRelationParam::getServiceCode)).forEach((serviceCode, params) -> {
                    PublishDataEntryAndModelDataParam param = new PublishDataEntryAndModelDataParam();
                    param.setActivityAndModelMap(Collections.singletonMap("data", params));
                    param.setPublishFlag("batch");
                    param.setTenantId(tenantId);
                    param.setAppToken(appToken);
                    param.setServiceCode(serviceCode);
                    param.setApplication(application);
                    this.syncDataViewToDap(env, param);
                });
            }
        }
        catch (Exception e) {
            log.error("DataEntryModelRelationTask.doDeployExecute \u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public String deployDetailLevel() {
        return "warn";
    }

    private void syncDataViewToDap(String env, PublishDataEntryAndModelDataParam publishDataEntryAndModelDataParam) {
        try {
            this.backendApiHelper.customDataEntryAndModelDapPublish(publishDataEntryAndModelDataParam, env);
        }
        catch (Exception exception) {
            log.error("syncDataViewToDap have exception ={}", (Object)exception.getMessage());
        }
    }
}

