/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.http.deployService.dto.DeployAppReqDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.DeployAppResDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.SwitchAppReqDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.TenantVersionUpdateReqDto;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.DataPublishTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import com.digiwin.athena.athenadeployer.utils.KmSecurityUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class DataPublishTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataPublishTask.class);
    @Value(value="${currentEnvDomain}")
    private String currentEnvDomain;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        DeployTask deployTask = this.initDeployTask(deployParam);
        DataPublish dataPublish = new DataPublish();
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
        JSONObject compileData = parseCompileFileResult.getCompileData();
        Boolean commonApp = this.getCommonApp(parseCompileFileResult);
        dataPublish.setCommonApp(commonApp);
        dataPublish.setAppId(applicationData.getApplication());
        dataPublish.setSourceId(applicationData.getApplication());
        dataPublish.setFileId(compileData.getString("compiledDataFileId"));
        dataPublish.setSync(Boolean.valueOf(false));
        dataPublish.setType("app");
        dataPublish.setEnv(deployParam.getEnv());
        dataPublish.setTenantIds(deployParam.getTenantUsers() == null ? new ArrayList() : deployParam.getTenantUsers().stream().map(TenantUser::getTenantId).collect(Collectors.toList()));
        dataPublish.setKmDeployId(applicationData.getApplication() + "_" + deployParam.getId());
        dataPublish.setUser(AthenaUserLocal.getUser());
        dataPublish.setSourceApplicationCode(applicationInfoDto != null ? applicationInfoDto.getSourceApplicationCode() : null);
        deployTask.compressSetPublishParam((Object)dataPublish);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
        DeployTask switchTask = this.initSwitchTask(deployParam);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        DeployTask lastDeployTask = this.deployTaskDao.selectLastPublishByApplicationAndTypeAndEnv(applicationData.getApplication(), this.getDeployType(), env.getEnv());
        Assert.notNull((Object)lastDeployTask, (String)(applicationData.getApplication() + "\u6ca1\u6709\u67e5\u8be2\u5230\u4e0a\u4e00\u6b21km\u6570\u636e\u53d1\u5e03\u6b65\u9aa4\u7684\u4efb\u52a1\u8bb0\u5f55"));
        DataSwitch dataSwitch = new DataSwitch();
        dataSwitch.setEnv(deployParam.getEnv());
        dataSwitch.setUser(AthenaUserLocal.getUser());
        dataSwitch.setSync(Boolean.valueOf(false));
        dataSwitch.setUpdateEspVersion(deployParam.getSwitchEspAction());
        dataSwitch.setSourceApplicationCode(applicationInfoDto != null ? applicationInfoDto.getSourceApplicationCode() : null);
        DataPublish dataPublish = (DataPublish)lastDeployTask.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        dataSwitch.setKmDeployId(dataPublish.getKmDeployId());
        switchTask.compressSetPublishParam((Object)dataSwitch);
        return switchTask;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info(task.getDeployNo() + " DataPublishTask executing");
        this.updateTenantVersion(task, EnvOperateEnum.PUBLISH.getVersion());
        DataPublish dataPublish = (DataPublish)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        DeployAppReqDto deployAppReqDto = new DeployAppReqDto();
        deployAppReqDto.setDeployerLogId(task.getDeployNo());
        deployAppReqDto.setApplication(task.getApplication());
        deployAppReqDto.setDeployTenantId(dataPublish.getUser().getTenantId());
        deployAppReqDto.setDeployerToken(dataPublish.getUser().getToken());
        deployAppReqDto.setDeployerDomain(this.currentEnvDomain);
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(11, 1);
        deployAppReqDto.setNonce(IdUtil.fastSimpleUUID());
        deployAppReqDto.setTimestamp(Long.valueOf(calendar.getTimeInMillis()));
        deployAppReqDto.setAppId(dataPublish.getAppId());
        deployAppReqDto.setCommonApp(dataPublish.getCommonApp());
        deployAppReqDto.setSourceId(dataPublish.getSourceId());
        deployAppReqDto.setDeployId(dataPublish.getKmDeployId());
        deployAppReqDto.setType(dataPublish.getType());
        deployAppReqDto.setFileId(dataPublish.getFileId());
        deployAppReqDto.setSync(dataPublish.getSync());
        deployAppReqDto.setTenantIds(dataPublish.getTenantIds());
        deployAppReqDto.setSignature(KmSecurityUtils.sign((String)(deployAppReqDto.getDeployId() + deployAppReqDto.getNonce() + deployAppReqDto.getTimestamp())));
        DeployAppResDto deployAppResDto = this.deployServiceApiHelper.deployApp(dataPublish.getEnv(), deployAppReqDto);
        log.info(dataPublish.getKmDeployId() + "\u8fd4\u56de\u7684eventId:" + deployAppResDto.getEventId());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info(task.getDeployNo() + " DataPublishTask executing");
        this.updateTenantVersion(task, EnvOperateEnum.SWITCH.getVersion());
        DataSwitch dataSwitch = (DataSwitch)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        SwitchAppReqDto switchAppReqDto = new SwitchAppReqDto();
        switchAppReqDto.setDeployerLogId(task.getDeployNo());
        switchAppReqDto.setApplication(task.getApplication());
        switchAppReqDto.setDeployerToken(dataSwitch.getUser().getToken());
        switchAppReqDto.setDeployerDomain(this.currentEnvDomain);
        switchAppReqDto.setSourceApplicationCode(dataSwitch.getSourceApplicationCode());
        switchAppReqDto.setDeployId(dataSwitch.getKmDeployId());
        switchAppReqDto.setUpdateEspVersion(dataSwitch.getUpdateEspVersion());
        switchAppReqDto.setNonce(IdUtil.fastSimpleUUID());
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(11, 1);
        switchAppReqDto.setTimestamp(Long.valueOf(calendar.getTimeInMillis()));
        switchAppReqDto.setDeployTenantId(dataSwitch.getUser().getTenantId());
        switchAppReqDto.setSync(dataSwitch.getSync());
        switchAppReqDto.setSignature(KmSecurityUtils.sign((String)(switchAppReqDto.getDeployId() + switchAppReqDto.getNonce() + switchAppReqDto.getTimestamp())));
        DeployAppResDto deployAppResDto = this.deployServiceApiHelper.switchApp(dataSwitch.getEnv(), switchAppReqDto);
        log.info(dataSwitch.getKmDeployId() + "\u8fd4\u56de\u7684eventId:" + deployAppResDto.getEventId());
    }

    void deployPostHandle(DeployTask task) {
        this.updateTaskStatus("waitingExecuteResult", task);
    }

    private void updateTenantVersion(DeployTask task, String version) {
        List tenantUsers = task.getTenantUsers();
        if (!CollectionUtils.isEmpty((Collection)tenantUsers)) {
            TenantVersionUpdateReqDto tenantVersionUpdateReqDto = new TenantVersionUpdateReqDto();
            tenantVersionUpdateReqDto.setTenantIds(tenantUsers.stream().map(TenantUser::getTenantId).collect(Collectors.toList()));
            tenantVersionUpdateReqDto.setVersion(version);
            tenantVersionUpdateReqDto.setDeployTenantId(AthenaUserLocal.getUser().getTenantId());
            tenantVersionUpdateReqDto.setDeployId(IdUtil.fastSimpleUUID());
            tenantVersionUpdateReqDto.setNonce(IdUtil.fastSimpleUUID());
            Date currentDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentDate);
            calendar.add(11, 1);
            tenantVersionUpdateReqDto.setTimestamp(Long.valueOf(calendar.getTimeInMillis()));
            tenantVersionUpdateReqDto.setSignature(KmSecurityUtils.sign((String)(tenantVersionUpdateReqDto.getDeployId() + tenantVersionUpdateReqDto.getNonce() + tenantVersionUpdateReqDto.getTimestamp())));
            this.deployServiceApiHelper.updateVersion(task.getEnv(), tenantVersionUpdateReqDto);
        }
    }

    void switchPostHandle(DeployTask task) {
        this.updateTaskStatus("waitingExecuteResult", task);
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.KM_DATA_PUBLISH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.KM_DATA_SWITCH;
    }
}

