/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DatasetV2AuthTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatasetV2AuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        if (!Objects.equals(applicationData.getApplicationInfoDto().getAppType(), 12)) {
            return null;
        }
        ArrayList<JSONObject> datasetV2List = parseCompileFileResult.getDatasetV2List();
        if (CollectionUtils.isEmpty((Collection)datasetV2List)) {
            datasetV2List = new ArrayList<JSONObject>();
            JSONObject needDel = new JSONObject();
            needDel.put("code", (Object)"needDelId");
            needDel.put("name", (Object)"\u9700\u8981\u5220\u9664");
            datasetV2List.add(needDel);
        }
        DeployTask deployTask = this.initDeployTask(deployParam);
        AbstractDeployTaskNode.AuthParam authParam = this.standardStatementAuthParam(deployParam, datasetV2List, applicationData, this.getIamModuleId());
        List needAuthorizeSysTriggers = this.filterNeedAuthSysStatements(datasetV2List);
        authParam.setNeedAuthorizeSys(needAuthorizeSysTriggers);
        deployTask.setPublishParam((Object)authParam);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List recordList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "needAuthorizeDatasetData", null);
        if (recordList.isEmpty()) {
            return null;
        }
        List applications = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "application", null);
        JSONObject appJson = ((DeployParamRecord)applications.get(0)).getValue();
        Boolean commonApp = appJson.getBoolean("commonApp");
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AbstractDeployTaskNode.AuthParam authParam = new AbstractDeployTaskNode.AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        List assignmentList = recordList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        authParam.setCommonApp(commonApp);
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(user.getTenantId()).setAssignmentList(assignmentList).setToken(user.getToken()).setApplication(applicationData.getApplication()).setEnv(deployParam.getEnv()).setAppJson(appJson);
        authParam.setGmcUpdateParam(gmcUpdateParam);
        deployTask.setPublishParam((Object)authParam);
        return deployTask;
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.AGILE_DATA2_DATASET_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.AGILE_DATA2_DATASET_AUTH;
    }

    String getIamModuleId() {
        return "dataset";
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("DataSetAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List needAuthorizeSys = authParam.getNeedAuthorizeSys();
        if (needAuthorizeSys.size() == 1 && ((JSONObject)needAuthorizeSys.get(0)).getString("id").equals("needDelId")) {
            this.deployServiceV4.recordLatestDeployParam(task.getApplication(), authParam.getEnv(), task.getCompileDataCode(), "needAuthorizeDatasetData", authParam.getNeedAuthorizeSys());
            return;
        }
        this.iamAssignmentAuthorize(task, authParam);
        this.iamAddPolicy(task, authParam);
        this.deployServiceV4.recordLatestDeployParam(task.getApplication(), authParam.getEnv(), task.getCompileDataCode(), "needAuthorizeDatasetData", authParam.getNeedAuthorizeSys());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("DataSetAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        GmcUpdateParam gmcUpdateParam = authParam.getGmcUpdateParam();
        this.backendApiHelper.updateGmcMoudle(gmcUpdateParam);
    }
}

