/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployDetailHandleDecorator
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployDetailHandleDecorator.class);
    private AbstractDeployTaskNode taskNode;
    private DeployDetailV2 deployDetailV2;

    public DeployDetailHandleDecorator(AbstractDeployTaskNode taskNode) {
        this.taskNode = taskNode;
        this.deployServiceV4 = taskNode.deployServiceV4;
        this.presetDataService = taskNode.presetDataService;
        this.deployDetailV2Dao = taskNode.deployDetailV2Dao;
        this.deployLogDao = taskNode.deployLogDao;
        this.deployTaskDao = taskNode.deployTaskDao;
        this.deployTaskFactory = taskNode.deployTaskFactory;
        this.deployServiceApiHelper = taskNode.deployServiceApiHelper;
        this.backendApiHelper = taskNode.backendApiHelper;
        this.redisCache = taskNode.redisCache;
        this.applicationDao = taskNode.applicationDao;
    }

    void deployPreHandle(DeployTask task) {
        if (!this.taskNode.deployCustomCreateDeployDetailFlag().booleanValue()) {
            this.deployDetailV2 = this.taskNode.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.taskNode.getDeployType().getContent(), this.taskNode.getDeployType().getLang());
        }
        this.taskNode.deployPreHandle((Object)task);
    }

    void deployPostHandle(DeployTask task) {
        this.taskNode.deployPostHandle((Object)task);
        this.updateDetailStatus(this.taskNode.deployCustomCreateDeployDetailFlag(), task);
    }

    void switchPreHandle(DeployTask task) {
        if (!this.taskNode.switchCustomCreateDeployDetailFlag().booleanValue()) {
            this.deployDetailV2 = this.taskNode.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.taskNode.getSwitchType().getContent(), this.taskNode.getSwitchType().getLang());
        }
        this.taskNode.switchPreHandle((Object)task);
    }

    void switchPostHandle(DeployTask task) {
        this.taskNode.switchPostHandle((Object)task);
        this.updateDetailStatus(this.taskNode.switchCustomCreateDeployDetailFlag(), task);
    }

    void switchTaskFailHandle(DeployTask task) {
        this.taskNode.switchTaskFailHandle((Object)task);
        this.updateDetailStatus(this.taskNode.switchCustomCreateDeployDetailFlag(), task);
    }

    void deployTaskFailHandle(DeployTask task) {
        this.taskNode.deployTaskFailHandle((Object)task);
        this.updateDetailStatus(this.taskNode.deployCustomCreateDeployDetailFlag(), task);
    }

    private void updateDetailStatus(Boolean customCreateDeployDetailFlag, DeployTask task) {
        if (!(customCreateDeployDetailFlag.booleanValue() || "waitingExecuteResult".equals(task.getStatus()) || "waiting".equals(task.getStatus()))) {
            this.finishUpdateDetail(this.deployDetailV2);
        }
    }

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        return null;
    }

    DeployTaskTypeEnum getDeployType() {
        return this.taskNode.getDeployType();
    }

    SwitchTaskTypeEnum getSwitchType() {
        return this.taskNode.getSwitchType();
    }

    protected void doDeployExecute(DeployTask task) {
        if (!this.taskNode.deployCustomCreateDeployDetailFlag().booleanValue()) {
            try {
                this.taskNode.doDeployExecute((Object)task);
                this.deployDetailV2.setResult("success");
            }
            catch (Exception e) {
                if ("fail".equals(this.deployDetailLevel())) {
                    this.deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString());
                    throw e;
                }
                if ("warn".equals(this.deployDetailLevel())) {
                    log.warn(String.format("%s %s \u6267\u884c\u4efb\u52a1\u5f02\u5e38:%s", task.getDeployNo(), task.getApplication(), e.getMessage()), (Throwable)e);
                    this.deployDetailV2.setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString());
                }
            }
        } else {
            this.taskNode.doDeployExecute((Object)task);
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        if (!this.taskNode.switchCustomCreateDeployDetailFlag().booleanValue()) {
            try {
                this.taskNode.doSwitchExecute((Object)task);
                this.deployDetailV2.setResult("success");
            }
            catch (Exception e) {
                if ("fail".equals(this.deployDetailLevel())) {
                    this.deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString());
                    throw e;
                }
                if ("warn".equals(this.deployDetailLevel())) {
                    log.warn(String.format("%s %s \u6267\u884c\u4efb\u52a1\u5f02\u5e38:%s", task.getDeployNo(), task.getApplication(), e.getMessage()), (Throwable)e);
                    this.deployDetailV2.setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString());
                }
            }
        } else {
            this.taskNode.doSwitchExecute((Object)task);
        }
    }

    public String deployDetailLevel() {
        return this.taskNode.deployDetailLevel();
    }
}

