/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployLogHandleDecorator
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployLogHandleDecorator.class);
    private AbstractDeployTaskNode taskNode;

    public DeployLogHandleDecorator(AbstractDeployTaskNode taskNode) {
        this.taskNode = taskNode;
        this.deployServiceV4 = taskNode.deployServiceV4;
        this.presetDataService = taskNode.presetDataService;
        this.deployDetailV2Dao = taskNode.deployDetailV2Dao;
        this.deployLogDao = taskNode.deployLogDao;
        this.deployTaskDao = taskNode.deployTaskDao;
        this.deployTaskFactory = taskNode.deployTaskFactory;
        this.deployServiceApiHelper = taskNode.deployServiceApiHelper;
        this.backendApiHelper = taskNode.backendApiHelper;
        this.redisCache = taskNode.redisCache;
        this.applicationDao = taskNode.applicationDao;
    }

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        return null;
    }

    DeployTaskTypeEnum getDeployType() {
        return this.taskNode.getDeployType();
    }

    SwitchTaskTypeEnum getSwitchType() {
        return this.taskNode.getSwitchType();
    }

    void deployPreHandle(DeployTask task) {
        log.info(String.format("%s %s \u6267\u884cdeployPreHandle:%s", task.getDeployNo(), task.getApplication(), task.getType()));
        this.taskNode.deployPreHandle((Object)task);
    }

    void deployPostHandle(DeployTask task) {
        log.info(String.format("%s %s \u6267\u884cdeployPostHandle:%s", task.getDeployNo(), task.getApplication(), task.getType()));
        this.taskNode.deployPostHandle((Object)task);
        Long num = this.deployTaskDao.selectCountByApplicationAndDeployNoAndStatus(task.getApplication(), task.getDeployNo(), Arrays.asList("waiting", "waitingExecuteResult", "executing"));
        if (num <= 0L) {
            DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(task.getApplication(), task.getDeployNo());
            deployLog.setResult("success");
            this.deployLogDao.save(deployLog);
        }
    }

    void switchPreHandle(DeployTask task) {
        log.info(String.format("%s %s \u6267\u884cswitchPreHandle:%s", task.getDeployNo(), task.getApplication(), task.getType()));
        this.taskNode.switchPreHandle((Object)task);
    }

    void switchPostHandle(DeployTask task) {
        log.info(String.format("%s %s \u6267\u884cswitchPostHandle:%s", task.getDeployNo(), task.getApplication(), task.getType()));
        this.taskNode.switchPostHandle((Object)task);
        Long num = this.deployTaskDao.selectCountByApplicationAndDeployNoAndStatus(task.getApplication(), task.getDeployNo(), Arrays.asList("waiting", "waitingExecuteResult", "executing"));
        if (num <= 0L) {
            DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(task.getApplication(), task.getDeployNo());
            deployLog.setResult("success");
            deployLog.setProcess(new BigDecimal(1));
            this.deployLogDao.save(deployLog);
        }
    }

    void switchTaskFailHandle(DeployTask task) {
        log.info(String.format("%s %s \u6267\u884cswitchTaskFailHandle:%s", task.getDeployNo(), task.getApplication(), task.getType()));
        try {
            this.taskNode.switchTaskFailHandle((Object)task);
        }
        finally {
            DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(task.getApplication(), task.getDeployNo());
            deployLog.setResult("fail");
            deployLog.setProcess(new BigDecimal(-1));
            this.deployLogDao.save(deployLog);
        }
    }

    void deployTaskFailHandle(DeployTask task) {
        log.info(String.format("%s %s \u6267\u884cdeployTaskFailHandle:%s", task.getDeployNo(), task.getApplication(), task.getType()));
        try {
            this.taskNode.deployTaskFailHandle((Object)task);
        }
        finally {
            DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(task.getApplication(), task.getDeployNo());
            deployLog.setResult("fail");
            deployLog.setProcess(new BigDecimal(-1));
            this.deployLogDao.save(deployLog);
        }
    }

    protected void doDeployExecute(DeployTask task) {
        log.info(String.format("%s %s \u6267\u884cdoDeployExecute:%s", task.getDeployNo(), task.getApplication(), task.getType()));
        try {
            this.taskNode.doDeployExecute((Object)task);
        }
        catch (Exception e) {
            log.error(String.format("%s %s \u6267\u884c\u4efb\u52a1\u5f02\u5e38:%s", task.getDeployNo(), task.getApplication(), e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info(String.format("%s %s \u6267\u884cdoSwitchExecute:%s", task.getDeployNo(), task.getApplication(), task.getType()));
        try {
            this.taskNode.doSwitchExecute((Object)task);
        }
        catch (Exception e) {
            log.error(String.format("%s %s \u6267\u884c\u4efb\u52a1\u5f02\u5e38:%s", task.getDeployNo(), task.getApplication(), e.getMessage()), (Throwable)e);
            throw e;
        }
    }
}

