/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.application.Application;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.http.designer.dto.SecurityTaskDto;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DeployPostTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployPostTask.class);
    @Value(value="${privateEnv}")
    private Boolean privateEnv;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        DeployTask deployTask = this.initDeployTask(deployParam);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        DeployTask deployTask = this.initSwitchTask(deployParam);
        return deployTask;
    }

    void deployPreHandle(DeployTask task) {
        try {
            super.deployPreHandle((Object)task);
        }
        catch (Exception e) {
            log.error("DeployPostTask deployPreHandle" + e.getMessage(), (Throwable)e);
        }
    }

    void switchPreHandle(DeployTask task) {
        try {
            super.switchPreHandle((Object)task);
        }
        catch (Exception e) {
            log.error("DeployPostTask switchPreHandle" + e.getMessage(), (Throwable)e);
        }
    }

    void deployPostHandle(DeployTask task) {
        try {
            super.deployPostHandle((Object)task);
            DeployDetailV2 finish = new DeployDetailV2().setDeployNo(task.getDeployNo()).setTime(new Date()).setContent(task.getDeployNo()).setResult("finish").setApplication(task.getApplication());
            this.insertDeployDetail(finish);
        }
        catch (Exception e) {
            log.error("DeployPostTask deployPostHandle" + e.getMessage(), (Throwable)e);
        }
    }

    void switchPostHandle(DeployTask task) {
        try {
            super.switchPostHandle((Object)task);
            DeployDetailV2 finish = new DeployDetailV2().setDeployNo(task.getDeployNo()).setTime(new Date()).setContent(task.getDeployNo()).setResult("finish").setApplication(task.getApplication());
            this.insertDeployDetail(finish);
        }
        catch (Exception e) {
            log.error("DeployPostTask deployPostHandle" + e.getMessage(), (Throwable)e);
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("DeployPostTask executing");
        this.applicationDao.updateStatueByApplicationAndLatestEnv(task.getApplication(), task.getEnv(), Integer.valueOf(4));
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(task.getDeployNo()).setTime(new Date()).setContent(this.getSwitchType().getContent() + ":" + task.getApplication()).setResult("success").setLang(this.getSwitchType().getLang()).setApplication(task.getApplication());
        this.insertDeployDetail(deployDetailV2);
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("DeployPostTask executing");
        try {
            Application application = this.applicationDao.selectByApplicationAndLatestEnv(task.getApplication(), task.getEnv());
            if (application == null) {
                application = Application.create((DeployTask)task);
                this.applicationDao.insert(application);
            } else {
                application.setStatus(Integer.valueOf(2));
                application.setLatestCompileDataCode(task.getCompileDataCode());
                List tenantUsers = task.getTenantUsers();
                if (!CollectionUtils.isEmpty((Collection)tenantUsers)) {
                    application.setLatestTenant(((TenantUser)task.getTenantUsers().get(0)).getTenantId());
                }
                application.setEditDate(new Date());
                this.applicationDao.save(application);
            }
            String appCode = task.getApplication();
            DeployDetailV2 deployDetailV2 = new DeployDetailV2().setTaskType(task.getType()).setDeployNo(task.getDeployNo()).setTime(new Date()).setContent(this.getDeployType().getContent() + ":" + appCode).setLang(this.getDeployType().getLang()).setResult("success").setApplication(task.getApplication());
            this.insertDeployDetail(deployDetailV2);
            this.addSecurityTask(task);
        }
        catch (Exception e) {
            log.error("DeployPostTask doDeployExecute:" + e.getMessage(), (Throwable)e);
        }
    }

    private void addSecurityTask(DeployTask task) {
        if (this.privateEnv.booleanValue()) {
            return;
        }
        try {
            JSONObject compileData = this.designerApiHelper.queryCompiledDataByCode(task.getCompileDataCode(), AthenaUserLocal.getUser().getToken());
            SecurityTaskDto securityTaskDto = new SecurityTaskDto();
            securityTaskDto.setDeployId(task.getDeployNo());
            securityTaskDto.setEnv(task.getEnv());
            securityTaskDto.setPublishTime(new Date());
            securityTaskDto.setApplication(task.getApplication());
            securityTaskDto.setCompiledDataFileId(compileData.getString("compiledDataFileId"));
            securityTaskDto.setCompileVersion(compileData.getString("version"));
            ResultBean resultBean = this.designerApiHelper.addSecurityTask(securityTaskDto, AthenaUserLocal.getUser().getToken());
            Assert.isTrue((boolean)resultBean.getCode().equals(0), (String)("addSecurityTask fail " + resultBean.getMsg()), (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error(String.format("\u5b89\u5168\u5ba1\u67e5\u4efb\u52a1\u6dfb\u52a0\u5931\u8d25:" + e.getMessage(), new Object[0]), (Throwable)e);
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.DEPLOY_POST;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.SWITCH_POST;
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return true;
    }

    public Boolean switchCustomCreateDeployDetailFlag() {
        return true;
    }
}

