/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.application.ApplicationConfig;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployPreTask
extends AbstractDeployTaskNode<DeployParamV3> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployPreTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        return null;
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.DEPLOY_PRE;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.SWITCH_PRE;
    }

    protected void doDeployExecute(DeployParamV3 deployParam) {
        log.info("DeployPreTask executing");
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(DeployTaskTypeEnum.DEPLOY_PRE.getType(), deployParam.getId(), applicationData.getApplication(), this.getDeployType().getContent(), this.getDeployType().getLang());
        JSONObject compiledData = new JSONObject();
        compiledData.put("description", (Object)applicationData.getDescription());
        DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(applicationData.getApplication(), deployParam.getId());
        ApplicationConfig applicationConfig = null;
        try {
            if ("waiting".equals(deployLog.getResult())) {
                JSONObject acg;
                String compileDataCode = applicationData.getCompileDataCode();
                if (StrUtil.isBlank((CharSequence)compileDataCode)) {
                    compileDataCode = this.deployServiceV4.getCompileDataCode(deployParam);
                    applicationData.setCompileDataCode(compileDataCode);
                }
                ParseCompileFileResult parseCompileFileResult = this.deployServiceV4.parseFileData(deployParam.getId(), applicationData.getApplication(), applicationData.getCompileDataCode(), deployParam.getCompileData());
                compiledData = parseCompileFileResult.getCompileData();
                this.deployServiceV4.collectPublishDbMongoData(deployParam.getEnv(), applicationData.getApplication(), parseCompileFileResult.getBsonInfoList(), applicationData.getCompileDataCode(), parseCompileFileResult.getApplication());
                JSONObject compileAppData = parseCompileFileResult.getApplication();
                Integer appType = compileAppData.getInteger("appType");
                List applicationConfigList = parseCompileFileResult.getApplicationConfigList();
                if (CollUtil.isNotEmpty((Collection)applicationConfigList) && (acg = (JSONObject)applicationConfigList.stream().filter(ac -> ac.getInteger("appType").equals(appType)).findFirst().orElse(null)) != null) {
                    applicationConfig = (ApplicationConfig)JSON.parseObject((String)JSON.toJSONString((Object)acg), ApplicationConfig.class);
                }
                this.deployServiceV4.delRecordLatestDeployParam(applicationData.getApplication(), deployParam.getEnv(), Arrays.asList("needAuthorizeTbbStatements", "needAuthorizeAbiStatements", "needAuthorizeDataEntrys", "needAuthorizestartProjects", "needAuthorizeOtherStatements", "needAuthorizeMobilePageDesigns", "needAuthorizeTriggerData", "needAuthorizeSceneData", "needAuthorizeStandardParamsData"));
                this.deployTaskDao.removeByDeployNoAndApplication(applicationData.getApplication(), deployParam.getId());
                this.deployTaskFactory.generateNewDeployTask(deployParam, parseCompileFileResult);
            }
            deployLog.setResult("executing");
            deployDetailV2.setResult("success");
            BigDecimal progress = new BigDecimal(this.getDeployType().ordinal() + 1).divide(new BigDecimal(DeployTaskTypeEnum.values().length), 2, 3);
            deployLog.setProcess(progress);
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString());
            deployLog.setResult("fail");
            deployLog.setProcess(new BigDecimal(-1));
            throw e;
        }
        finally {
            this.finishUpdateDetail(deployDetailV2);
            deployLog.setApplicationConfig(applicationConfig);
            deployLog.setCompileData(compiledData);
            deployLog.setAllowCustomPublish(compiledData.getBoolean("allowCustomPublish"));
            this.deployLogDao.save(deployLog);
        }
    }

    protected void doSwitchExecute(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(applicationData.getApplication(), deployParam.getId());
        if (!"waiting".equals(deployLog.getResult())) {
            return;
        }
        DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(SwitchTaskTypeEnum.SWITCH_PRE.getType(), deployParam.getId(), applicationData.getApplication(), this.getSwitchType().getContent(), this.getSwitchType().getLang());
        try {
            this.deployTaskDao.removeByDeployNoAndApplication(applicationData.getApplication(), deployParam.getId());
            this.deployTaskFactory.generateNewSwitchTask(deployParam);
            BigDecimal progress = new BigDecimal(this.getSwitchType().ordinal() + 1).divide(new BigDecimal(SwitchTaskTypeEnum.values().length), 2, 3);
            deployLog.setResult("executing");
            deployLog.setProcess(progress);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString());
            deployLog.setResult("fail");
            deployLog.setProcess(new BigDecimal(-1));
            throw e;
        }
        finally {
            this.deployLogDao.save(deployLog);
            this.finishUpdateDetail(deployDetailV2);
        }
    }
}

