/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployLogDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployTaskDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.application.ApplicationConfig;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.DeployDetailHandleDecorator;
import com.digiwin.athena.athenadeployer.service.deployTask.DeployLogHandleDecorator;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DeployTaskFactory
implements ApplicationContextAware,
SmartInitializingSingleton {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployTaskFactory.class);
    @Autowired
    private DeployTaskDao deployTaskDao;
    @Autowired
    private DeployLogDao deployLogDao;
    private ApplicationContext applicationContext;
    private static final Map<String, AbstractDeployTaskNode> deployNodes = new HashMap();
    private static final Map<String, AbstractDeployTaskNode> switchNodes = new HashMap();
    private static final Map<String, List<DeployTaskTypeEnum>> DEPLOY_SPECIAL_APP = new HashMap();
    private static final Map<String, List<SwitchTaskTypeEnum>> SWITCH_SPECIAL_APP = new HashMap();
    private static final Map<Integer, List<DeployTaskTypeEnum>> DEPLOY_SPECIAL_APP_TYPE = new HashMap();
    private static final Map<Integer, List<SwitchTaskTypeEnum>> SWITCH_SPECIAL_APP_TYPE = new HashMap();
    private static final List<DeployTaskTypeEnum> DEPLOY_INDIVIDUAL_APP = new ArrayList();
    private static final List<SwitchTaskTypeEnum> SWITCH_INDIVIDUAL_APP = new ArrayList();

    public void afterSingletonsInstantiated() {
        Map singleModelPublishHandleMap = this.applicationContext.getBeansOfType(AbstractDeployTaskNode.class);
        singleModelPublishHandleMap.forEach((key, value) -> {
            if (value.getDeployType() != null) {
                deployNodes.put(value.getDeployType().getType(), value);
            }
            if (value.getSwitchType() != null) {
                switchNodes.put(value.getSwitchType().getType(), value);
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void generateNewDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
        if (DEPLOY_SPECIAL_APP.containsKey(applicationData.getApplication())) {
            List deployTaskTypeEnums = (List)DEPLOY_SPECIAL_APP.get(applicationData.getApplication());
            for (DeployTaskTypeEnum deployTaskTypeEnum : deployTaskTypeEnums) {
                AbstractDeployTaskNode deployTaskNode = (AbstractDeployTaskNode)deployNodes.get(deployTaskTypeEnum.getType());
                DeployTask task = deployTaskNode.createDeployTask(deployParam, parseCompileFileResult);
                if (task == null) continue;
                log.info(String.format("%s %s \u521b\u5efa\u53d1\u7248\u4efb\u52a1:%s", deployParam.getId(), applicationData.getApplication(), deployTaskNode.getClass().getSimpleName()));
                this.deployTaskDao.insert(task);
            }
        } else if (applicationInfoDto != null && applicationInfoDto.isIndividual()) {
            for (DeployTaskTypeEnum deployTaskTypeEnum : DEPLOY_INDIVIDUAL_APP) {
                DeployTask deployTask;
                AbstractDeployTaskNode deployTaskNode = (AbstractDeployTaskNode)deployNodes.get(deployTaskTypeEnum.getType());
                if (deployTaskNode == null || (deployTask = deployTaskNode.createDeployTask(deployParam, parseCompileFileResult)) == null) continue;
                log.info(String.format("%s %s \u521b\u5efa\u53d1\u7248\u4efb\u52a1:%s", deployParam.getId(), applicationData.getApplication(), deployTaskNode.getClass().getSimpleName()));
                this.deployTaskDao.insert(deployTask);
            }
        } else {
            Integer applicationType = this.getApplicationType(parseCompileFileResult);
            Map publishBeans = this.getApplicationConfigPublish(parseCompileFileResult);
            List beans = (List)publishBeans.get(applicationType);
            if (applicationType != null && CollUtil.isNotEmpty((Collection)beans)) {
                log.info(applicationData.getApplication() + "\u5e94\u7528\u53d1\u5e03\u8d70\u914d\u7f6e\u5316\u903b\u8f91");
                beans.forEach(bean -> {
                    AbstractDeployTaskNode deployTaskNode = (AbstractDeployTaskNode)SpringUtil.getBean((String)bean);
                    DeployTask task = deployTaskNode.createDeployTask(deployParam, parseCompileFileResult);
                    if (task != null) {
                        log.info(String.format("%s %s \u521b\u5efa\u53d1\u7248\u4efb\u52a1:%s", deployParam.getId(), applicationData.getApplication(), deployTaskNode.getClass().getSimpleName()));
                        this.deployTaskDao.insert(task);
                    }
                });
            } else {
                log.info(applicationData.getApplication() + "\u5e94\u7528\u53d1\u5e03\u8d70\u5386\u53f2\u903b\u8f91");
                for (AbstractDeployTaskNode deployNode : deployNodes.values()) {
                    DeployTask task = deployNode.createDeployTask(deployParam, parseCompileFileResult);
                    if (task == null) continue;
                    log.info(String.format("%s %s \u521b\u5efa\u53d1\u7248\u4efb\u52a1:%s", deployParam.getId(), applicationData.getApplication(), deployNode.getClass().getSimpleName()));
                    this.deployTaskDao.insert(task);
                }
            }
        }
    }

    public void generateNewSwitchTask(DeployParamV3 deployParam) {
        ArrayList<DeployTask> deployTasks = new ArrayList<DeployTask>();
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
        if (SWITCH_SPECIAL_APP.containsKey(applicationData.getApplication())) {
            List deployTaskTypeEnums = (List)SWITCH_SPECIAL_APP.get(applicationData.getApplication());
            for (SwitchTaskTypeEnum switchTaskTypeEnum : deployTaskTypeEnums) {
                AbstractDeployTaskNode deployTaskNode = (AbstractDeployTaskNode)switchNodes.get(switchTaskTypeEnum.getType());
                DeployTask task = deployTaskNode.createSwitchTask(deployParam);
                if (task == null) continue;
                log.info(String.format("%s %s \u521b\u5efa\u5207\u677f\u4efb\u52a1:%s", deployParam.getId(), applicationData.getApplication(), deployTaskNode.getClass().getSimpleName()));
                deployTasks.add(task);
            }
        } else if (applicationInfoDto != null && applicationInfoDto.isIndividual()) {
            for (SwitchTaskTypeEnum switchTaskTypeEnum : SWITCH_INDIVIDUAL_APP) {
                DeployTask deployTask;
                AbstractDeployTaskNode deployTaskNode = (AbstractDeployTaskNode)switchNodes.get(switchTaskTypeEnum.getType());
                if (deployTaskNode == null || (deployTask = deployTaskNode.createSwitchTask(deployParam)) == null) continue;
                log.info(String.format("%s %s \u521b\u5efa\u5207\u677f\u4efb\u52a1:%s", deployParam.getId(), applicationData.getApplication(), deployTaskNode.getClass().getSimpleName()));
                this.deployTaskDao.insert(deployTask);
            }
        } else {
            DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(applicationData.getApplication(), deployParam.getId());
            Integer appType = deployLog.getCompileData().getInteger("appType");
            ApplicationConfig applicationConfig = deployLog.getApplicationConfig();
            List switchBeans = this.getApplicationConfigSwitch(applicationConfig);
            if (appType != null && CollUtil.isNotEmpty((Collection)switchBeans)) {
                log.info(applicationData.getApplication() + "\u5e94\u7528\u5207\u677f\u8d70\u914d\u7f6e\u5316\u903b\u8f91");
                switchBeans.forEach(bean -> {
                    AbstractDeployTaskNode deployTaskNode = (AbstractDeployTaskNode)SpringUtil.getBean((String)bean);
                    DeployTask task = deployTaskNode.createSwitchTask(deployParam);
                    if (task != null) {
                        log.info(String.format("%s %s \u521b\u5efa\u5207\u677f\u4efb\u52a1:%s", deployParam.getId(), applicationData.getApplication(), deployTaskNode.getClass().getSimpleName()));
                        deployTasks.add(task);
                    }
                });
            } else {
                log.info(applicationData.getApplication() + "\u5e94\u7528\u53d1\u5e03\u8d70\u5386\u53f2\u903b\u8f91");
                for (AbstractDeployTaskNode deployNode : switchNodes.values()) {
                    DeployTask task = deployNode.createSwitchTask(deployParam);
                    if (task == null) continue;
                    log.info(String.format("%s %s \u521b\u5efa\u5207\u677f\u4efb\u52a1:%s", deployParam.getId(), applicationData.getApplication(), deployNode.getClass().getSimpleName()));
                    deployTasks.add(task);
                }
            }
        }
        this.deployTaskDao.batchInsert(deployTasks);
    }

    public AbstractDeployTaskNode getDeployPreTaskNode() {
        AbstractDeployTaskNode taskNode = (AbstractDeployTaskNode)deployNodes.get(DeployTaskTypeEnum.DEPLOY_PRE.getType());
        return taskNode;
    }

    public AbstractDeployTaskNode getSwitchPreTaskNode() {
        AbstractDeployTaskNode taskNode = (AbstractDeployTaskNode)switchNodes.get(SwitchTaskTypeEnum.SWITCH_PRE.getType());
        return taskNode;
    }

    public AbstractDeployTaskNode getDeployNode(DeployTask task) {
        AbstractDeployTaskNode taskNode = (AbstractDeployTaskNode)deployNodes.get(task.getType());
        DeployDetailHandleDecorator deployDetailHandleDecorator = new DeployDetailHandleDecorator(taskNode);
        DeployLogHandleDecorator deployLogHandleDecorator = new DeployLogHandleDecorator((AbstractDeployTaskNode)deployDetailHandleDecorator);
        return deployLogHandleDecorator;
    }

    public AbstractDeployTaskNode getSwitchNode(DeployTask task) {
        AbstractDeployTaskNode taskNode = (AbstractDeployTaskNode)switchNodes.get(task.getType());
        DeployDetailHandleDecorator deployDetailHandleDecorator = new DeployDetailHandleDecorator(taskNode);
        DeployLogHandleDecorator deployLogHandleDecorator = new DeployLogHandleDecorator((AbstractDeployTaskNode)deployDetailHandleDecorator);
        return deployLogHandleDecorator;
    }

    private Integer getApplicationType(ParseCompileFileResult parseCompileFileResult) {
        JSONObject application = parseCompileFileResult.getApplication();
        if (application == null) {
            return null;
        }
        return application.getInteger("appType");
    }

    private Map<Integer, List<String>> getApplicationConfigPublish(ParseCompileFileResult parseCompileFileResult) {
        List applicationConfigs = parseCompileFileResult.getApplicationConfigList();
        HashMap<Integer, List<String>> publishBeans = new HashMap<Integer, List<String>>();
        applicationConfigs.forEach(ac -> {
            Integer appType = ac.getInteger("appType");
            ArrayList beans = new ArrayList();
            JSONArray publish = ac.getJSONArray("publish");
            if (CollUtil.isEmpty((Collection)publish)) {
                publishBeans.put(appType, new ArrayList());
            } else {
                publish.forEach(p -> {
                    JSONObject pObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)p));
                    if ("bean".equals(pObj.getString("type"))) {
                        beans.add(pObj.getString("name"));
                    }
                });
                publishBeans.put(appType, beans);
            }
        });
        return publishBeans;
    }

    private List<String> getApplicationConfigSwitch(ApplicationConfig applicationConfig) {
        if (applicationConfig == null) {
            return null;
        }
        List switched = applicationConfig.getSwitched();
        ArrayList<String> beans = new ArrayList<String>();
        switched.forEach(sw -> {
            if ("bean".equals(sw.getType())) {
                beans.add(sw.getName());
            }
        });
        return beans;
    }

    static {
        ArrayList<DeployTaskTypeEnum> specialAppEnumList = new ArrayList<DeployTaskTypeEnum>();
        specialAppEnumList.add(DeployTaskTypeEnum.KM_DATA_PUBLISH);
        specialAppEnumList.add(DeployTaskTypeEnum.CLEAR_CACHE);
        specialAppEnumList.add(DeployTaskTypeEnum.DEPLOY_POST);
        DEPLOY_SPECIAL_APP.put("DATASTANDARDS", specialAppEnumList);
        ArrayList<SwitchTaskTypeEnum> specialAppEnumList2 = new ArrayList<SwitchTaskTypeEnum>();
        specialAppEnumList2.add(SwitchTaskTypeEnum.KM_DATA_SWITCH);
        specialAppEnumList2.add(SwitchTaskTypeEnum.CLEAR_CACHE);
        specialAppEnumList2.add(SwitchTaskTypeEnum.SWITCH_POST);
        SWITCH_SPECIAL_APP.put("DATASTANDARDS", specialAppEnumList2);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_KM_DATA_PUBLISH);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.IAM_PERMISSION_REMOVAL);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_ADTEMPLATE_PUBLISH);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_START_PROJECT_AUTH);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_TBB_REPORT_PUBLISH);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_TBB_REPORT_AUTH);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.ABI_REPORT_PUBLISH);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_ABI_REPORT_AUTH);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_OTHER_STATEMENT_AUTH);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_BASIC_DATA_ENTRY_AUTH);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.CLEAR_CACHE);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.DEPLOY_POST);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_ADTEMPLATE_STOP);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_SYNC_MOBILE_DESIGN_CODE);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.GMC_IAM_MODULE_SUPPLEMENT);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_EVENT_PUBLISH);
        DEPLOY_INDIVIDUAL_APP.add(DeployTaskTypeEnum.INDIVIDUAL_DATA_VIEW_PUBLISH);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.INDIVIDUAL_KM_DATA_SWITCH);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.INDIVIDUAL_ADTEMPLATE_SWITCH);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.INDIVIDUAL_TBB_REPORT_SWITCH);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.CLEAR_CACHE);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.SWITCH_POST);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.INDIVIDUAL_ADTEMPLATE_STOP);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.INDIVIDUAL_SYNC_MOBILE_DESIGN_CODE);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.IAM_PERMISSION_REMOVAL);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.INDIVIDUAL_START_PROJECT_AUTH);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.INDIVIDUAL_TBB_REPORT_AUTH);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.INDIVIDUAL_ABI_REPORT_AUTH);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.INDIVIDUAL_OTHER_STATEMENT_AUTH);
        SWITCH_INDIVIDUAL_APP.add(SwitchTaskTypeEnum.INDIVIDUAL_BASIC_DATA_ENTRY_AUTH);
    }
}

