/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.config.ModuleConfig;
import com.digiwin.athena.athenadeployer.dao.mongo.MulVersionDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.MulVersion;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.DtdMulVersionCallBaclBusinessPlatformTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import jakarta.annotation.Resource;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DtdMulVersionCallBaclBusinessPlatformTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DtdMulVersionCallBaclBusinessPlatformTask.class);
    @Resource
    private MulVersionDao mulVersionDao;
    @Resource(name="httpRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${appToken}")
    private String appToken;
    private static final String CALLBACKURL = "/restful/service/dtd/application/releaseback";
    @Resource
    private ModuleConfig moduleConfig;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        String application = ((ApplicationData)deployParam.getApplicationDataList().get(0)).getApplication();
        MulVersion mulVersion = this.mulVersionDao.selectByApplicationAndAdpVersion(application);
        if (Objects.isNull(mulVersion)) {
            return null;
        }
        DeployTask deployTask = this.initDeployTask(deployParam);
        DtdMulVersionCallBaclBusinessPlatformPublishParam mulVersionCallBaclBusinessPlatformPublishParam = new DtdMulVersionCallBaclBusinessPlatformPublishParam();
        mulVersionCallBaclBusinessPlatformPublishParam.setApplication(application);
        mulVersionCallBaclBusinessPlatformPublishParam.setCallBackUrl(this.moduleConfig.getBusinessplatform().getDomain() + CALLBACKURL);
        mulVersionCallBaclBusinessPlatformPublishParam.setEnv(deployParam.getEnv());
        mulVersionCallBaclBusinessPlatformPublishParam.setUser(AthenaUserLocal.getUser());
        mulVersionCallBaclBusinessPlatformPublishParam.setAppversion(mulVersion.getAdpVersion());
        deployTask.compressSetPublishParam((Object)mulVersionCallBaclBusinessPlatformPublishParam);
        return deployTask;
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.CALLBACK_BUSINESS_PLATFOM;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("DtdMulVersionCallBaclBusinessPlatformTask executing");
        this.callBackBusinessPlatform(task);
    }

    private void callBackBusinessPlatform(DeployTask task) {
        DtdMulVersionCallBaclBusinessPlatformPublishParam dtdMulVersionCallBaclBusinessPlatformPublishParam = (DtdMulVersionCallBaclBusinessPlatformPublishParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        String env = dtdMulVersionCallBaclBusinessPlatformPublishParam.getEnv();
        String application = dtdMulVersionCallBaclBusinessPlatformPublishParam.getApplication();
        String appVersion = dtdMulVersionCallBaclBusinessPlatformPublishParam.getAppversion();
        String callBackUrl = dtdMulVersionCallBaclBusinessPlatformPublishParam.getCallBackUrl();
        String token = dtdMulVersionCallBaclBusinessPlatformPublishParam.getUser().getToken();
        JSONObject result = this.callBackBusinessPlatformPost(application, appVersion, env, callBackUrl, token);
        JSONObject response = result.getJSONObject("response");
        log.info("\u4e1a\u52a1\u4e2d\u53f0\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)response));
        if (response == null || response.getInteger("code") == null || response.getInteger("code") != 0) {
            String errorMsg = response != null ? response.getString("msg") : "Null response";
            throw new BusinessException("BusinessPlatformPost error: " + errorMsg);
        }
    }

    public String deployDetailLevel() {
        return "warn";
    }

    private JSONObject callBackBusinessPlatformPost(String application, String appversion, String env, String url, String token) {
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("token", token);
        httpHeaders.add("digi-middleware-auth-app", this.appToken);
        JSONObject data = new JSONObject();
        JSONObject body = new JSONObject();
        body.put("appversion", (Object)appversion);
        body.put("devplatformCode", (Object)application);
        body.put("environment", (Object)env);
        data.put("data", (Object)body);
        HttpEntity httpEntity = new HttpEntity((Object)data, (MultiValueMap)httpHeaders);
        log.info("BusinessPlatformPost request:{},url:{}", (Object)httpEntity, (Object)url);
        ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
        log.info("BusinessPlatformPost response:{}", (Object)exchange);
        return (JSONObject)exchange.getBody();
    }
}

