/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.http.deployService.DeployServiceApiHelper;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class GmcIamModuleSupplementTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GmcIamModuleSupplementTask.class);
    @Autowired
    protected DeployServiceApiHelper deployServiceApiHelper;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        JSONObject application = parseCompileFileResult.getApplication();
        String appSystem = application.getString("appSystem");
        List applicationConfigList = parseCompileFileResult.getApplicationConfigList();
        List assetConfigList = parseCompileFileResult.getAssetConfigList();
        List assetConfigCollectList = parseCompileFileResult.getAssetConfigCollectList();
        Boolean commonApp = Optional.ofNullable(application.getBoolean("commonApp")).orElse(false);
        if (application.getInteger("appType") != null && (application.getInteger("appType").equals(6) || application.getInteger("appType").equals(12))) {
            HashSet wholeModuleInfo = new HashSet();
            JSONObject applicationConfig = applicationConfigList.stream().filter(aConfig -> aConfig.getInteger("appType").equals(application.getInteger("appType"))).findFirst().orElse(null);
            if (applicationConfig == null) {
                return null;
            }
            if (applicationConfig.getJSONObject("iamConfig") == null) {
                return null;
            }
            JSONArray moduleList = applicationConfig.getJSONObject("iamConfig").getJSONArray("module");
            if (application.getInteger("appType").equals(6)) {
                if (StringUtils.isEmpty((CharSequence)appSystem)) {
                    appSystem = "metric";
                }
                String finalAppSystem = appSystem;
                List both = moduleList.stream().filter(item -> StringUtils.isEmpty((CharSequence)JSON.parseObject((String)JSON.toJSONString((Object)item)).getString("appSystem"))).collect(Collectors.toList());
                List<Object> collect = moduleList.stream().filter(item -> StringUtils.equals((CharSequence)finalAppSystem, (CharSequence)JSON.parseObject((String)JSON.toJSONString((Object)item)).getString("appSystem"))).collect(Collectors.toList());
                collect.addAll(both);
                collect.forEach(module -> {
                    JSONObject m = (JSONObject)module;
                    wholeModuleInfo.add(m);
                });
            } else {
                moduleList.forEach(module -> wholeModuleInfo.add((JSONObject)module));
            }
            if (CollectionUtils.isEmpty(wholeModuleInfo)) {
                return null;
            }
            log.info("wholeModuleInfo:{}", wholeModuleInfo);
            GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(AthenaUserLocal.getUser().getTenantId()).setToken(AthenaUserLocal.getUser().getToken()).setApplication(application.getString("code")).setEnv(deployParam.getEnv()).setAppJson(application).setVersion("1.0").setAssignmentList(new ArrayList(wholeModuleInfo));
            DeployTask deployTask = this.initDeployTask(deployParam);
            deployTask.compressSetPublishParam((Object)gmcUpdateParam);
            return deployTask;
        }
        if (CollUtil.isNotEmpty((Collection)assetConfigCollectList) && CollUtil.isNotEmpty((Collection)assetConfigList) && application.getInteger("appType") != null && (application.getInteger("appType").equals(10) || application.getInteger("appType").equals(11))) {
            HashSet wholeModuleInfo = new HashSet();
            JSONObject applicationConfig = applicationConfigList.stream().filter(aConfig -> aConfig.getInteger("appType").equals(application.getInteger("appType"))).findFirst().orElse(null);
            if (applicationConfig != null && applicationConfig.getJSONObject("iamConfig") != null) {
                JSONArray moduleList = applicationConfig.getJSONObject("iamConfig").getJSONArray("module");
                moduleList.forEach(module -> wholeModuleInfo.add((JSONObject)module));
            }
            assetConfigCollectList.forEach(acc -> {
                String assetType = acc.getString("assetType");
                JSONObject moduleConfig = assetConfigList.stream().filter(ac -> ac.getString("assetType").equals(assetType) && ac.getString("appType").equals(application.getString("appType"))).findFirst().orElse(null);
                if (moduleConfig != null && moduleConfig.getJSONObject("iamConfig") != null && moduleConfig.getJSONObject("iamConfig").getJSONObject("module") != null) {
                    wholeModuleInfo.add(moduleConfig.getJSONObject("iamConfig").getJSONObject("module"));
                }
            });
            GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(AthenaUserLocal.getUser().getTenantId()).setToken(AthenaUserLocal.getUser().getToken()).setApplication(application.getString("code")).setEnv(deployParam.getEnv()).setAppJson(application).setVersion("1.0").setAssignmentList(new ArrayList(wholeModuleInfo));
            DeployTask deployTask = this.initDeployTask(deployParam);
            deployTask.compressSetPublishParam((Object)gmcUpdateParam);
            return deployTask;
        }
        if (commonApp.booleanValue()) {
            List statementList = parseCompileFileResult.getStatementList();
            List startProjectList = parseCompileFileResult.getStartProjectList();
            List dataEntryList = parseCompileFileResult.getDataEntryList();
            List mobilePageDesignList = parseCompileFileResult.getMobilePageDesignList();
            List allStatementList = Stream.of(statementList, startProjectList, dataEntryList, mobilePageDesignList).flatMap(Collection::stream).collect(Collectors.toList());
            List needAuthorizeStartProjects = startProjectList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getString("authorityPrefix"))).collect(Collectors.toList());
            AbstractDeployTaskNode.AuthParam authParam = this.commonStatementAuthParam(deployParam, allStatementList, (ApplicationData)deployParam.getApplicationDataList().get(0), parseCompileFileResult);
            DeployTask deployTask = this.initDeployTask(deployParam);
            GmcUpdateParam gmcUpdateParam = authParam.getGmcUpdateParam();
            deployTask.setPublishParam((Object)gmcUpdateParam);
            return deployTask;
        }
        return null;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("IamModuleSupplementTask executing");
        GmcUpdateParam gmcUpdateParam = (GmcUpdateParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Boolean commonApp = Optional.ofNullable(gmcUpdateParam.getAppJson().getBoolean("commonApp")).orElse(false);
        if (commonApp.booleanValue()) {
            this.backendApiHelper.updateCommonGmcMoudle(gmcUpdateParam);
        } else {
            this.deployServiceApiHelper.gmcModuleSupplement(task.getEnv(), gmcUpdateParam);
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.GMC_IAM_MODULE_SUPPLEMENT;
    }
}

