/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.IamAuthInfoRecord;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.http.deployService.dto.DeletePermissionReqDto;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IamPermissionRemoveTaskNode
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamPermissionRemoveTaskNode.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List dataEntryList;
        List startProjectList;
        String env = deployParam.getEnv();
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        IamAuthInfoRecord iamAuthInfoRecord = this.iamAuthInfoRecordDao.selectByApplicationAndEnv(applicationData.getApplication(), env);
        if (iamAuthInfoRecord == null) {
            return null;
        }
        List tbbReport = iamAuthInfoRecord.getTbbReport();
        List abiReport = iamAuthInfoRecord.getAbiReport();
        List otherReport = iamAuthInfoRecord.getOtherReport();
        List startProject = iamAuthInfoRecord.getStartProject();
        List dataEntry = iamAuthInfoRecord.getDataEntry();
        List activityConfigList = parseCompileFileResult.getActivityConfigList();
        List statementList = parseCompileFileResult.getStatementList();
        List tbbStatement = statementList.stream().filter(t -> this.isTbbStatement(t.getString("pattern"), t.getString("category"))).collect(Collectors.toList());
        List abiStatement = statementList.stream().filter(t -> this.isAbiStatement(t.getString("pattern"), t.getString("category"))).collect(Collectors.toList());
        List otherStatement = statementList.stream().filter(t -> this.isAbiStatement(t.getString("pattern"), t.getString("category")) == false && this.isTbbStatement(t.getString("pattern"), t.getString("category")) == false).collect(Collectors.toList());
        Set tenantUsers = deployParam.getTenantUsers().stream().map(TenantUser::getTenantId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty((Collection)statementList)) {
            Set tbbCodes = tbbStatement.stream().map(s -> s.getString("code")).collect(Collectors.toSet());
            Set abiCodes = abiStatement.stream().map(s -> s.getString("code")).collect(Collectors.toSet());
            Set otherCodes = otherStatement.stream().map(s -> s.getString("code")).collect(Collectors.toSet());
            this.filterNeedDeleteIamAuthInfo(tbbReport, tbbCodes, tenantUsers);
            this.filterNeedDeleteIamAuthInfo(abiReport, abiCodes, tenantUsers);
            this.filterNeedDeleteIamAuthInfo(otherReport, otherCodes, tenantUsers);
        }
        if (CollectionUtils.isNotEmpty((Collection)(startProjectList = parseCompileFileResult.getStartProjectList()))) {
            Set startProjectCodes = startProjectList.stream().map(s -> s.getString("code")).collect(Collectors.toSet());
            this.filterNeedDeleteIamAuthInfo(startProject, startProjectCodes, tenantUsers);
        }
        if (CollectionUtils.isNotEmpty((Collection)(dataEntryList = parseCompileFileResult.getDataEntryList()))) {
            Set dataEntryCodes = dataEntryList.stream().map(s -> s.getString("code")).collect(Collectors.toSet());
            this.filterNeedDeleteIamAuthInfo(dataEntry, dataEntryCodes, tenantUsers);
        }
        if (tbbReport.isEmpty() && abiReport.isEmpty() && otherReport.isEmpty() && startProject.isEmpty() && dataEntry.isEmpty()) {
            return null;
        }
        DeployTask deployTask = this.initDeployTask(deployParam);
        deployTask.compressSetPublishParam((Object)iamAuthInfoRecord);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        Set codes;
        List iamAssignmentAuthorizeParams;
        AbstractDeployTaskNode.AuthParam authParam;
        String env = deployParam.getEnv();
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        IamAuthInfoRecord iamAuthInfoRecord = this.iamAuthInfoRecordDao.selectByApplicationAndEnv(applicationData.getApplication(), env);
        if (iamAuthInfoRecord == null) {
            return null;
        }
        Set tenantUsers = deployParam.getTenantUsers().stream().map(TenantUser::getTenantId).collect(Collectors.toSet());
        Env publishEnv = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        DeployLog lastPublishLog = this.deployLogDao.findLastPublishLog(EnvOperateEnum.PUBLISH.getOperate(), publishEnv.getEnv(), applicationData.getApplication());
        DeployTask dataEntryPublishTask = this.deployTaskDao.selectByApplicationAndDeployNoAndType(applicationData.getApplication(), lastPublishLog.getDeployNo(), DeployTaskTypeEnum.INDIVIDUAL_BASIC_DATA_ENTRY_AUTH.getType());
        DeployTask otherReportPublishTask = this.deployTaskDao.selectByApplicationAndDeployNoAndType(applicationData.getApplication(), lastPublishLog.getDeployNo(), DeployTaskTypeEnum.INDIVIDUAL_OTHER_STATEMENT_AUTH.getType());
        DeployTask abiReportPublishTask = this.deployTaskDao.selectByApplicationAndDeployNoAndType(applicationData.getApplication(), lastPublishLog.getDeployNo(), DeployTaskTypeEnum.INDIVIDUAL_ABI_REPORT_AUTH.getType());
        DeployTask tbbReportPublishTask = this.deployTaskDao.selectByApplicationAndDeployNoAndType(applicationData.getApplication(), lastPublishLog.getDeployNo(), DeployTaskTypeEnum.INDIVIDUAL_TBB_REPORT_AUTH.getType());
        DeployTask startProjectPublishTask = this.deployTaskDao.selectByApplicationAndDeployNoAndType(applicationData.getApplication(), lastPublishLog.getDeployNo(), DeployTaskTypeEnum.INDIVIDUAL_START_PROJECT_AUTH.getType());
        if (dataEntryPublishTask != null) {
            authParam = (AbstractDeployTaskNode.AuthParam)dataEntryPublishTask.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            iamAssignmentAuthorizeParams = authParam.getIamAssignmentAuthorizeParams();
            codes = iamAssignmentAuthorizeParams.stream().map(i -> i.getAssignment().getString("code")).collect(Collectors.toSet());
            this.filterNeedDeleteIamAuthInfo(iamAuthInfoRecord.getDataEntry(), codes, tenantUsers);
        }
        if (otherReportPublishTask != null) {
            authParam = (AbstractDeployTaskNode.AuthParam)otherReportPublishTask.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            iamAssignmentAuthorizeParams = authParam.getIamAssignmentAuthorizeParams();
            codes = iamAssignmentAuthorizeParams.stream().map(i -> i.getAssignment().getString("code")).collect(Collectors.toSet());
            this.filterNeedDeleteIamAuthInfo(iamAuthInfoRecord.getOtherReport(), codes, tenantUsers);
        }
        if (abiReportPublishTask != null) {
            authParam = (AbstractDeployTaskNode.AuthParam)abiReportPublishTask.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            iamAssignmentAuthorizeParams = authParam.getIamAssignmentAuthorizeParams();
            codes = iamAssignmentAuthorizeParams.stream().map(i -> i.getAssignment().getString("code")).collect(Collectors.toSet());
            this.filterNeedDeleteIamAuthInfo(iamAuthInfoRecord.getAbiReport(), codes, tenantUsers);
        }
        if (tbbReportPublishTask != null) {
            authParam = (AbstractDeployTaskNode.AuthParam)tbbReportPublishTask.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            iamAssignmentAuthorizeParams = authParam.getIamAssignmentAuthorizeParams();
            codes = iamAssignmentAuthorizeParams.stream().map(i -> i.getAssignment().getString("code")).collect(Collectors.toSet());
            this.filterNeedDeleteIamAuthInfo(iamAuthInfoRecord.getTbbReport(), codes, tenantUsers);
        }
        if (startProjectPublishTask != null) {
            authParam = (AbstractDeployTaskNode.AuthParam)startProjectPublishTask.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            iamAssignmentAuthorizeParams = authParam.getIamAssignmentAuthorizeParams();
            codes = iamAssignmentAuthorizeParams.stream().map(i -> i.getAssignment().getString("code")).collect(Collectors.toSet());
            this.filterNeedDeleteIamAuthInfo(iamAuthInfoRecord.getStartProject(), codes, tenantUsers);
        }
        DeployTask deployTask = this.initSwitchTask(deployParam);
        deployTask.compressSetPublishParam((Object)iamAuthInfoRecord);
        return deployTask;
    }

    private void filterNeedDeleteIamAuthInfo(List<IamAuthInfoRecord.AuthInfo> authInfos, Set<String> codes, Set<String> tenantUsers) {
        Iterator<IamAuthInfoRecord.AuthInfo> iterator = authInfos.iterator();
        while (iterator.hasNext()) {
            IamAuthInfoRecord.AuthInfo info = iterator.next();
            if (!codes.contains(info.getCode()) || !tenantUsers.contains(info.getTenantId())) continue;
            iterator.remove();
        }
    }

    protected void doDeployExecute(DeployTask task) {
        IamAuthInfoRecord publishParam = (IamAuthInfoRecord)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteSelfAuth(task, publishParam);
    }

    private void deleteSelfAuth(DeployTask task, IamAuthInfoRecord publishParam) {
        List startProject = publishParam.getStartProject();
        List dataEntry = publishParam.getDataEntry();
        List tbbReport = publishParam.getTbbReport();
        List abiReport = publishParam.getAbiReport();
        List otherReport = publishParam.getOtherReport();
        ApplicationInfoDto applicationInfoDto = task.getApplicationInfoDto();
        DeletePermissionReqDto deletePermissionReqDto = new DeletePermissionReqDto();
        deletePermissionReqDto.setSysId(applicationInfoDto.isIndividual() ? applicationInfoDto.getSourceApplicationCode() : applicationInfoDto.getCode());
        deletePermissionReqDto.setTenantId(AthenaUserLocal.getUser().getTenantId());
        if (applicationInfoDto != null && applicationInfoDto.getCommonApp() != null && applicationInfoDto.getCommonApp().booleanValue()) {
            deletePermissionReqDto.addCommonPermissionInfo(startProject, Boolean.valueOf(true));
            deletePermissionReqDto.addCommonPermissionInfo(dataEntry, Boolean.valueOf(true));
            deletePermissionReqDto.addCommonPermissionInfo(tbbReport, Boolean.valueOf(true));
            deletePermissionReqDto.addCommonPermissionInfo(abiReport, Boolean.valueOf(true));
            deletePermissionReqDto.addCommonPermissionInfo(otherReport, Boolean.valueOf(true));
        } else {
            deletePermissionReqDto.addPermissionInfo(startProject, "startProject", Boolean.valueOf(true));
            deletePermissionReqDto.addPermissionInfo(dataEntry, "basicDataEntry", Boolean.valueOf(true));
            deletePermissionReqDto.addPermissionInfo(tbbReport, "report", Boolean.valueOf(true));
            deletePermissionReqDto.addPermissionInfo(abiReport, "report", Boolean.valueOf(true));
            deletePermissionReqDto.addPermissionInfo(otherReport, "report", Boolean.valueOf(true));
        }
        this.deployServiceApiHelper.iamBatchDeletePermissions(task.getEnv(), deletePermissionReqDto);
    }

    protected void doSwitchExecute(DeployTask task) {
        IamAuthInfoRecord publishParam = (IamAuthInfoRecord)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteSelfAuth(task, publishParam);
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.IAM_PERMISSION_REMOVAL;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.IAM_PERMISSION_REMOVAL;
    }
}

