/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.IamTenantAuthTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IamTenantAuthTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamTenantAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        DeployTask deployTask = this.initDeployTask(deployParam);
        IamTenantAuthParam iamTenantAuthParam = new IamTenantAuthParam();
        iamTenantAuthParam.setEnv(deployParam.getEnv());
        iamTenantAuthParam.setToken(AthenaUserLocal.getUser().getToken());
        iamTenantAuthParam.setTenantUsers(deployParam.getTenantUsers());
        iamTenantAuthParam.setApplicationDataList(deployParam.getApplicationDataList());
        deployTask.compressSetPublishParam((Object)iamTenantAuthParam);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        DeployTask deployTask = this.initSwitchTask(deployParam);
        IamTenantAuthParam iamTenantAuthParam = new IamTenantAuthParam();
        iamTenantAuthParam.setEnv(deployParam.getEnv());
        iamTenantAuthParam.setToken(AthenaUserLocal.getUser().getToken());
        iamTenantAuthParam.setTenantUsers(deployParam.getTenantUsers());
        iamTenantAuthParam.setApplicationDataList(deployParam.getApplicationDataList());
        deployTask.compressSetPublishParam((Object)iamTenantAuthParam);
        return deployTask;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("IamTenantAuthTask executing");
        IamTenantAuthParam iamTenantAuthParam = (IamTenantAuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        DeployParamV2 deployParamV2 = new DeployParamV2();
        deployParamV2.setTenantUsers(iamTenantAuthParam.getTenantUsers());
        deployParamV2.setApplicationDataList(iamTenantAuthParam.applicationDataList);
        this.backendApiHelper.authUser(deployParamV2, iamTenantAuthParam.getToken(), iamTenantAuthParam.getEnv());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("IamTenantAuthTask executing");
        IamTenantAuthParam iamTenantAuthParam = (IamTenantAuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        DeployParamV2 deployParamV2 = new DeployParamV2();
        deployParamV2.setTenantUsers(iamTenantAuthParam.getTenantUsers());
        deployParamV2.setApplicationDataList(iamTenantAuthParam.applicationDataList);
        this.backendApiHelper.authUser(deployParamV2, iamTenantAuthParam.getToken(), iamTenantAuthParam.getEnv());
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.IAM_TENANT_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.IAM_TENANT_AUTH;
    }
}

