/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployParamRecordDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.AdTemplatePublishParam;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.service.deployTask.AdTemplatePublishTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IndividualAdTemplatePublishTask
extends AdTemplatePublishTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndividualAdTemplatePublishTask.class);
    private DeployParamRecordDao deployParamRecordDao;

    @Autowired
    public void setDeployParamRecordDao(DeployParamRecordDao deployParamRecordDao) {
        this.deployParamRecordDao = deployParamRecordDao;
    }

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        List adTemplateList = parseCompileFileResult.getAdTemplateList();
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        if (CollUtil.isNotEmpty((Collection)adTemplateList)) {
            DeployTask deployTask = this.initDeployTask(deployParam);
            AdTemplatePublishTask.AdTemplatePublishParma adTemplatePublishParma = new AdTemplatePublishTask.AdTemplatePublishParma();
            adTemplatePublishParma.setAdTemplateList(adTemplateList);
            adTemplatePublishParma.setApplication(applicationData.getApplication());
            adTemplatePublishParma.setTenantUsers(deployParam.getTenantUsers());
            adTemplatePublishParma.setEnv(deployParam.getEnv());
            deployTask.compressSetPublishParam((Object)adTemplatePublishParma);
            List testTenants = this.getTestTenants(deployTask);
            List prodTenants = this.getProdTenants(deployTask);
            if (CollectionUtils.isEmpty((Collection)testTenants)) {
                if (!CollectionUtils.isEmpty((Collection)prodTenants)) {
                    this.deployServiceV4.recordLatestDeployParam(applicationData.getApplication(), deployParam.getEnv(), IdUtil.fastUUID(), "adTemplate", adTemplateList);
                }
                return null;
            }
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List adTemplateList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "adTemplate", null);
        if (adTemplateList.isEmpty()) {
            return null;
        }
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AdTemplatePublishTask.AdTemplateSwitchParam adTemplateSwitchParam = new AdTemplatePublishTask.AdTemplateSwitchParam();
        adTemplateSwitchParam.setApplication(applicationData.getApplication());
        adTemplateSwitchParam.setEnv(deployParam.getEnv());
        adTemplateSwitchParam.setUser(AthenaUserLocal.getUser());
        adTemplateSwitchParam.setTenantUsers(deployParam.getTenantUsers());
        adTemplateSwitchParam.setAdTemplateList(adTemplateList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList()));
        deployTask.compressSetPublishParam((Object)adTemplateSwitchParam);
        List prodTenants = this.getProdTenants(deployTask);
        if (CollectionUtils.isEmpty((Collection)prodTenants)) {
            return null;
        }
        return deployTask;
    }

    protected void doDeployExecute(DeployTask task) {
        AdTemplatePublishTask.AdTemplatePublishParma adTemplatePublishParma = (AdTemplatePublishTask.AdTemplatePublishParma)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List adTemplateList = adTemplatePublishParma.getAdTemplateList();
        String application = adTemplatePublishParma.getApplication();
        DeployParamRecord oldDeployParamRecord = this.deployParamRecordDao.selectOneByApplicationAndEnvAndType(application, task.getEnv(), "uc_app_adTemplate");
        if (oldDeployParamRecord == null) {
            oldDeployParamRecord = new DeployParamRecord().setApplication(application).setEnv(task.getEnv()).setType("uc_app_adTemplate");
            this.deployParamRecordDao.insert(oldDeployParamRecord);
        }
        if (CollUtil.isNotEmpty((Collection)adTemplateList)) {
            String env = adTemplatePublishParma.getEnv();
            List tenantUsers = this.getTestTenants(task);
            log.info(String.format("\u670d\u52a1\u7f16\u6392\u53d1\u5e03\uff0c\u6d4b\u8bd5\u79df\u6237:%s", JSONObject.toJSONString((Object)tenantUsers)));
            List newAdTemplatePublishInfos = this.generatePublishRecord(tenantUsers.stream().map(TenantUser::getTenantId).collect(Collectors.toList()), adTemplateList);
            newAdTemplatePublishInfos.forEach(a -> a.setIsCustom(Integer.valueOf(1)));
            if (!CollectionUtils.isEmpty((Collection)tenantUsers)) {
                this.individualAppAdTemplatePublish(tenantUsers, env, adTemplateList);
                this.deployParamRecordDao.removeByApplicationAndEnvAndType(application, env, "adTemplate");
                this.deployServiceV4.recordLatestDeployParam(application, env, task.getCompileDataCode(), "adTemplate", adTemplateList);
            }
            oldDeployParamRecord.setContent((Object)newAdTemplatePublishInfos);
            this.deployParamRecordDao.save(oldDeployParamRecord);
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        AdTemplatePublishTask.AdTemplateSwitchParam adTemplateSwitchParam = (AdTemplatePublishTask.AdTemplateSwitchParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List adTemplateList = adTemplateSwitchParam.getAdTemplateList();
        DeployParamRecord oldDeployParamRecord = this.deployParamRecordDao.selectOneByApplicationAndEnvAndType(task.getApplication(), task.getEnv(), "uc_app_adTemplate");
        if (oldDeployParamRecord == null) {
            oldDeployParamRecord = new DeployParamRecord().setApplication(task.getApplication()).setEnv(task.getEnv()).setType("uc_app_adTemplate");
            this.deployParamRecordDao.insert(oldDeployParamRecord);
        }
        if (CollUtil.isNotEmpty((Collection)adTemplateList)) {
            String env = adTemplateSwitchParam.getEnv();
            List tenantUsers = this.getProdTenants(task);
            log.info(String.format("\u670d\u52a1\u7f16\u6392\u53d1\u5e03\uff0c\u751f\u4ea7\u79df\u6237:%s", JSONObject.toJSONString((Object)tenantUsers)));
            if (!CollectionUtils.isEmpty((Collection)tenantUsers)) {
                this.individualAppAdTemplatePublish(tenantUsers, env, adTemplateList);
            }
            List newAdTemplatePublishInfos = this.generatePublishRecord(tenantUsers.stream().map(TenantUser::getTenantId).collect(Collectors.toList()), adTemplateList);
            newAdTemplatePublishInfos.forEach(a -> a.setIsCustom(Integer.valueOf(1)));
            oldDeployParamRecord.setContent((Object)newAdTemplatePublishInfos);
            this.deployParamRecordDao.save(oldDeployParamRecord);
        }
    }

    protected void individualAppAdTemplatePublish(List<TenantUser> tenantUsers, String env, List<JSONObject> adTemplateList) {
        for (JSONObject adTemplate : adTemplateList) {
            AdTemplatePublishParam adTemplatePublishParam = new AdTemplatePublishParam();
            adTemplatePublishParam.setAdTemplate(adTemplate).setEnv(env).setCurrentUser(AthenaUserLocal.getUser()).setTenantUsers(tenantUsers).setIsCustom(Integer.valueOf(1));
            this.backendApiHelper.adTemplatePublish(adTemplatePublishParam);
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.INDIVIDUAL_ADTEMPLATE_PUBLISH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.INDIVIDUAL_ADTEMPLATE_SWITCH;
    }
}

