/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployParamRecordDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.dto.deployer.AdTemplatePublishInfoDto;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IndividualAdTemplateStopTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndividualAdTemplateStopTask.class);
    private DeployParamRecordDao deployParamRecordDao;

    @Autowired
    public void setDeployParamRecordDao(DeployParamRecordDao deployParamRecordDao) {
        this.deployParamRecordDao = deployParamRecordDao;
    }

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        DeployParamRecord oldDeployParamRecord = this.deployParamRecordDao.selectOneByApplicationAndEnvAndType(applicationData.getApplication(), deployParam.getEnv(), "uc_app_adTemplate");
        if (oldDeployParamRecord == null) {
            return null;
        }
        List adTemplateList = parseCompileFileResult.getAdTemplateList();
        DeployTask deployTask = this.initDeployTask(deployParam);
        List testTenants = this.getTestTenants(deployTask);
        List adTemplatePublishInfoDtos = this.generatePublishRecord(testTenants.stream().map(TenantUser::getTenantId).collect(Collectors.toList()), adTemplateList);
        List needStopTemplateInfo = this.getNeedStopInfo(oldDeployParamRecord, adTemplatePublishInfoDtos);
        if (needStopTemplateInfo.isEmpty()) {
            return null;
        }
        deployTask.compressSetPublishParam((Object)needStopTemplateInfo);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        DeployParamRecord oldDeployParamRecord = this.deployParamRecordDao.selectOneByApplicationAndEnvAndType(applicationData.getApplication(), deployParam.getEnv(), "uc_app_adTemplate");
        if (oldDeployParamRecord == null) {
            return null;
        }
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List recordList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "adTemplate", null);
        List adTemplateList = recordList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        DeployTask deployTask = this.initSwitchTask(deployParam);
        List prodTenants = this.getProdTenants(deployTask);
        List adTemplatePublishInfoDtos = this.generatePublishRecord(prodTenants.stream().map(TenantUser::getTenantId).collect(Collectors.toList()), adTemplateList);
        List needStopInfo = this.getNeedStopInfo(oldDeployParamRecord, adTemplatePublishInfoDtos);
        if (needStopInfo.isEmpty()) {
            return null;
        }
        deployTask.compressSetPublishParam((Object)needStopInfo);
        return deployTask;
    }

    private List<AdTemplatePublishInfoDto> getNeedStopInfo(DeployParamRecord oldDeployParamRecord, List<AdTemplatePublishInfoDto> newAdTemplatePublishInfos) {
        List oldAdTemplatePublishInfos = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oldDeployParamRecord.getContent()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        return oldAdTemplatePublishInfos.stream().filter(o -> {
            for (AdTemplatePublishInfoDto newAdTemplatePublishInfo : newAdTemplatePublishInfos) {
                if (!newAdTemplatePublishInfo.getId().equals(o.getId()) || !newAdTemplatePublishInfo.getTenantId().equals(o.getTenantId())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.INDIVIDUAL_ADTEMPLATE_STOP;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.INDIVIDUAL_ADTEMPLATE_STOP;
    }

    protected void doDeployExecute(DeployTask task) {
        List stopInfo = (List)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.stopAdTemplate(stopInfo, task.getEnv());
    }

    protected void doSwitchExecute(DeployTask task) {
        List stopInfo = (List)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.stopAdTemplate(stopInfo, task.getEnv());
    }
}

