/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.BasicDataEntryAuthTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IndividualBasicDataEntryAuthTask
extends BasicDataEntryAuthTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndividualBasicDataEntryAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        List dataEntryList = parseCompileFileResult.getDataEntryList();
        List activityConfigList = parseCompileFileResult.getActivityConfigList();
        List individualDataEntryList = dataEntryList.stream().filter(t -> t.getBoolean("fromStandard") == null || t.getBoolean("fromStandard") == false).collect(Collectors.toList());
        List needAuthorizeDataEntries = this.deployServiceV4.filterNeedAuthStatements(activityConfigList, individualDataEntryList);
        if (CollUtil.isNotEmpty(individualDataEntryList) && CollUtil.isNotEmpty((Collection)deployParam.getTenantUsers())) {
            DeployTask deployTask = this.initDeployTask(deployParam);
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
            Boolean commonApp = this.getCommonApp(parseCompileFileResult);
            AbstractDeployTaskNode.AuthParam authParam = commonApp != false ? this.commonAllStatementAuthParam(deployParam, individualDataEntryList, needAuthorizeDataEntries, applicationData, parseCompileFileResult) : this.standardAllStatementAuthParam(deployParam, individualDataEntryList, needAuthorizeDataEntries, applicationData, this.getIamModuleId());
            authParam.getIamAssignmentAuthorizeParams().forEach(i -> i.setApplication(applicationInfoDto.getSourceApplicationCode()));
            authParam.getIamAddPolicyParam().forEach(i -> i.setApplication(applicationInfoDto.getSourceApplicationCode()));
            deployTask.compressSetPublishParam((Object)authParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        DeployTask switchTask = this.initIndividualIamAuthSwitchTask(deployParam);
        if (switchTask == null) {
            return null;
        }
        return switchTask;
    }

    protected void doSwitchExecute(DeployTask task) {
        this.individualAuthSwitch(task);
        this.createIamAuthInfoRecord(task, "dataEntry", EnvOperateEnum.SWITCH);
    }

    protected void doDeployExecute(DeployTask task) {
        this.individualIamAuthPublish(task);
        this.createIamAuthInfoRecord(task, "dataEntry", EnvOperateEnum.PUBLISH);
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.INDIVIDUAL_BASIC_DATA_ENTRY_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.INDIVIDUAL_BASIC_DATA_ENTRY_AUTH;
    }
}

