/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.http.deployService.dto.DeployAppReqDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.DeployAppResDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.TenantVersionUpdateReqDto;
import com.digiwin.athena.athenadeployer.service.deployTask.DataPublishTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import com.digiwin.athena.athenadeployer.utils.KmSecurityUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IndividualDataPublishTask
extends DataPublishTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndividualDataPublishTask.class);
    @Value(value="${currentEnvDomain}")
    private String currentEnvDomain;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        DeployTask deployTask = super.createDeployTask(deployParam, parseCompileFileResult);
        DataPublishTask.DataPublish publishParam = (DataPublishTask.DataPublish)deployTask.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        publishParam.setType("tenantApp");
        deployTask.compressSetPublishParam((Object)publishParam);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        return super.createSwitchTask(deployParam);
    }

    protected void doDeployExecute(DeployTask task) {
        log.info(task.getDeployNo() + " DataPublishTask executing");
        List testTenants = this.getTestTenants(task);
        log.info(String.format("km\u6570\u636e\u53d1\u5e03\uff0c\u79df\u6237\u7248\u672c\u5207\u6362\uff0c\u6d4b\u8bd5\u79df\u6237:%s", JSONObject.toJSONString((Object)testTenants)));
        this.updateTenantVersion(task, testTenants, EnvOperateEnum.PUBLISH.getVersion());
        DataPublishTask.DataPublish dataPublish = (DataPublishTask.DataPublish)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        ApplicationInfoDto applicationInfoDto = task.getApplicationInfoDto();
        DeployAppReqDto deployAppReqDto = new DeployAppReqDto();
        deployAppReqDto.setDeployerLogId(task.getDeployNo());
        deployAppReqDto.setApplication(task.getApplication());
        deployAppReqDto.setDeployTenantId(dataPublish.getUser().getTenantId());
        deployAppReqDto.setDeployerToken(dataPublish.getUser().getToken());
        deployAppReqDto.setDeployerDomain(this.currentEnvDomain);
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(11, 1);
        deployAppReqDto.setSourceApplicationCode(dataPublish.getSourceApplicationCode());
        deployAppReqDto.setNonce(IdUtil.fastSimpleUUID());
        deployAppReqDto.setTimestamp(Long.valueOf(calendar.getTimeInMillis()));
        deployAppReqDto.setAppId(dataPublish.getAppId());
        deployAppReqDto.setCommonApp(dataPublish.getCommonApp());
        deployAppReqDto.setSourceId(dataPublish.getSourceId());
        deployAppReqDto.setDeployId(dataPublish.getKmDeployId());
        deployAppReqDto.setType(dataPublish.getType());
        deployAppReqDto.setFileId(dataPublish.getFileId());
        deployAppReqDto.setSync(dataPublish.getSync());
        deployAppReqDto.setTenantIds(dataPublish.getTenantIds());
        deployAppReqDto.setSignature(KmSecurityUtils.sign((String)(deployAppReqDto.getDeployId() + deployAppReqDto.getNonce() + deployAppReqDto.getTimestamp())));
        deployAppReqDto.setIndividualAll(applicationInfoDto.getIndividualAll());
        DeployAppResDto deployAppResDto = this.deployServiceApiHelper.deployApp(dataPublish.getEnv(), deployAppReqDto);
        log.info(dataPublish.getKmDeployId() + "\u8fd4\u56de\u7684eventId:" + deployAppResDto.getEventId());
    }

    private void updateTenantVersion(DeployTask task, List<TenantUser> tenantUsers, String version) {
        if (!CollectionUtils.isEmpty(tenantUsers)) {
            TenantVersionUpdateReqDto tenantVersionUpdateReqDto = new TenantVersionUpdateReqDto();
            tenantVersionUpdateReqDto.setTenantIds(tenantUsers.stream().map(TenantUser::getTenantId).collect(Collectors.toList()));
            tenantVersionUpdateReqDto.setVersion(version);
            tenantVersionUpdateReqDto.setDeployTenantId(AthenaUserLocal.getUser().getTenantId());
            tenantVersionUpdateReqDto.setDeployId(IdUtil.fastSimpleUUID());
            tenantVersionUpdateReqDto.setNonce(IdUtil.fastSimpleUUID());
            Date currentDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentDate);
            calendar.add(11, 1);
            tenantVersionUpdateReqDto.setTimestamp(Long.valueOf(calendar.getTimeInMillis()));
            tenantVersionUpdateReqDto.setSignature(KmSecurityUtils.sign((String)(tenantVersionUpdateReqDto.getDeployId() + tenantVersionUpdateReqDto.getNonce() + tenantVersionUpdateReqDto.getTimestamp())));
            this.deployServiceApiHelper.updateVersion(task.getEnv(), tenantVersionUpdateReqDto);
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.INDIVIDUAL_KM_DATA_PUBLISH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.INDIVIDUAL_KM_DATA_SWITCH;
    }
}

