/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.OtherStatementAuthTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IndividualOtherStatementAuthTask
extends OtherStatementAuthTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndividualOtherStatementAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        List statementList = parseCompileFileResult.getStatementList();
        if (CollUtil.isNotEmpty((Collection)statementList)) {
            List otherStatementList = statementList.stream().filter(t -> this.isAbiStatement(t.getString("pattern"), t.getString("category")) == false && this.isTbbStatement(t.getString("pattern"), t.getString("category")) == false).filter(t -> t.getBoolean("fromStandard") == null || t.getBoolean("fromStandard") == false).collect(Collectors.toList());
            if (CollUtil.isEmpty(otherStatementList) && CollUtil.isNotEmpty((Collection)deployParam.getTenantUsers())) {
                return null;
            }
            DeployTask deployTask = this.initDeployTask(deployParam);
            List activityConfigList = parseCompileFileResult.getActivityConfigList();
            List needAuthorizeOtherStatements = this.deployServiceV4.filterNeedAuthStatements(activityConfigList, otherStatementList);
            Boolean commonApp = this.getCommonApp(parseCompileFileResult);
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
            AbstractDeployTaskNode.AuthParam authParam = commonApp != false ? this.commonAllStatementAuthParam(deployParam, otherStatementList, needAuthorizeOtherStatements, applicationData, parseCompileFileResult) : this.standardAllStatementAuthParam(deployParam, otherStatementList, needAuthorizeOtherStatements, applicationData, this.getIamModuleId());
            authParam.getIamAssignmentAuthorizeParams().forEach(i -> i.setApplication(applicationInfoDto.getSourceApplicationCode()));
            authParam.getIamAddPolicyParam().forEach(i -> i.setApplication(applicationInfoDto.getSourceApplicationCode()));
            deployTask.compressSetPublishParam((Object)authParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        DeployTask switchTask = this.initIndividualIamAuthSwitchTask(deployParam);
        if (switchTask == null) {
            return null;
        }
        return switchTask;
    }

    protected void doSwitchExecute(DeployTask task) {
        this.individualAuthSwitch(task);
        this.createIamAuthInfoRecord(task, "otherReport", EnvOperateEnum.SWITCH);
    }

    protected void doDeployExecute(DeployTask task) {
        this.individualIamAuthPublish(task);
        this.createIamAuthInfoRecord(task, "otherReport", EnvOperateEnum.PUBLISH);
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.INDIVIDUAL_OTHER_STATEMENT_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.INDIVIDUAL_OTHER_STATEMENT_AUTH;
    }
}

