/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.StartProjectAuthTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IndividualStartProjectAuthTask
extends StartProjectAuthTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndividualStartProjectAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        List startProjectList = parseCompileFileResult.getStartProjectList();
        if (!CollectionUtils.isEmpty((Collection)startProjectList)) {
            List allIndividualStartProjectList = startProjectList.stream().filter(t -> t.getBoolean("fromStandard") == null || t.getBoolean("fromStandard") == false).collect(Collectors.toList());
            List needAuthorizeStartProjects = allIndividualStartProjectList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getString("authorityPrefix"))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(allIndividualStartProjectList) && CollUtil.isNotEmpty((Collection)deployParam.getTenantUsers())) {
                ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
                ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
                Boolean commonApp = this.getCommonApp(parseCompileFileResult);
                DeployTask deployTask = this.initDeployTask(deployParam);
                AbstractDeployTaskNode.AuthParam authParam = commonApp != false ? this.commonAllStatementAuthParam(deployParam, allIndividualStartProjectList, needAuthorizeStartProjects, applicationData, parseCompileFileResult) : this.standardAllStatementAuthParam(deployParam, allIndividualStartProjectList, needAuthorizeStartProjects, applicationData, this.getIamModuleId());
                authParam.getIamAssignmentAuthorizeParams().forEach(i -> i.setApplication(applicationInfoDto.getSourceApplicationCode()));
                authParam.getIamAddPolicyParam().forEach(i -> i.setApplication(applicationInfoDto.getSourceApplicationCode()));
                deployTask.compressSetPublishParam((Object)authParam);
                return deployTask;
            }
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        DeployTask switchTask = this.initIndividualIamAuthSwitchTask(deployParam);
        if (switchTask == null) {
            return null;
        }
        return switchTask;
    }

    protected void doDeployExecute(DeployTask task) {
        this.individualIamAuthPublish(task);
        this.createIamAuthInfoRecord(task, "startProject", EnvOperateEnum.PUBLISH);
    }

    protected void doSwitchExecute(DeployTask task) {
        this.individualAuthSwitch(task);
        this.createIamAuthInfoRecord(task, "startProject", EnvOperateEnum.SWITCH);
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.INDIVIDUAL_START_PROJECT_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.INDIVIDUAL_START_PROJECT_AUTH;
    }
}

