/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.service.deployTask.TbbReportPublishTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IndividualTbbReportPublishTask
extends TbbReportPublishTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndividualTbbReportPublishTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List tbbStatementList;
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        List statementList = parseCompileFileResult.getStatementList();
        if (CollUtil.isNotEmpty((Collection)statementList) && CollUtil.isNotEmpty(tbbStatementList = statementList.stream().filter(t -> this.isTbbStatement(t.getString("pattern"), t.getString("category"))).collect(Collectors.toList()))) {
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            DeployTask deployTask = this.initDeployTask(deployParam);
            List statements = tbbStatementList.stream().map(o -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("resCode", o.get((Object)"resCode"));
                jsonObject.put("code", o.get((Object)"code"));
                jsonObject.put("tenantId", o.get((Object)"tenantId"));
                return jsonObject;
            }).collect(Collectors.toList());
            TbbReportPublishTask.TbbReportPublishParam tbbReportPublishParam = new TbbReportPublishTask.TbbReportPublishParam();
            tbbReportPublishParam.setEnv(deployParam.getEnv());
            tbbReportPublishParam.setApplication(applicationData.getApplication());
            tbbReportPublishParam.setUser(AthenaUserLocal.getUser());
            tbbReportPublishParam.setTbbStatementList(statements);
            tbbReportPublishParam.setTenantUsers(deployParam.getTenantUsers());
            tbbReportPublishParam.setBranch(parseCompileFileResult.getBranch());
            deployTask.compressSetPublishParam((Object)tbbReportPublishParam);
            List testTenants = this.getTestTenants(deployTask);
            List prodTenants = this.getProdTenants(deployTask);
            if (CollectionUtils.isEmpty((Collection)testTenants)) {
                if (!CollectionUtils.isEmpty((Collection)prodTenants)) {
                    this.deployServiceV4.recordLatestDeployParam(applicationData.getApplication(), deployParam.getEnv(), IdUtil.fastUUID(), "tbb", statements);
                }
                return null;
            }
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        if (!this.isIndividualApp(deployParam).booleanValue()) {
            return null;
        }
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env publishEnv = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List tbbRecord = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), publishEnv.getEnv(), "tbb", null);
        if (tbbRecord.isEmpty()) {
            return null;
        }
        ArrayList<JSONObject> statements = new ArrayList<JSONObject>();
        for (DeployParamRecord deployParamRecord : tbbRecord) {
            JSONObject value = deployParamRecord.getValue();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", (Object)value.getString("code"));
            jsonObject.put("resCode", (Object)value.getString("resCode"));
            statements.add(jsonObject);
        }
        DeployTask deployTask = this.initSwitchTask(deployParam);
        DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(applicationData.getApplication(), deployParam.getId());
        JSONObject compileData = deployLog.getCompileData();
        TbbReportPublishTask.TbbReportPublishParam tbbReportPublishParam = new TbbReportPublishTask.TbbReportPublishParam();
        tbbReportPublishParam.setEnv(deployParam.getEnv());
        tbbReportPublishParam.setApplication(applicationData.getApplication());
        tbbReportPublishParam.setUser(AthenaUserLocal.getUser());
        tbbReportPublishParam.setTbbStatementList(statements);
        tbbReportPublishParam.setTenantUsers(deployParam.getTenantUsers());
        tbbReportPublishParam.setBranch(compileData.getString("branch"));
        deployTask.compressSetPublishParam((Object)tbbReportPublishParam);
        List prodTenants = this.getProdTenants(deployTask);
        if (CollectionUtils.isEmpty((Collection)prodTenants)) {
            return null;
        }
        return deployTask;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("TbbReportPublishTask executing");
        TbbReportPublishTask.TbbReportPublishParam tbbReportPublishParam = (TbbReportPublishTask.TbbReportPublishParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        ApplicationInfoDto applicationInfoDto = task.getApplicationInfoDto();
        String application = tbbReportPublishParam.getApplication();
        String env = tbbReportPublishParam.getEnv();
        String token = tbbReportPublishParam.getUser().getToken();
        String branch = tbbReportPublishParam.getBranch();
        List testTenants = this.getTestTenants(task);
        List tenantIdList = testTenants.stream().map(TenantUser::getTenantId).collect(Collectors.toList());
        List tbbStatementList = tbbReportPublishParam.getTbbStatementList();
        this.deployServiceV4.recordLatestDeployParam(application, env, task.getCompileDataCode(), "tbb", tbbStatementList);
        if (CollUtil.isNotEmpty((Collection)tbbStatementList)) {
            ArrayList<String> resCodes = new ArrayList<String>();
            ArrayList reports = new ArrayList();
            for (JSONObject tbbStatement : tbbStatementList) {
                String resCode = tbbStatement.getString("resCode");
                if (StringUtils.isEmpty((CharSequence)resCode)) {
                    resCode = tbbStatement.getString("code");
                }
                resCodes.add(resCode);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("code", tbbStatement.getString("code"));
                map.put("resCode", resCode);
                reports.add(map);
            }
            JSONObject param = new JSONObject();
            param.put("token", (Object)token);
            param.put("appCode", (Object)applicationInfoDto.getSourceApplicationCode());
            param.put("ucAppCode", (Object)application);
            param.put("env", (Object)env);
            param.put("tenantIds", tenantIdList);
            param.put("reportList", resCodes);
            param.put("operate", (Object)"publish");
            param.put("reports", reports);
            param.put("ucTenantIdList", task.getTenantUsers().stream().map(TenantUser::getTenantId).collect(Collectors.toList()));
            this.backendApiHelper.tbbStatementPublish(param, branch, token);
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        TbbReportPublishTask.TbbReportPublishParam tbbReportPublishParam = (TbbReportPublishTask.TbbReportPublishParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List testTenants = this.getProdTenants(task);
        List tenantIdList = testTenants.stream().map(TenantUser::getTenantId).collect(Collectors.toList());
        ApplicationInfoDto applicationInfoDto = task.getApplicationInfoDto();
        String application = tbbReportPublishParam.getApplication();
        String env = tbbReportPublishParam.getEnv();
        String token = tbbReportPublishParam.getUser().getToken();
        String branch = tbbReportPublishParam.getBranch();
        List tbbStatementList = tbbReportPublishParam.getTbbStatementList();
        if (CollUtil.isNotEmpty((Collection)tbbStatementList)) {
            ArrayList<String> resCodes = new ArrayList<String>();
            ArrayList reports = new ArrayList();
            for (JSONObject tbbStatement : tbbStatementList) {
                String resCode = tbbStatement.getString("resCode");
                if (StringUtils.isEmpty((CharSequence)resCode)) {
                    resCode = tbbStatement.getString("code");
                }
                resCodes.add(resCode);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("code", tbbStatement.getString("code"));
                map.put("resCode", resCode);
                reports.add(map);
            }
            JSONObject param = new JSONObject();
            param.put("token", (Object)token);
            param.put("appCode", (Object)applicationInfoDto.getSourceApplicationCode());
            param.put("ucAppCode", (Object)application);
            param.put("env", (Object)env);
            param.put("tenantIds", tenantIdList);
            param.put("reportList", resCodes);
            param.put("operate", (Object)"switch");
            param.put("reports", reports);
            param.put("ucTenantIdList", task.getTenantUsers().stream().map(TenantUser::getTenantId).collect(Collectors.toList()));
            this.backendApiHelper.tbbStatementPublish(param, branch, token);
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.INDIVIDUAL_TBB_REPORT_PUBLISH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.INDIVIDUAL_TBB_REPORT_SWITCH;
    }

    public String deployDetailLevel() {
        return "warn";
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return false;
    }
}

