/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.service.AsyncService;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.KitAssignPublishTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class KitAssignPublishTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KitAssignPublishTask.class);
    @Autowired
    private AsyncService asyncService;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List kitAssignList = parseCompileFileResult.getKitAssignList();
        if (!CollectionUtils.isEmpty((Collection)kitAssignList)) {
            DeployTask deployTask = this.initDeployTask(deployParam);
            KitAssignPublishParam kitAssignPublishParam = new KitAssignPublishParam();
            AthenaUser user = AthenaUserLocal.getUser();
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            kitAssignPublishParam.setApplication(applicationData.getApplication());
            kitAssignPublishParam.setEnv(deployParam.getEnv());
            kitAssignPublishParam.setTenantUsers(deployParam.getTenantUsers());
            kitAssignPublishParam.setTenantId(user.getTenantId());
            kitAssignPublishParam.setToken(user.getToken());
            ArrayList<JSONObject> kitAssigns = new ArrayList<JSONObject>();
            for (JSONObject kitAssign : kitAssignList) {
                JSONObject kitAssign1;
                JSONObject publishKitAssignInfo = kitAssign.getJSONObject("publishKitAssignInfo");
                kitAssign.put("tenantId", (Object)user.getTenantId());
                if (!ObjectUtils.isNotEmpty((Object)publishKitAssignInfo) || !ObjectUtils.isNotEmpty((Object)(kitAssign1 = publishKitAssignInfo.getJSONObject("kitAssign")))) continue;
                kitAssigns.add(kitAssign1);
            }
            kitAssignPublishParam.setKitAssigns(kitAssigns);
            deployTask.compressSetPublishParam((Object)kitAssignPublishParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        DeployTask oldDeployTask = this.deployTaskDao.selectLastPublishByApplicationAndTypeAndEnv(applicationData.getApplication(), DeployTaskTypeEnum.KIT_ASSIGN_PUBLISH, env.getEnv());
        if (oldDeployTask == null) {
            return null;
        }
        AthenaUser user = AthenaUserLocal.getUser();
        KitAssignPublishParam kitAssignPublishParam = (KitAssignPublishParam)oldDeployTask.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        DeployTask deployTask = this.initSwitchTask(deployParam);
        kitAssignPublishParam.setEnv(deployParam.getEnv());
        kitAssignPublishParam.setTenantUsers(deployParam.getTenantUsers());
        kitAssignPublishParam.setTenantId(user.getTenantId());
        kitAssignPublishParam.setToken(user.getToken());
        List kitAssigns = kitAssignPublishParam.getKitAssigns();
        kitAssigns.forEach(k -> k.put("version", (Object)"2.0"));
        deployTask.compressSetPublishParam((Object)kitAssignPublishParam);
        return deployTask;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("KitAssignPublishTask executing");
        KitAssignPublishParam kitAssignPublishParam = (KitAssignPublishParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List kitAssigns = kitAssignPublishParam.getKitAssigns();
        if (!kitAssigns.isEmpty()) {
            String env = kitAssignPublishParam.getEnv();
            String application = kitAssignPublishParam.getApplication();
            this.backendApiHelper.publishKitAssign(env, kitAssigns, kitAssignPublishParam.getToken(), kitAssignPublishParam.getTenantId());
            List tenantUsers = kitAssignPublishParam.tenantUsers;
            for (TenantUser tenantUser : tenantUsers) {
                String targetTenantId = tenantUser.getTenantId();
                for (JSONObject jsonObject : kitAssigns) {
                    String code = jsonObject.getString("code");
                    this.asyncService.moduleAssignPublishRecord(targetTenantId, "", env, application, code, "KIT_ASSIGN", AthenaUserLocal.getUser(), null);
                }
            }
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        KitAssignPublishParam kitAssignPublishParam = (KitAssignPublishParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List kitAssigns = kitAssignPublishParam.getKitAssigns();
        if (!kitAssigns.isEmpty()) {
            String env = kitAssignPublishParam.getEnv();
            this.backendApiHelper.publishKitAssign(env, kitAssigns, kitAssignPublishParam.getToken(), kitAssignPublishParam.getTenantId());
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.KIT_ASSIGN_PUBLISH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.KIT_ASSIGN_SWITCH;
    }
}

