/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployParamRecordDao;
import com.digiwin.athena.athenadeployer.domain.action.MultiLanguageDTO;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.MessageCenterTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MessageCenterTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageCenterTask.class);
    @Autowired
    protected BackendApiHelper backendApiHelper;
    @Autowired
    private DeployParamRecordDao deployParamRecordDao;
    public static final String ADD = "add";
    public static final String MOD = "mod";
    public static final String DEL = "del";
    public static final String UNCH = "unch";
    public static final String ADP_OP = "adpOp";

    public DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        log.info("\u6d88\u606f\u4e2d\u5fc3\u6574\u4f53\u53d1\u5e03deployParam\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)deployParam));
        List aimEventList = parseCompileFileResult.getAimEventList();
        List aimSceneList = parseCompileFileResult.getAimSceneList();
        log.info("\u6d88\u606f\u4e2d\u5fc3\u6574\u4f53\u53d1\u5e03aimEventList:{}", (Object)JSONObject.toJSONString((Object)aimEventList));
        log.info("\u6d88\u606f\u4e2d\u5fc3\u6574\u4f53\u53d1\u5e03aimSceneList\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)aimSceneList));
        DeployTask deployTask = this.initDeployTask(deployParam);
        JSONObject application = this.getApplication(parseCompileFileResult);
        log.info("\u6d88\u606f\u4e2d\u5fc3\u53d1\u5e03 \u5e94\u7528\u4fe1\u606f\u4e3a:{}", (Object)application);
        String appCode = application.getString("code");
        String appName = application.getString("name");
        JSONObject lang = application.getJSONObject("lang");
        DeployParamRecord deployParamRecord = this.queryDeployParamRecord(appCode, deployParam.getEnv());
        this.handlePublishData(aimEventList, deployParamRecord, true);
        this.handlePublishData(aimSceneList, deployParamRecord, false);
        MessageCenterPublishData messageCenterPublishData = new MessageCenterPublishData();
        messageCenterPublishData.setTriggerTiming(aimEventList);
        messageCenterPublishData.setAthenaTypes(aimSceneList);
        messageCenterPublishData.setSource(appCode);
        messageCenterPublishData.setSourceName(appName);
        JSONObject name = lang.getJSONObject("name");
        MultiLanguageDTO languageDTO = new MultiLanguageDTO();
        languageDTO.setEn_US(name.getString("en_US"));
        languageDTO.setZh_CN("zh_CN");
        languageDTO.setZh_TW("zh_TW");
        HashMap<String, MultiLanguageDTO> languageMap = new HashMap<String, MultiLanguageDTO>();
        languageMap.put("sourceName", languageDTO);
        messageCenterPublishData.setLang(languageMap);
        deployTask.setPublishParam((Object)messageCenterPublishData);
        return deployTask;
    }

    private void handlePublishData(List<JSONObject> dataList, DeployParamRecord deployParamRecord, boolean isEvent) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        if (deployParamRecord == null) {
            for (JSONObject data : dataList) {
                data.put(ADP_OP, (Object)ADD);
            }
        } else {
            String key = isEvent ? "triggerTiming" : "athenaTypes";
            JSONObject value = deployParamRecord.getValue();
            JSONArray eventOrSceneMapJSONArray = value.getJSONArray(key);
            Map eventOrSceneMap = this.convertEventOrScceneToMap(eventOrSceneMapJSONArray, isEvent);
            log.info("\u4e8b\u4ef6\u6216\u8005\u573a\u666f\u8f6c\u4e3amap:{}", (Object)eventOrSceneMap);
            for (JSONObject data : dataList) {
                String dataId = isEvent ? data.getString("eventId") : data.getString("sid");
                String adpSign = data.getString("adpSign");
                JSONObject publishRecordData = (JSONObject)eventOrSceneMap.get(dataId);
                if (publishRecordData == null) {
                    data.put(ADP_OP, (Object)ADD);
                    continue;
                }
                if (adpSign.equals(publishRecordData.getString("adpSign"))) {
                    data.put(ADP_OP, (Object)UNCH);
                } else {
                    data.put(ADP_OP, (Object)MOD);
                }
                eventOrSceneMap.remove(dataId);
            }
            if (!CollectionUtils.isEmpty((Map)eventOrSceneMap)) {
                eventOrSceneMap.forEach((k, v) -> {
                    v.put(ADP_OP, (Object)DEL);
                    dataList.add((JSONObject)v);
                });
            }
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.MESSAGE_CENTER_PUBLISH;
    }

    protected void doDeployExecute(DeployTask task) {
        MessageCenterPublishData messageCenterPublishData = (MessageCenterPublishData)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        String source = messageCenterPublishData.getSource();
        List athenaTypes = messageCenterPublishData.getAthenaTypes();
        List triggerTiming = messageCenterPublishData.getTriggerTiming();
        String sourceName = messageCenterPublishData.getSourceName();
        String env = task.getEnv();
        this.syncMessageCenterToDap(env, messageCenterPublishData);
        DeployParamRecord deployParamRecord = this.queryDeployParamRecord(source, env);
        if (deployParamRecord != null) {
            log.info("\u5f00\u59cb\u5220\u9664\u6d88\u606f\u4e2d\u5fc3\u53d1\u5e03\u8bb0\u5f55");
            this.deployParamRecordDao.removeByApplicationAndEnvAndType(source, env, "messageCenter");
        }
        List filteredAthenaTypes = Optional.ofNullable(athenaTypes).orElseGet(Collections::emptyList).stream().filter(jsonObject -> !jsonObject.getString(ADP_OP).equals(DEL)).collect(Collectors.toList());
        List filteredTriggerTiming = Optional.ofNullable(triggerTiming).orElseGet(Collections::emptyList).stream().filter(jsonObject -> !jsonObject.getString(ADP_OP).equals(DEL)).collect(Collectors.toList());
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("triggerTiming", filteredTriggerTiming);
        jsonObject2.put("athenaTypes", filteredAthenaTypes);
        jsonObject2.put("source", (Object)source);
        jsonObject2.put("sourceName", (Object)sourceName);
        log.info("\u5f00\u59cb\u8bb0\u5f55\u6d88\u606f\u4e2d\u5fc3\u53d1\u5e03\u8bb0\u5f55");
        DeployParamRecord record = new DeployParamRecord().setApplication(source).setEnv(env).setType("messageCenter").setValue(jsonObject2);
        this.deployParamRecordDao.insert(record);
    }

    public DeployParamRecord queryDeployParamRecord(String appCode, String env) {
        return this.deployParamRecordDao.selectOneByApplicationAndEnvAndType(appCode, env, "messageCenter");
    }

    public String deployDetailLevel() {
        return "warn";
    }

    private void syncMessageCenterToDap(String env, MessageCenterPublishData messageCenterPublishData) {
        try {
            this.backendApiHelper.messageCenterPublishDap(env, messageCenterPublishData);
        }
        catch (Exception exception) {
            String error = "syncMessageCenterToDap have exception :" + exception.getMessage();
            log.error(error);
            throw new BusinessException(error);
        }
    }

    public Map<String, JSONObject> convertEventOrScceneToMap(JSONArray jsonArray, boolean isEvent) {
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (isEvent) {
                String eventId = jsonObject.getString("eventId");
                map.put(eventId, jsonObject);
                continue;
            }
            String sid = jsonObject.getString("sid");
            map.put(sid, jsonObject);
        }
        return map;
    }
}

