/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MobilePageDesignAuthTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobilePageDesignAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List mobilePageDesignList = parseCompileFileResult.getMobilePageDesignList();
        if (!CollectionUtils.isEmpty((Collection)mobilePageDesignList)) {
            List needAuthorizeMobilePageDesigns = this.deployServiceV4.filterNeedAuthStatements(mobilePageDesignList, mobilePageDesignList);
            if (!CollectionUtils.isEmpty((Collection)mobilePageDesignList)) {
                DeployTask deployTask = this.initDeployTask(deployParam);
                ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
                Boolean commonApp = this.getCommonApp(parseCompileFileResult);
                AbstractDeployTaskNode.AuthParam authParam = commonApp != false ? this.commonAllStatementAuthParam(deployParam, mobilePageDesignList, needAuthorizeMobilePageDesigns, applicationData, parseCompileFileResult) : this.standardAllStatementAuthParam(deployParam, mobilePageDesignList, needAuthorizeMobilePageDesigns, applicationData, this.getIamModuleId());
                List jsonObjects = this.filterNeedAuthSysStatements(needAuthorizeMobilePageDesigns);
                jsonObjects.addAll(this.filterNoNeedAuthStatements(mobilePageDesignList, jsonObjects));
                authParam.setNeedAuthorizeSys(jsonObjects);
                deployTask.compressSetPublishParam((Object)authParam);
                return deployTask;
            }
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List recordList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "needAuthorizeMobilePageDesigns", null);
        if (recordList.isEmpty()) {
            return null;
        }
        List applications = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "application", null);
        JSONObject appJson = ((DeployParamRecord)applications.get(0)).getValue();
        Boolean commonApp = appJson.getBoolean("commonApp");
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AbstractDeployTaskNode.AuthParam authParam = new AbstractDeployTaskNode.AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        List assignmentList = recordList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        authParam.setCommonApp(commonApp);
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(user.getTenantId()).setAssignmentList(assignmentList).setToken(user.getToken()).setApplication(applicationData.getApplication()).setEnv(deployParam.getEnv()).setAppJson(appJson);
        authParam.setGmcUpdateParam(gmcUpdateParam);
        deployTask.compressSetPublishParam((Object)authParam);
        return deployTask;
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.MOBILE_PAGE_DESIGN_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.MOBILE_PAGE_DESIGN_AUTH;
    }

    String getIamModuleId() {
        return "mobilePageDesign";
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("MobilePageDesignAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (authParam.getCommonApp().booleanValue()) {
            this.commonIamAssignmentAuthorize(task, authParam);
            this.commonIamAddPolicy(task, authParam);
        } else {
            this.iamAssignmentAuthorize(task, authParam);
            this.iamAddPolicy(task, authParam);
        }
        this.deployServiceV4.recordLatestDeployParam(task.getApplication(), authParam.getEnv(), task.getCompileDataCode(), "needAuthorizeMobilePageDesigns", authParam.getNeedAuthorizeSys());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("MobilePageDesignAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        GmcUpdateParam gmcUpdateParam = authParam.getGmcUpdateParam();
        if (authParam.getCommonApp().booleanValue()) {
            gmcUpdateParam.setVersion(EnvOperateEnum.SWITCH.getVersion());
            this.backendApiHelper.updateCommonGmcMoudle(gmcUpdateParam);
        } else {
            this.backendApiHelper.updateGmcMoudle(gmcUpdateParam);
        }
    }
}

