/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.service.DeployServiceV3;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.ModelDriverPublishTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ModelDriverPublishTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelDriverPublishTask.class);
    @Autowired
    private DeployServiceV3 deployServiceV3;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List modelDrivenList = parseCompileFileResult.getModelDrivenList();
        if (!CollectionUtils.isEmpty((Collection)modelDrivenList)) {
            DeployTask deployTask = this.initDeployTask(deployParam);
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            ModelDriverPublishParam modelDriverPublishParam = new ModelDriverPublishParam();
            modelDriverPublishParam.setEnv(deployParam.getEnv());
            modelDriverPublishParam.setAthenaUser(AthenaUserLocal.getUser());
            modelDriverPublishParam.setModelDrivenList(modelDrivenList);
            modelDriverPublishParam.setApplication(applicationData.getApplication());
            modelDriverPublishParam.setTenantUsers(deployParam.getTenantUsers());
            modelDriverPublishParam.setBranch(parseCompileFileResult.getBranch());
            deployTask.compressSetPublishParam((Object)modelDriverPublishParam);
            return deployTask;
        }
        return null;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("ModelDriverPublishTask executing");
        ModelDriverPublishParam modelDriverPublishParam = (ModelDriverPublishParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List modelDrivenList = modelDriverPublishParam.getModelDrivenList();
        if (!CollectionUtils.isEmpty((Collection)modelDrivenList)) {
            String application = modelDriverPublishParam.getApplication();
            String env = modelDriverPublishParam.getEnv();
            String deployNo = task.getDeployNo();
            List tenantUsers = modelDriverPublishParam.getTenantUsers();
            this.deployServiceV3.modelDrivenPublish(application, env, deployNo, modelDrivenList, tenantUsers, modelDriverPublishParam.getBranch());
            this.deployServiceV3.deleteModelDriven(application, env, deployNo, modelDrivenList);
            this.deployServiceV3.deleteActionMetaData(application, env, deployNo, modelDrivenList);
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.MODEL_DRIVER_PUBLISH;
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return true;
    }
}

