/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SceneAuthTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SceneAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List scene;
        if (deployParam.getEnvServiceId().equals("AzureProd") || deployParam.getEnvServiceId().equals("HuaweiTest") || deployParam.getEnvServiceId().equals("AliTest") || deployParam.getEnvServiceId().equals("AliProd")) {
            return null;
        }
        List triggerList = parseCompileFileResult.getTriggerList();
        if (!CollectionUtils.isEmpty((Collection)triggerList) && !CollectionUtils.isEmpty(scene = triggerList.stream().filter(trigger -> StringUtils.isNotEmpty((CharSequence)trigger.getString("authorityPrefix")) && StringUtils.equals((CharSequence)trigger.getString("viewType"), (CharSequence)"scene")).collect(Collectors.toList()))) {
            DeployTask deployTask = this.initDeployTask(deployParam);
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            AbstractDeployTaskNode.AuthParam authParam = this.standardStatementAuthParam(deployParam, scene, applicationData, this.getIamModuleId());
            List needAuthorizeSysTriggers = this.filterNeedAuthSysStatements(scene);
            authParam.setNeedAuthorizeSys(needAuthorizeSysTriggers);
            deployTask.compressSetPublishParam((Object)authParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        if (deployParam.getEnvServiceId().equals("AzureProd") || deployParam.getEnvServiceId().equals("HuaweiTest") || deployParam.getEnvServiceId().equals("AliTest") || deployParam.getEnvServiceId().equals("AliProd")) {
            return null;
        }
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List recordList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "needAuthorizeSceneData", null);
        if (recordList.isEmpty()) {
            return null;
        }
        List applications = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "application", null);
        JSONObject appJson = ((DeployParamRecord)applications.get(0)).getValue();
        Boolean commonApp = appJson.getBoolean("commonApp");
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AbstractDeployTaskNode.AuthParam authParam = new AbstractDeployTaskNode.AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        List assignmentList = recordList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        authParam.setCommonApp(commonApp);
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(user.getTenantId()).setAssignmentList(assignmentList).setToken(user.getToken()).setApplication(applicationData.getApplication()).setEnv(deployParam.getEnv()).setAppJson(appJson);
        authParam.setGmcUpdateParam(gmcUpdateParam);
        deployTask.compressSetPublishParam((Object)authParam);
        return deployTask;
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.AGILE_DATA_SCENE_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.AGILE_DATA_SCENE_AUTH;
    }

    String getIamModuleId() {
        return "scene";
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("SceneDeployAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.iamAssignmentAuthorize(task, authParam);
        this.iamAddPolicy(task, authParam);
        this.deployServiceV4.recordLatestDeployParam(task.getApplication(), authParam.getEnv(), task.getCompileDataCode(), "needAuthorizeSceneData", authParam.getNeedAuthorizeSys());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("SceneSwitchAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        GmcUpdateParam gmcUpdateParam = authParam.getGmcUpdateParam();
        this.backendApiHelper.updateGmcMoudle(gmcUpdateParam);
    }
}

