/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.PublishDataEntryAndModelDataParam;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ServiceVersionJudgeTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceVersionJudgeTask.class);
    @Value(value="${sdk.version}")
    private String version;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List modelDrivenList = parseCompileFileResult.getModelDrivenList();
        ArrayList<String> serviceCodes = new ArrayList<String>();
        for (JSONObject modelDriven : modelDrivenList) {
            String serviceCode;
            JSONObject publishModelDrivenInfo = modelDriven.getJSONObject("publishModelDrivenInfo");
            if (null == publishModelDrivenInfo || !StringUtils.isNotBlank((CharSequence)(serviceCode = publishModelDrivenInfo.getString("serviceCode"))) || serviceCodes.contains(serviceCode)) continue;
            serviceCodes.add(serviceCode);
        }
        if (CollUtil.isNotEmpty(serviceCodes)) {
            PublishDataEntryAndModelDataParam param = new PublishDataEntryAndModelDataParam();
            param.setTenantId(AthenaUserLocal.getUser().getTenantId());
            param.setServiceCodes(serviceCodes);
            param.setCompareVersion(this.version);
            DeployTask deployTask = this.initDeployTask(deployParam);
            deployTask.setPublishParam((Object)param);
            return deployTask;
        }
        return null;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("ServiceVersionJudgeTask executing");
        PublishDataEntryAndModelDataParam param = (PublishDataEntryAndModelDataParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.backendApiHelper.judgeModelDrivenEvnVersion(param, task.getEnv());
        log.info("ServiceVersionJudgeTask end");
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.SERVICE_VERSION_JUDGE;
    }
}

