/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import com.digiwin.athena.athenadeployer.utils.StandardParamsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StandardParamsAuthTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardParamsAuthTask.class);
    @Autowired
    private StandardParamsUtil standardParamsUtil;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List standardList = parseCompileFileResult.getStandardParamsList();
        List triggerList = parseCompileFileResult.getTriggerList();
        HashSet productLine = new HashSet();
        this.standardParamsUtil.collectProductLines(triggerList, productLine);
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        if (StringUtils.equals((CharSequence)applicationData.getApplicationInfoDto().getAppSystem(), (CharSequence)"dataset")) {
            return null;
        }
        if (!CollectionUtils.isEmpty((Collection)standardList)) {
            ArrayList standardParams = new ArrayList();
            this.standardParamsUtil.buildPrdLineStandardParams(standardParams, productLine, applicationData.getApplication());
            if (!CollectionUtils.isEmpty(standardParams)) {
                DeployTask deployTask = this.initDeployTask(deployParam);
                AbstractDeployTaskNode.AuthParam authParam = this.standardStatementAuthParam(deployParam, standardParams, applicationData, this.getIamModuleId());
                List needAuthorizeSysTriggers = this.filterNeedAuthSysStatements(standardParams);
                authParam.setNeedAuthorizeSys(needAuthorizeSysTriggers);
                deployTask.compressSetPublishParam((Object)authParam);
                return deployTask;
            }
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        if (StringUtils.equals((CharSequence)applicationData.getApplicationInfoDto().getAppSystem(), (CharSequence)"dataset")) {
            return null;
        }
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List recordList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "needAuthorizeStandardParamsData", null);
        if (recordList.isEmpty()) {
            return null;
        }
        List applications = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "application", null);
        JSONObject appJson = ((DeployParamRecord)applications.get(0)).getValue();
        Boolean commonApp = appJson.getBoolean("commonApp");
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AbstractDeployTaskNode.AuthParam authParam = new AbstractDeployTaskNode.AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        List assignmentList = recordList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        authParam.setCommonApp(commonApp);
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(user.getTenantId()).setAssignmentList(assignmentList).setToken(user.getToken()).setApplication(applicationData.getApplication()).setEnv(deployParam.getEnv()).setAppJson(appJson);
        authParam.setGmcUpdateParam(gmcUpdateParam);
        deployTask.compressSetPublishParam((Object)authParam);
        return deployTask;
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.AGILE_DATA_APP_DATA_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.AGILE_DATA_APP_DATA_AUTH;
    }

    String getIamModuleId() {
        return "appData";
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("AppDataDeployAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.iamAssignmentAuthorize(task, authParam);
        this.iamAddPolicy(task, authParam);
        this.deployServiceV4.recordLatestDeployParam(task.getApplication(), authParam.getEnv(), task.getCompileDataCode(), "needAuthorizeStandardParamsData", authParam.getNeedAuthorizeSys());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("AppDataSwitchAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        GmcUpdateParam gmcUpdateParam = authParam.getGmcUpdateParam();
        this.backendApiHelper.updateGmcMoudle(gmcUpdateParam);
    }
}

