/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StartProjectAuthTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartProjectAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List startProjectList = parseCompileFileResult.getStartProjectList();
        if (!CollectionUtils.isEmpty((Collection)startProjectList)) {
            List needAuthorizeStartProjects = startProjectList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getString("authorityPrefix"))).collect(Collectors.toList());
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            Boolean commonApp = this.getCommonApp(parseCompileFileResult);
            DeployTask deployTask = this.initDeployTask(deployParam);
            AbstractDeployTaskNode.AuthParam authParam = commonApp != false ? this.commonAllStatementAuthParam(deployParam, startProjectList, needAuthorizeStartProjects, applicationData, parseCompileFileResult) : this.standardAllStatementAuthParam(deployParam, startProjectList, needAuthorizeStartProjects, applicationData, this.getIamModuleId());
            List jsonObjects = this.filterNeedAuthSysStatements(needAuthorizeStartProjects);
            jsonObjects.addAll(this.filterNoNeedAuthStatements(startProjectList, jsonObjects));
            authParam.setNeedAuthorizeSys(jsonObjects);
            deployTask.compressSetPublishParam((Object)authParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List startProjectList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "needAuthorizestartProjects", null);
        if (startProjectList.isEmpty()) {
            return null;
        }
        List applications = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "application", null);
        JSONObject appJson = ((DeployParamRecord)applications.get(0)).getValue();
        Boolean commonApp = appJson.getBoolean("commonApp");
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AbstractDeployTaskNode.AuthParam authParam = new AbstractDeployTaskNode.AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        List assignmentList = startProjectList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        authParam.setCommonApp(commonApp);
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(user.getTenantId()).setAssignmentList(assignmentList).setToken(user.getToken()).setApplication(applicationData.getApplication()).setEnv(deployParam.getEnv()).setAppJson(appJson);
        authParam.setGmcUpdateParam(gmcUpdateParam);
        deployTask.compressSetPublishParam((Object)authParam);
        return deployTask;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("StartProjectAuthTask executing");
        AbstractDeployTaskNode.AuthParam startProjectAuthParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (startProjectAuthParam.getCommonApp().booleanValue()) {
            this.commonIamAssignmentAuthorize(task, startProjectAuthParam);
            this.commonIamAddPolicy(task, startProjectAuthParam);
        } else {
            this.iamAssignmentAuthorize(task, startProjectAuthParam);
            this.iamAddPolicy(task, startProjectAuthParam);
        }
        this.deployServiceV4.recordLatestDeployParam(startProjectAuthParam.getApplication(), startProjectAuthParam.getEnv(), task.getCompileDataCode(), "needAuthorizestartProjects", startProjectAuthParam.getNeedAuthorizeSys());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("StartProjectAuthTask executing");
        AbstractDeployTaskNode.AuthParam authParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        GmcUpdateParam gmcUpdateParam = authParam.getGmcUpdateParam();
        if (authParam.getCommonApp().booleanValue()) {
            gmcUpdateParam.setVersion(EnvOperateEnum.SWITCH.getVersion());
            this.backendApiHelper.updateCommonGmcMoudle(gmcUpdateParam);
        } else {
            this.backendApiHelper.updateGmcMoudle(gmcUpdateParam);
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.START_PROJECT_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.START_PROJECT_AUTH;
    }

    String getIamModuleId() {
        return "startProject";
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return true;
    }
}

