/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.SyncKnowledgeTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import com.digiwin.athena.athenadeployer.utils.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SyncKnowledgeTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncKnowledgeTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        JSONObject application = this.getApplication(parseCompileFileResult);
        if (application.getInteger("appType") != null && 12 == application.getInteger("appType")) {
            List nounKnowledgeList = parseCompileFileResult.getNounKnowledgeList();
            List habitKnowledgeList = parseCompileFileResult.getHabitKnowledgeList();
            DeployTask deployTask = this.initDeployTask(deployParam);
            SyncKnowledgeParam syncKnowledgeParam = new SyncKnowledgeParam();
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            syncKnowledgeParam.setApplication(applicationData.getApplication());
            syncKnowledgeParam.setTenantUsers(deployParam.getTenantUsers());
            syncKnowledgeParam.setUser(AthenaUserLocal.getUser());
            syncKnowledgeParam.setEnv(deployParam.getEnv());
            syncKnowledgeParam.setNounKnowledgeList(nounKnowledgeList);
            syncKnowledgeParam.setHabitKnowledgeList(habitKnowledgeList);
            syncKnowledgeParam.setApplicationName(application.getString("name"));
            deployTask.compressSetPublishParam((Object)syncKnowledgeParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        String application = applicationData.getApplication();
        String envServiceId = deployParam.getEnvServiceId();
        Env env = this.getPublishEnv(application, envServiceId);
        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
        if (Objects.equals(applicationInfoDto.getAppType(), 12)) {
            log.info("SyncKnowledgeTask.createSwitchTask");
            List nounKnowledgeList = this.deployServiceV4.queryDeployParamRecords(application, env.getEnv(), "publishNounKnowledgeParamsData", null);
            List habitKnowledgeList = this.deployServiceV4.queryDeployParamRecords(application, env.getEnv(), "publishHabitKnowledgeParamsData", null);
            DeployTask deployTask = this.initSwitchTask(deployParam);
            SyncKnowledgeParam syncKnowledgeParam = new SyncKnowledgeParam();
            syncKnowledgeParam.setApplication(application);
            syncKnowledgeParam.setEnv(deployParam.getEnv());
            syncKnowledgeParam.setTenantUsers(deployParam.getTenantUsers());
            syncKnowledgeParam.setUser(AthenaUserLocal.getUser());
            syncKnowledgeParam.setApplicationName(applicationInfoDto.getName());
            if (!nounKnowledgeList.isEmpty()) {
                syncKnowledgeParam.setNounKnowledgeList(nounKnowledgeList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList()));
                syncKnowledgeParam.getNounKnowledgeList().forEach(e -> e.put("version", (Object)EnvOperateEnum.SWITCH.getVersion()));
            }
            if (!habitKnowledgeList.isEmpty()) {
                syncKnowledgeParam.setHabitKnowledgeList(habitKnowledgeList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList()));
                syncKnowledgeParam.getHabitKnowledgeList().forEach(e -> e.put("version", (Object)EnvOperateEnum.SWITCH.getVersion()));
            }
            deployTask.compressSetPublishParam((Object)syncKnowledgeParam);
            return deployTask;
        }
        return null;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("SyncKnowledgeTask deploy executing");
        SyncKnowledgeParam syncKnowledgeParam = (SyncKnowledgeParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.syncData(task, syncKnowledgeParam, EnvOperateEnum.PUBLISH.getVersion());
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return true;
    }

    public Boolean switchCustomCreateDeployDetailFlag() {
        return true;
    }

    private void syncData(DeployTask task, SyncKnowledgeParam syncKnowledgeParam, String version) {
        List habitKnowledgeList;
        String application = syncKnowledgeParam.getApplication();
        List tenantUsers = syncKnowledgeParam.getTenantUsers();
        AthenaUser user = syncKnowledgeParam.getUser();
        String env = syncKnowledgeParam.getEnv();
        String cn = "\u654f\u6377\u6570\u636e\u5e94\u7528\u6570\u636e\u540c\u6b65";
        String tw = "\u654f\u6377\u6578\u64da\u61c9\u7528\u6578\u64da\u540c\u6b65";
        String us = "Agile Data Application Sync";
        List nounKnowledgeList = syncKnowledgeParam.getNounKnowledgeList();
        if (!CollectionUtils.isEmpty((Collection)nounKnowledgeList)) {
            String contentLang = String.format("{\"content\":{\"en_US\":\"%s :Sync Noun Knowledge\",\"zh_CN\":\"%s :\u540d\u8bcd\u77e5\u8bc6\u540c\u6b65\u8bed\u4e49\",\"zh_TW\":\"%s :\u540d\u8a5e\u77e5\u8b58\u540c\u6b65\u8a9e\u7fa9\"}}", us, cn, tw);
            Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + "-\u540d\u8bcd\u77e5\u8bc6\u540c\u6b65\u8bed\u4e49", lang);
            try {
                this.backendApiHelper.pushNounKnowledge(application, env, tenantUsers, user.getTenantId(), version, nounKnowledgeList);
                deployDetailV2.setResult("success");
            }
            catch (Exception e) {
                String message = "\u8c03\u8bed\u4e49\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
                String errorMsg = e.toString();
                errorMsg = this.getErrorMessage(message, task, "pushNounKnowledge", LogUtils.AADC_500_0003, JSON.toJSONString((Object)nounKnowledgeList), errorMsg);
                deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(errorMsg);
                throw e;
            }
            finally {
                this.finishUpdateDetail(deployDetailV2);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(habitKnowledgeList = syncKnowledgeParam.getHabitKnowledgeList()))) {
            String contentLang = String.format("{\"content\":{\"en_US\":\"%s :Sync Habit Knowledge\",\"zh_CN\":\"%s :\u4e60\u60ef\u77e5\u8bc6\u540c\u6b65\u8bed\u4e49\",\"zh_TW\":\"%s :\u7fd2\u6163\u77e5\u8b58\u540c\u6b65\u8a9e\u7fa9\"}}", us, cn, tw);
            Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + "-\u4e60\u60ef\u77e5\u8bc6\u540c\u6b65\u8bed\u4e49", lang);
            try {
                this.backendApiHelper.pushHabitKnowledge(application, env, tenantUsers, user.getTenantId(), version, habitKnowledgeList);
                deployDetailV2.setResult("success");
            }
            catch (Exception e) {
                String message = "\u8c03\u8bed\u4e49\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
                String errorMsg = e.toString();
                errorMsg = this.getErrorMessage(message, task, "pushHabitKnowledge", LogUtils.AADC_500_0004, JSON.toJSONString((Object)habitKnowledgeList), errorMsg);
                deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(errorMsg);
                throw e;
            }
            finally {
                this.finishUpdateDetail(deployDetailV2);
            }
        }
        this.syncPushData(task, tenantUsers, user.getTenantId(), version, env, cn, tw, us);
        this.assistantPublish(application, env, task, cn, tw, us, user.getUserId(), version);
        if (EnvOperateEnum.PUBLISH.getVersion().equals(version)) {
            this.syncBackUri("12", env, task, cn, tw, us);
            this.deployServiceV4.recordLatestDeployParam(application, env, task.getCompileDataCode(), "publishNounKnowledgeParamsData", nounKnowledgeList);
            this.deployServiceV4.recordLatestDeployParam(application, env, task.getCompileDataCode(), "publishHabitKnowledgeParamsData", habitKnowledgeList);
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("SyncKnowledgeTask switch executing");
        SyncKnowledgeParam syncKnowledgeParam = (SyncKnowledgeParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.syncData(task, syncKnowledgeParam, EnvOperateEnum.SWITCH.getVersion());
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.SYNC_KNOWLEDGE;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.SYNC_KNOWLEDGE;
    }
}

