/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.SyncMobileDesignCodeTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SyncMobileDesignCodeTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncMobileDesignCodeTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        JSONObject mobileDslCodes = parseCompileFileResult.getMobileDslCodes();
        JSONObject application = this.getApplication(parseCompileFileResult);
        if (application.getInteger("appType") != null && (6 == application.getInteger("appType") || 12 == application.getInteger("appType"))) {
            return null;
        }
        DeployTask deployTask = this.initDeployTask(deployParam);
        MobileSyncInfoDto mobileSyncInfoDto = null;
        if (mobileDslCodes == null) {
            return null;
        }
        mobileSyncInfoDto = (MobileSyncInfoDto)JSONObject.parseObject((String)mobileDslCodes.toJSONString(), MobileSyncInfoDto.class);
        mobileSyncInfoDto.setOperate(EnvOperateEnum.PUBLISH.getOperate());
        mobileSyncInfoDto.setAppCode(application.getString("code"));
        mobileSyncInfoDto.setAppType(application.getInteger("appType"));
        deployTask.compressSetPublishParam((Object)mobileSyncInfoDto);
        return deployTask;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        DeployTask switchTask = this.initSwitchTask(deployParam);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        DeployLog deployLog = this.deployLogDao.findLastPublishLog("publish", env.getEnv(), applicationData.getApplication());
        log.info(String.format("\u67e5\u8be2\u5230\u7684logId:%s,env:%s", deployLog.getDeployNo(), env.getEnv()));
        DeployTask deployTask = this.deployTaskDao.selectByApplicationAndDeployNoAndType(applicationData.getApplication(), deployLog.getDeployNo(), this.getDeployType().getType());
        if (deployTask == null) {
            return null;
        }
        MobileSyncInfoDto publishParam = (MobileSyncInfoDto)deployTask.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        MobileSyncInfoDto mobileSyncInfoDto = new MobileSyncInfoDto();
        mobileSyncInfoDto.setOperate(EnvOperateEnum.SWITCH.getOperate());
        mobileSyncInfoDto.setAppCode(publishParam.getAppCode());
        mobileSyncInfoDto.setAppType(publishParam.getAppType());
        switchTask.compressSetPublishParam((Object)mobileSyncInfoDto);
        return switchTask;
    }

    public String deployDetailLevel() {
        return "warn";
    }

    protected void doDeployExecute(DeployTask task) {
        MobileSyncInfoDto publishParam = (MobileSyncInfoDto)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.deployServiceApiHelper.mobilePublish(task.getEnv(), publishParam);
    }

    protected void doSwitchExecute(DeployTask task) {
        MobileSyncInfoDto publishParam = (MobileSyncInfoDto)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.deployServiceApiHelper.mobilePublish(task.getEnv(), publishParam);
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.SYNC_MOBILE_DESIGN_CODE;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.SYNC_MOBILE_DESIGN_CODE;
    }
}

