/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.http.BmdApiHelper;
import com.digiwin.athena.athenadeployer.service.EnvService;
import com.digiwin.athena.athenadeployer.service.ReleasePipeLineService;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.SyncModelCentralTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import com.digiwin.athena.athenadeployer.utils.BmdEnvMapUtil;
import com.digiwin.athena.athenadeployer.utils.LogUtils;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SyncModelCentralTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncModelCentralTask.class);
    @Resource
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private BmdApiHelper bmdApiHelper;
    @Autowired
    private ReleasePipeLineService releasePipeLineService;
    @Autowired
    private EnvService envService;
    @Autowired
    private BmdEnvMapUtil bmdEnvMapUtil;

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        JSONObject application = this.getApplication(parseCompileFileResult);
        if (application.getInteger("appType") != null && 6 == application.getInteger("appType")) {
            List publishEnvs = this.envService.queryEnvsWithoutAuth("publish");
            String envCode = this.bmdEnvMapUtil.getBmdEnv(publishEnvs, deployParam.getEnv());
            List synonymList = parseCompileFileResult.getSynonymList();
            List standardParamsList = parseCompileFileResult.getStandardParamsList();
            DeployTask deployTask = this.initDeployTask(deployParam);
            SyncModelCentralParam syncModelCentralParam = new SyncModelCentralParam();
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            syncModelCentralParam.setApplication(applicationData.getApplication());
            syncModelCentralParam.setEnv(deployParam.getEnv());
            syncModelCentralParam.setEnvCode(envCode);
            syncModelCentralParam.setTenantUsers(deployParam.getTenantUsers());
            syncModelCentralParam.setUser(AthenaUserLocal.getUser());
            syncModelCentralParam.setSource(application.getString("source"));
            syncModelCentralParam.setStandardParamsList(standardParamsList);
            syncModelCentralParam.setSynonymList(synonymList);
            syncModelCentralParam.setApplicationName(application.getString("name"));
            if (Objects.nonNull(applicationData.getApplicationInfoDto())) {
                syncModelCentralParam.setAppSystem(applicationData.getApplicationInfoDto().getAppSystem());
            }
            deployTask.compressSetPublishParam((Object)syncModelCentralParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        String envServiceId;
        Env env;
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        String application = applicationData.getApplication();
        List applications = this.deployServiceV4.queryDeployParamRecords(application, (env = this.getPublishEnv(application, envServiceId = deployParam.getEnvServiceId())).getEnv(), "application", null);
        JSONObject appJson = ((DeployParamRecord)applications.get(0)).getValue();
        if (appJson.getInteger("appType") != null && 6 == appJson.getInteger("appType")) {
            List switchEnvs = this.envService.queryEnvsWithoutAuth("switch");
            String envCode = this.bmdEnvMapUtil.getBmdEnv(switchEnvs, deployParam.getEnv());
            List synonymList = this.deployServiceV4.queryDeployParamRecords(application, env.getEnv(), "publishSynonymData", null);
            List standardParamsList = this.deployServiceV4.queryDeployParamRecords(application, env.getEnv(), "publishStandardParamsData", null);
            if (synonymList.isEmpty() && standardParamsList.isEmpty()) {
                return null;
            }
            DeployTask deployTask = this.initSwitchTask(deployParam);
            SyncModelCentralParam syncModelCentralParam = new SyncModelCentralParam();
            syncModelCentralParam.setApplication(application);
            syncModelCentralParam.setEnv(deployParam.getEnv());
            syncModelCentralParam.setEnvCode(envCode);
            syncModelCentralParam.setSource(appJson.getString("source"));
            syncModelCentralParam.setTenantUsers(deployParam.getTenantUsers());
            syncModelCentralParam.setUser(AthenaUserLocal.getUser());
            syncModelCentralParam.setApplicationName(appJson.getString("name"));
            if (Objects.nonNull(applicationData.getApplicationInfoDto())) {
                syncModelCentralParam.setAppSystem(applicationData.getApplicationInfoDto().getAppSystem());
            }
            if (!synonymList.isEmpty()) {
                syncModelCentralParam.setSynonymList(synonymList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList()));
            }
            if (!standardParamsList.isEmpty()) {
                syncModelCentralParam.setStandardParamsList(standardParamsList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList()));
            }
            deployTask.compressSetPublishParam((Object)syncModelCentralParam);
            return deployTask;
        }
        return null;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("SyncModelCentralTask executing");
        SyncModelCentralParam syncModelCentralParam = (SyncModelCentralParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.syncData(task, syncModelCentralParam, EnvOperateEnum.PUBLISH.getVersion());
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return true;
    }

    public Boolean switchCustomCreateDeployDetailFlag() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncData(DeployTask task, SyncModelCentralParam syncModelCentralParam, String version) {
        String errorMsg;
        String message;
        DeployDetailV2 deployDetailV2;
        List synonymList;
        String application = syncModelCentralParam.getApplication();
        String env = syncModelCentralParam.getEnv();
        String envCode = syncModelCentralParam.getEnvCode();
        List tenantUsers = syncModelCentralParam.getTenantUsers();
        AthenaUser user = syncModelCentralParam.getUser();
        String appSystem = syncModelCentralParam.getAppSystem();
        String cn = "\u654f\u6377\u6570\u636e\u5e94\u7528\u6570\u636e\u540c\u6b65";
        String tw = "\u654f\u6377\u6578\u64da\u61c9\u7528\u6578\u64da\u540c\u6b65";
        String us = "Agile Data Application Sync";
        List standardParamsList = syncModelCentralParam.getStandardParamsList();
        if (!CollectionUtils.isEmpty((Collection)standardParamsList)) {
            String contentLang = String.format("{\"content\":{\"en_US\":\"%s :Sync Standard Param\",\"zh_CN\":\"%s :\u6807\u51c6\u53c2\u6570\u540c\u6b65\u8bed\u4e49\",\"zh_TW\":\"%s :\u6a19\u6e96\u53c3\u6578\u540c\u6b65\u8a9e\u7fa9\"}}", us, cn, tw);
            Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            DeployDetailV2 deployDetailV22 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + "-\u6807\u51c6\u53c2\u6570\u540c\u6b65\u8bed\u4e49", lang);
            try {
                this.backendApiHelper.pushStandardParams(application, env, tenantUsers, user.getTenantId(), version, standardParamsList);
                deployDetailV22.setResult("success");
            }
            catch (Exception e) {
                String message2 = "\u8c03\u8bed\u4e49\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
                String errorMsg2 = e.toString();
                errorMsg2 = this.getErrorMessage(message2, task, "pushStandardParams", LogUtils.AADC_500_0003, JSON.toJSONString((Object)standardParamsList), errorMsg2);
                deployDetailV22.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(errorMsg2);
            }
            finally {
                this.finishUpdateDetail(deployDetailV22);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(synonymList = syncModelCentralParam.getSynonymList()))) {
            String contentLang = String.format("{\"content\":{\"en_US\":\"%s :Sync Synonym\",\"zh_CN\":\"%s :\u540c\u4e49\u8bcd\u540c\u6b65\u8bed\u4e49\",\"zh_TW\":\"%s :\u540c\u7fa9\u8a5e\u540c\u6b65\u8a9e\u7fa9\"}}", us, cn, tw);
            Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + "-\u540c\u4e49\u8bcd\u540c\u6b65\u8bed\u4e49", lang);
            try {
                this.backendApiHelper.pushSynonym(application, env, tenantUsers, user.getTenantId(), version, synonymList);
                deployDetailV2.setResult("success");
            }
            catch (Exception e) {
                message = "\u8c03\u8bed\u4e49\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
                errorMsg = e.toString();
                errorMsg = this.getErrorMessage(message, task, "pushSynonym", LogUtils.AADC_500_0004, JSON.toJSONString((Object)synonymList), errorMsg);
                deployDetailV2.setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(errorMsg);
            }
            finally {
                this.finishUpdateDetail(deployDetailV2);
            }
            String v3ContentLang = String.format("{\"content\":{\"en_US\":\"%s :Sync Synonym To AI\",\"zh_CN\":\"%s :\u540c\u4e49\u8bcd\u540c\u6b65AI\",\"zh_TW\":\"%s :\u540c\u7fa9\u8a5e\u540c\u6b65AI\"}}", us, cn, tw);
            Map v3Lang = (Map)JSONObject.parseObject((String)v3ContentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            DeployDetailV2 deployDetailV3 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + "-\u540c\u4e49\u8bcd\u540c\u6b65AI", v3Lang);
            try {
                this.backendApiHelper.pushSynonymToAI(application, env, tenantUsers, user.getTenantId(), version, synonymList);
                deployDetailV3.setResult("success");
            }
            catch (Exception e) {
                String message3 = "\u8c03AI\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
                String errorMsg3 = e.toString();
                errorMsg3 = this.getErrorMessage(message3, task, "pushSynonymToAI", LogUtils.AADC_500_0005, JSON.toJSONString((Object)synonymList), errorMsg3);
                deployDetailV3.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(errorMsg3);
            }
            finally {
                this.finishUpdateDetail(deployDetailV3);
            }
        }
        String bmdContentLang = String.format("{\"content\":{\"en_US\":\"%s :Model Launch\",\"zh_CN\":\"%s :\u901a\u77e5\u6a21\u578b\u4e2d\u5fc3\u53d1\u5e03\u6a21\u578b\",\"zh_TW\":\"%s :\u901a\u77e5\u6a21\u578b\u4e2d\u5fc3\u767c\u4f48\u6a21\u578b\"}}", us, cn, tw);
        Map bmdLang = (Map)JSONObject.parseObject((String)bmdContentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent() + "-\u901a\u77e5\u6a21\u578b\u4e2d\u5fc3\u53d1\u5e03\u6a21\u578b", bmdLang);
        try {
            this.bmdApiHelper.modelRelease(application, envCode, tenantUsers, user.getToken(), version, syncModelCentralParam);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            message = "\u8c03BMD\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
            errorMsg = e.toString();
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("appId", task.getApplication());
            body.put("envCode", envCode);
            body.put("tenantsidList", tenantUsers);
            body.put("type", EnvOperateEnum.PUBLISH.getVersion());
            body.put("source", syncModelCentralParam.getSource());
            body.put("appName", syncModelCentralParam.getApplicationName());
            errorMsg = this.getErrorMessage(message, task, "modelRelease", LogUtils.AADC_500_0006, JSON.toJSONString(body), errorMsg);
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(errorMsg);
        }
        finally {
            this.finishUpdateDetail(deployDetailV2);
        }
        this.syncPushData(task, tenantUsers, user.getTenantId(), version, env, cn, tw, us);
        if (StringUtils.equals((CharSequence)appSystem, (CharSequence)"dataset")) {
            this.assistantPublish(application, env, task, cn, tw, us, user.getUserId(), version);
        }
        if (EnvOperateEnum.PUBLISH.getVersion().equals(version)) {
            this.syncBackUri("6", env, task, cn, tw, us);
            this.deployServiceV4.recordLatestDeployParam(application, env, task.getCompileDataCode(), "publishSynonymData", synonymList);
            this.deployServiceV4.recordLatestDeployParam(application, env, task.getCompileDataCode(), "publishStandardParamsData", standardParamsList);
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("SyncModelCentralTask executing");
        SyncModelCentralParam syncModelCentralParam = (SyncModelCentralParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.syncData(task, syncModelCentralParam, EnvOperateEnum.SWITCH.getVersion());
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.SYNC_MODEL_CENTRAL;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.SYNC_MODEL_CENTRAL;
    }
}

