/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TbbReportAuthTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbbReportAuthTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List tbbStatementList;
        List statementList = parseCompileFileResult.getStatementList();
        if (CollUtil.isNotEmpty((Collection)statementList) && CollUtil.isNotEmpty(tbbStatementList = statementList.stream().filter(t -> this.isTbbStatement(t.getString("pattern"), t.getString("category"))).collect(Collectors.toList()))) {
            List activityConfigList = parseCompileFileResult.getActivityConfigList();
            if (CollUtil.isEmpty((Collection)activityConfigList)) {
                return null;
            }
            List needAuthorizeTbbStatements = this.deployServiceV4.filterNeedAuthStatements(activityConfigList, tbbStatementList);
            DeployTask deployTask = this.initDeployTask(deployParam);
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            Boolean commonApp = this.getCommonApp(parseCompileFileResult);
            AbstractDeployTaskNode.AuthParam authParam = commonApp != false ? this.commonAllStatementAuthParam(deployParam, tbbStatementList, needAuthorizeTbbStatements, applicationData, parseCompileFileResult) : this.standardAllStatementAuthParam(deployParam, tbbStatementList, needAuthorizeTbbStatements, applicationData, this.getIamModuleId());
            List jsonObjects = this.filterNeedAuthSysStatements(needAuthorizeTbbStatements);
            jsonObjects.addAll(this.filterNoNeedAuthStatements(tbbStatementList, jsonObjects));
            authParam.setNeedAuthorizeSys(jsonObjects);
            deployTask.compressSetPublishParam((Object)authParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env env = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List tbbRecordList = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "needAuthorizeTbbStatements", null);
        if (tbbRecordList.isEmpty()) {
            return null;
        }
        List applications = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), env.getEnv(), "application", null);
        JSONObject appJson = ((DeployParamRecord)applications.get(0)).getValue();
        Boolean commonApp = appJson.getBoolean("commonApp");
        DeployTask deployTask = this.initSwitchTask(deployParam);
        AbstractDeployTaskNode.AuthParam authParam = new AbstractDeployTaskNode.AuthParam();
        AthenaUser user = AthenaUserLocal.getUser();
        List assignmentList = tbbRecordList.stream().map(DeployParamRecord::getValue).collect(Collectors.toList());
        authParam.setCommonApp(commonApp);
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam().setTenantId(user.getTenantId()).setAssignmentList(assignmentList).setToken(user.getToken()).setApplication(applicationData.getApplication()).setEnv(deployParam.getEnv()).setAppJson(appJson);
        authParam.setGmcUpdateParam(gmcUpdateParam);
        deployTask.compressSetPublishParam((Object)authParam);
        return deployTask;
    }

    protected void doDeployExecute(DeployTask task) {
        log.info("TbbReportAuthTask executing");
        AbstractDeployTaskNode.AuthParam tbbReportAuthParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (tbbReportAuthParam.getCommonApp().booleanValue()) {
            this.commonIamAssignmentAuthorize(task, tbbReportAuthParam);
            this.commonIamAddPolicy(task, tbbReportAuthParam);
        } else {
            this.iamAssignmentAuthorize(task, tbbReportAuthParam);
            this.iamAddPolicy(task, tbbReportAuthParam);
        }
        this.deployServiceV4.recordLatestDeployParam(task.getApplication(), tbbReportAuthParam.getEnv(), task.getCompileDataCode(), "needAuthorizeTbbStatements", tbbReportAuthParam.getNeedAuthorizeSys());
    }

    protected void doSwitchExecute(DeployTask task) {
        log.info("TbbReportAuthTask executing");
        AbstractDeployTaskNode.AuthParam tbbReportAuthParam = (AbstractDeployTaskNode.AuthParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        GmcUpdateParam gmcUpdateParam = tbbReportAuthParam.getGmcUpdateParam();
        if (tbbReportAuthParam.getCommonApp().booleanValue()) {
            gmcUpdateParam.setVersion(EnvOperateEnum.SWITCH.getVersion());
            this.backendApiHelper.updateCommonGmcMoudle(gmcUpdateParam);
        } else {
            this.backendApiHelper.updateGmcMoudle(gmcUpdateParam);
        }
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.TBB_REPORT_AUTH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.TBB_REPORT_AUTH;
    }

    String getIamModuleId() {
        return "report";
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return true;
    }
}

