/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.deployTask;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.service.DeployServiceV4;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.TbbReportPublishTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TbbReportPublishTask
extends AbstractDeployTaskNode<DeployTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbbReportPublishTask.class);

    DeployTask createDeployTask(DeployParamV3 deployParam, ParseCompileFileResult parseCompileFileResult) {
        List tbbStatementList;
        List statementList = parseCompileFileResult.getStatementList();
        if (CollUtil.isNotEmpty((Collection)statementList) && CollUtil.isNotEmpty(tbbStatementList = statementList.stream().filter(t -> this.isTbbStatement(t.getString("pattern"), t.getString("category"))).collect(Collectors.toList()))) {
            ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
            DeployTask deployTask = this.initDeployTask(deployParam);
            List statements = tbbStatementList.stream().map(o -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("resCode", o.get((Object)"resCode"));
                jsonObject.put("code", o.get((Object)"code"));
                jsonObject.put("tenantId", o.get((Object)"tenantId"));
                return jsonObject;
            }).collect(Collectors.toList());
            TbbReportPublishParam tbbReportPublishParam = new TbbReportPublishParam();
            tbbReportPublishParam.setEnv(deployParam.getEnv());
            tbbReportPublishParam.setApplication(applicationData.getApplication());
            tbbReportPublishParam.setUser(AthenaUserLocal.getUser());
            tbbReportPublishParam.setTbbStatementList(statements);
            tbbReportPublishParam.setTenantUsers(deployParam.getTenantUsers());
            tbbReportPublishParam.setBranch(parseCompileFileResult.getBranch());
            deployTask.compressSetPublishParam((Object)tbbReportPublishParam);
            return deployTask;
        }
        return null;
    }

    DeployTask createSwitchTask(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Env publishEnv = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
        List tbbRecord = this.deployServiceV4.queryDeployParamRecords(applicationData.getApplication(), publishEnv.getEnv(), "tbb", null);
        if (tbbRecord.isEmpty()) {
            return null;
        }
        List code = tbbRecord.stream().map(r -> {
            JSONObject value = r.getValue();
            if (value.containsKey((Object)"resCode") && StringUtils.isNotBlank((CharSequence)value.getString("resCode"))) {
                return value.getString("resCode");
            }
            return value.getString("code");
        }).collect(Collectors.toList());
        List tenantUsers = deployParam.getTenantUsers();
        DeployTask deployTask = this.initSwitchTask(deployParam);
        TbbReportSwitchParam tbbReportSwitchParam = new TbbReportSwitchParam();
        tbbReportSwitchParam.setUser(AthenaUserLocal.getUser());
        tbbReportSwitchParam.setAppCode(applicationData.getApplication());
        tbbReportSwitchParam.setEnv(deployParam.getEnv());
        tbbReportSwitchParam.setReportList(code);
        tbbReportSwitchParam.setTenantIdList(tenantUsers.stream().map(TenantUser::getTenantId).collect(Collectors.toList()));
        deployTask.compressSetPublishParam((Object)tbbReportSwitchParam);
        return deployTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeployExecute(DeployTask task) {
        log.info("TbbReportPublishTask executing");
        DeployDetailV2 deployDetailV2 = this.createStartDeployDetail(task.getType(), task.getDeployNo(), task.getApplication(), this.getDeployType().getContent(), this.getDeployType().getLang());
        TbbReportPublishParam tbbReportPublishParam = (TbbReportPublishParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        String application = tbbReportPublishParam.getApplication();
        String env = tbbReportPublishParam.getEnv();
        String token = tbbReportPublishParam.getUser().getToken();
        String branch = tbbReportPublishParam.getBranch();
        List tenantIdList = tbbReportPublishParam.getTenantUsers().stream().map(TenantUser::getTenantId).collect(Collectors.toList());
        List tbbStatementList = tbbReportPublishParam.getTbbStatementList();
        this.deployServiceV4.recordLatestDeployParam(application, env, task.getCompileDataCode(), "tbb", tbbStatementList);
        try {
            List sysTbbStatementList = tbbStatementList.stream().filter(data -> !this.deployServiceV4.isUcOrNot(data)).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(sysTbbStatementList)) {
                ArrayList<String> resCodes = new ArrayList<String>();
                for (JSONObject tbbStatement : sysTbbStatementList) {
                    String resCode = tbbStatement.getString("resCode");
                    if (StringUtils.isEmpty((CharSequence)resCode)) {
                        resCode = tbbStatement.getString("code");
                    }
                    resCodes.add(resCode);
                }
                JSONObject param = new JSONObject();
                param.put("token", (Object)token);
                param.put("appCode", (Object)application);
                param.put("env", (Object)env);
                param.put("tenantIds", tenantIdList);
                param.put("reportList", resCodes);
                param.put("operate", (Object)"publish");
                this.backendApiHelper.tbbStatementPublish(param, branch, token);
            }
            List ucTbbStatementList = tbbStatementList.stream().filter(arg_0 -> ((DeployServiceV4)this.deployServiceV4).isUcOrNot(arg_0)).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(ucTbbStatementList)) {
                for (JSONObject ucTbbStatement : ucTbbStatementList) {
                    JSONObject param = new JSONObject();
                    param.put("token", (Object)token);
                    param.put("appCode", (Object)application);
                    param.put("env", (Object)env);
                    param.put("operate", (Object)"publish");
                    String resCode = ucTbbStatement.getString("resCode");
                    if (StringUtils.isEmpty((CharSequence)resCode)) {
                        resCode = ucTbbStatement.getString("code");
                    }
                    param.put("reportList", Collections.singletonList(resCode));
                    param.put("tenantIds", (Object)ucTbbStatement.getString("tenantId").split(";"));
                    this.backendApiHelper.tbbStatementPublish(param, branch, token);
                }
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString());
        }
        finally {
            this.finishUpdateDetail(deployDetailV2);
        }
    }

    protected void doSwitchExecute(DeployTask task) {
        TbbReportSwitchParam tbbReportSwitchParam = (TbbReportSwitchParam)task.decompressGetPublishParam((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        JSONObject param = new JSONObject();
        param.put("token", (Object)tbbReportSwitchParam.getUser().getToken());
        param.put("tenantIdList", (Object)tbbReportSwitchParam.getTenantIdList());
        param.put("appCode", (Object)tbbReportSwitchParam.getAppCode());
        param.put("env", (Object)tbbReportSwitchParam.getEnv());
        param.put("reportList", (Object)tbbReportSwitchParam.getReportList());
        param.put("operate", (Object)"switch");
        DeployLog deployLog = this.deployLogDao.findLastPublishLog("publish", tbbReportSwitchParam.getEnv(), task.getApplication());
        String branch = "develop";
        if (deployLog != null) {
            branch = deployLog.getCompileData().getString("branch");
        }
        this.backendApiHelper.tbbStatementPublish(param, branch, AthenaUserLocal.getUser().getToken());
    }

    DeployTaskTypeEnum getDeployType() {
        return DeployTaskTypeEnum.TBB_REPORT_PUBLISH;
    }

    SwitchTaskTypeEnum getSwitchType() {
        return SwitchTaskTypeEnum.TBB_REPORT_SWITCH;
    }

    public Boolean deployCustomCreateDeployDetailFlag() {
        return true;
    }

    public String deployDetailLevel() {
        return "warn";
    }
}

