/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.ModuleConfig;
import com.digiwin.athena.athenadeployer.domain.ApplicationPO;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.application.ApplicationLatestVersion;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.compile.CompileVersion;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.service.ApplicationService;
import com.digiwin.athena.athenadeployer.service.CompileService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;

@Service
public class ApplicationServiceImpl
implements ApplicationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private CompileService compileService;
    @Autowired
    private ModuleConfig moduleConfig;
    @Value(value="${cdc.appToken}")
    private String cdcAppToken;
    @Value(value="${designer.domain}")
    private String designerDomain;
    @Autowired
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;

    public List<JSONObject> getApplications(String condition) {
        List applications = this.getAllApplications(condition);
        List applicationCodeList = applications.stream().map(item -> item.getString("code")).collect(Collectors.toList());
        List compiledDataList = this.designerApiHelper.queryCompiledDataByApplications(applicationCodeList, AthenaUserLocal.getUser().getToken());
        for (JSONObject application : applications) {
            JSONArray compiledDataListInApplication = new JSONArray();
            for (JSONObject compiledData : compiledDataList) {
                if (!compiledData.getString("application").equals(application.getString("code"))) continue;
                compiledDataListInApplication.add((Object)compiledData);
            }
            application.put("compiledDataList", (Object)compiledDataListInApplication);
        }
        return applications;
    }

    public void compare(List<String> applicationList) {
        for (String application : applicationList) {
            CompileVersion compileVersion = this.compileService.queryLatestVersion(application);
        }
    }

    public ApplicationPO getApplicationBycode(String applicationCode) {
        return this.designerApiHelper.getApplicationByCode(applicationCode, AthenaUserLocal.getUser().getToken());
    }

    public List<ApplicationLatestVersion> queryApplicationLatestVersion(List<String> applicationCodeList) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"application").in(applicationCodeList).and("result").is((Object)"success")), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"}), Aggregation.group((String[])new String[]{"application", "version", "deployParam.env"}).first("compileData.version").as("latestCompileVersion"), Aggregation.project((String[])new String[]{"application", "version", "env", "latestCompileVersion"}).andExclude(new String[]{"_id"})});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "deployLog", ApplicationLatestVersion.class);
        return results.getMappedResults();
    }

    private List<String> getAuthorizedApplications() {
        AthenaUser user = AthenaUserLocal.getUser();
        ModuleConfig.Module cac = this.moduleConfig.getCac();
        String domain = cac.getDomain();
        Object apiUrl = domain + "/api/cac/v4/authorizations/currentTenant/users/{}/enabled";
        apiUrl = StrUtil.format((CharSequence)apiUrl, (Object[])new Object[]{user.getUserId()});
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", user.getToken());
        headers.put("digi-middleware-auth-app", this.cdcAppToken);
        String response = ((HttpRequest)HttpUtil.createGet((String)apiUrl).addHeaders(headers)).execute().body();
        List applicationCodes = JSON.parseArray((String)response).toJavaList(String.class);
        return applicationCodes;
    }

    private List<JSONObject> getAllApplications(String condition) {
        String applicationApiUrl = this.designerDomain + "/athena-designer/application/get?condition=&pageNum=1&pageSize=9999";
        if (StrUtil.isNotBlank((CharSequence)condition)) {
            applicationApiUrl = applicationApiUrl + condition;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", AthenaUserLocal.getUser().getToken());
        String res = ((HttpRequest)HttpUtil.createGet((String)applicationApiUrl).addHeaders(headers)).execute().body();
        JSONObject jsonObject = JSON.parseObject((String)res);
        try {
            List applications = jsonObject.getJSONObject("data").getJSONArray("data").toJavaList(JSONObject.class);
            return applications;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5e94\u7528\u5931\u8d25,", (Throwable)e);
            throw new BusinessException(res);
        }
    }
}

