/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.neo4j.HttpNeo4j2Config;
import com.digiwin.athena.athenadeployer.config.neo4j.HttpNeo4jConfig;
import com.digiwin.athena.athenadeployer.config.neo4j.Neo4j1Manager;
import com.digiwin.athena.athenadeployer.config.neo4j.Neo4j2Manager;
import com.digiwin.athena.athenadeployer.config.neo4j.Neo4jManager;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.Application;
import com.digiwin.athena.athenadeployer.domain.MyDesignerData;
import com.digiwin.athena.athenadeployer.domain.MyDocument;
import com.digiwin.athena.athenadeployer.domain.MyStatement;
import com.digiwin.athena.athenadeployer.domain.TagDetailDO;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.service.AthenaDataService;
import com.digiwin.athena.athenadeployer.service.CompareService;
import com.digiwin.athena.athenadeployer.service.DeployerProgressService;
import com.digiwin.athena.athenadeployer.service.ESPService;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import com.digiwin.athena.athenadeployer.utils.SafeFileUtils;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.types.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class AthenaDataServiceImpl
implements AthenaDataService {
    @Generated
    private static final Logger log = LogManager.getLogger(AthenaDataServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DeployerProgressService deployerProgressService;
    @Autowired
    private ESPService espService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private HttpNeo4jConfig httpNeo4jConfig;
    @Autowired(required=false)
    private HttpNeo4j2Config httpNeo4j2Config;
    @Autowired
    private CompareService compareService;
    @Value(value="${environment}")
    private String environment;

    public void deleteTempAthenaData() {
        FileUtils.clearFolder((String)Constant.ATHENA_DATA_PATH);
    }

    public void publishAthenaData(String application, String version) {
        this.executeNeo4jData(application, version);
        this.executeMongoData(application, version);
    }

    private void executeNeo4jData(String application, String version) {
        File[] labelsFile;
        HashMap relationTableMap = new HashMap();
        JSONObject neo4jNodeKeyJson = (JSONObject)FileUtils.readObjectFromFilePath((String)"neo4jNodeKey.json", JSONObject.class);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("application", application);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node{athena_namespace:$application}) where not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) and (node.tenantId=\"SYSTEM\" or node.tenantId is null) detach delete node", param);
        File applicationFile = SafeFileUtils.createFile((String)(FileUtils.gitFilePath + "athenaData/" + application + "/neo4j"));
        for (File labelFile : labelsFile = applicationFile.listFiles()) {
            File[] subLabelsOrNodesFile;
            String labelName = labelFile.getName();
            String labelPK = neo4jNodeKeyJson.getString(labelName);
            if (StringUtils.isEmpty((Object)labelPK)) {
                throw new BusinessException("P^((?!(\\*|//)).)+[\\u4e00-\\u9fa5]" + labelName);
            }
            for (File subLabelOrNodeFile : subLabelsOrNodesFile = labelFile.listFiles()) {
                this.executeNode(subLabelOrNodeFile, application, version, labelPK, relationTableMap);
            }
        }
        this.executeNodeRelationTable(neo4jNodeKeyJson, relationTableMap);
        log.info("Neo4j OK");
    }

    private void findApplicationToCommonRelations(List<String> applicationList, JSONObject neo4jNodeKeyJson, Map<JSONObject, JSONArray> relationTableMap) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("applicationList", applicationList);
        List maps = Neo4jManager.getNeo4jManager().ExecuteQuery("match (applicationNode)-[relation]->(commonNode{application:'COMMON'}) where not applicationNode.application in $applicationList return labels(applicationNode) as applicationNodeLabels,applicationNode,type(relation) as relationType,labels(commonNode) as commonNodeLabels,commonNode", param);
        JSONArray nodeToNodes = (JSONArray)JSON.toJSON((Object)maps);
        nodeToNodes.forEach(nodeToNode -> {
            JSONObject nodeKey = new JSONObject();
            nodeKey.put("label", ((JSONObject)nodeToNode).getJSONArray("applicationNodeLabels").get(0));
            nodeKey.put("labelPK", ((JSONObject)nodeToNode).getJSONObject("applicationNode").get((Object)neo4jNodeKeyJson.getString(((JSONObject)nodeToNode).getJSONArray("applicationNodeLabels").getString(0))));
            nodeKey.put("application", ((JSONObject)nodeToNode).getJSONObject("applicationNode").get((Object)"application"));
            JSONArray relationTables = new JSONArray();
            JSONObject relationTable = new JSONObject();
            relationTable.put("type", ((JSONObject)nodeToNode).get((Object)"relationType"));
            relationTable.put("targetLabel", ((JSONObject)nodeToNode).getJSONArray("commonNodeLabels").get(0));
            relationTable.put("targetId", ((JSONObject)nodeToNode).getJSONObject("commonNode").get((Object)neo4jNodeKeyJson.getString(((JSONObject)nodeToNode).getJSONArray("commonNodeLabels").getString(0))));
            relationTables.add((Object)relationTable);
            relationTableMap.put(nodeKey, relationTables);
        });
    }

    private void executeNodeRelationTable(JSONObject neo4jNodeKeyJson, Map<JSONObject, JSONArray> relationTableMap) {
        for (Map.Entry<JSONObject, JSONArray> entry : relationTableMap.entrySet()) {
            JSONObject fromNodeJson = entry.getKey();
            JSONArray toNodesJson = entry.getValue();
            toNodesJson.forEach(toNodeJson -> {
                StringBuffer relationCypher = new StringBuffer(String.format("match (fromNode:%s) where fromNode.%s=", fromNodeJson.get((Object)"label"), neo4jNodeKeyJson.getString(fromNodeJson.getString("label"))));
                if (fromNodeJson.get((Object)"labelPK") instanceof String) {
                    relationCypher.append(String.format("'%s'", fromNodeJson.get((Object)"labelPK")));
                } else {
                    relationCypher.append(String.format("%s", fromNodeJson.get((Object)"labelPK")));
                }
                relationCypher.append(String.format(" and fromNode.athena_namespace='%s' and fromNode.version='%s' match(toNode:%s) where toNode.%s=", fromNodeJson.get((Object)"application"), fromNodeJson.get((Object)"version"), ((JSONObject)toNodeJson).get((Object)"targetLabel"), neo4jNodeKeyJson.getString(((JSONObject)toNodeJson).getString("targetLabel"))));
                if (((JSONObject)toNodeJson).get((Object)"targetId") instanceof String) {
                    relationCypher.append(String.format("'%s'", ((JSONObject)toNodeJson).get((Object)"targetId")));
                } else {
                    relationCypher.append(String.format("%s", ((JSONObject)toNodeJson).get((Object)"targetId")));
                }
                relationCypher.append(String.format(" and toNode.version='%s' merge (fromNode)-[:%s]->(toNode)", fromNodeJson.get((Object)"version"), ((JSONObject)toNodeJson).get((Object)"type")));
                Neo4jManager.getNeo4jManager().ExecuteNoQuery(relationCypher.toString());
            });
        }
    }

    private void executeNode(File nodeFile, String application, String version, String labelPK, Map<JSONObject, JSONArray> relationTableMap) {
        JSONObject nodeJson = (JSONObject)FileUtils.readObjectFromFilePath2((String)nodeFile.getPath(), JSONObject.class);
        JSONArray labels = nodeJson.getJSONArray("labels");
        JSONArray relationTables = nodeJson.getJSONArray("relationTable");
        StringBuffer nodeCypher = new StringBuffer("create (node");
        labels.forEach(label -> nodeCypher.append(String.format(":%s", label)));
        nodeCypher.append("{");
        Set nodeProperties = nodeJson.entrySet();
        nodeProperties.stream().filter(nodeProperty -> !"application".equals(nodeProperty.getKey()) && !"version".equals(nodeProperty.getKey()) && !"nameSpace".equals(nodeProperty.getKey()) && !"labels".equals(nodeProperty.getKey()) && !"relationTable".equals(nodeProperty.getKey())).forEach(nodeProperty -> {
            if (((String)nodeProperty.getKey()).equals("lang")) {
                JSONObject lang = (JSONObject)nodeProperty.getValue();
                Set langProperties = lang.entrySet();
                langProperties.forEach(langProperty -> {
                    String langKey = (String)langProperty.getKey();
                    JSONObject langValue = (JSONObject)langProperty.getValue();
                    Set langValueProperties = langValue.entrySet();
                    langValueProperties.forEach(langValueProperty -> {
                        String langValueKey = (String)langValueProperty.getKey();
                        String langValueValue = (String)langValueProperty.getValue();
                        nodeCypher.append(String.format("`lang.%s.%s`:'%s',", langKey, langValueKey, langValueValue));
                    });
                });
            } else if (!labels.get(0).equals("MonitorRule") || !((String)nodeProperty.getKey()).equals("product")) {
                if (((String)nodeProperty.getKey()).contains(".")) {
                    nodeCypher.append(String.format("`%s`:", nodeProperty.getKey()));
                } else {
                    nodeCypher.append(String.format("%s:", nodeProperty.getKey()));
                }
                if (nodeProperty.getValue() instanceof String) {
                    String propertyValue2 = (String)nodeProperty.getValue();
                    propertyValue2 = propertyValue2.replace("'", "\"");
                    nodeCypher.append(String.format("'%s',", propertyValue2));
                } else if (nodeProperty.getValue() instanceof Collection) {
                    List propertyValueList = (List)nodeProperty.getValue();
                    if (!propertyValueList.isEmpty() && propertyValueList.get(0) instanceof Map) {
                        String propertyValue3 = JSON.toJSONString(nodeProperty.getValue());
                        propertyValue3 = propertyValue3.replace("'", "\"");
                        nodeCypher.append(String.format("'%s',", propertyValue3));
                    } else {
                        nodeCypher.append("[");
                        propertyValueList.forEach(propertyValue -> {
                            if (propertyValue instanceof String) {
                                nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                            } else {
                                nodeCypher.append(propertyValue).append(",");
                            }
                        });
                        if (!propertyValueList.isEmpty()) {
                            nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                        }
                        nodeCypher.append("],");
                    }
                } else if (nodeProperty.getValue() instanceof Map) {
                    String propertyValue4 = JSON.toJSONString(nodeProperty.getValue());
                    propertyValue4 = propertyValue4.replace("'", "\"");
                    nodeCypher.append(String.format("'%s',", propertyValue4));
                } else {
                    nodeCypher.append(nodeProperty.getValue()).append(",");
                }
            }
        });
        nodeCypher.append(String.format("nameSpace:'%s',athena_namespace:'%s',version:'%s'})", application, application, version));
        Neo4jManager.getNeo4jManager().ExecuteNoQuery(nodeCypher.toString());
        JSONObject nodeKey = new JSONObject();
        nodeKey.put("label", labels.get(0));
        nodeKey.put("labelPK", nodeJson.get((Object)labelPK));
        nodeKey.put("application", (Object)application);
        nodeKey.put("version", (Object)version);
        if (relationTables != null) {
            relationTableMap.put(nodeKey, relationTables);
        }
    }

    private void executeMongoData(String application, String version) {
        File[] mongoDbsFile;
        File applicationFile = SafeFileUtils.createFile((String)(FileUtils.gitFilePath + "athenaData/" + application + "/mongo"));
        for (File mongoDbFile : mongoDbsFile = applicationFile.listFiles()) {
            File[] mongoCollectionsFile;
            String dbName = mongoDbFile.getName();
            for (File mongoCollectionFile : mongoCollectionsFile = mongoDbFile.listFiles()) {
                File[] mongoDocumentsFile;
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(mongoCollectionFile.getName()).deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"athena_namespace", (Object)application), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.and((Bson[])new Bson[]{Filters.ne((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM")})})}));
                for (File mongoDocumentFile : mongoDocumentsFile = mongoCollectionFile.listFiles()) {
                    JSONObject mongoDocument = (JSONObject)FileUtils.readObjectFromFilePath2((String)mongoDocumentFile.getPath(), JSONObject.class);
                    Document document = Document.parse((String)mongoDocument.toString());
                    document.remove((Object)"_id");
                    document.remove((Object)"isMigrate");
                    document.put("application", (Object)application);
                    document.put("athena_namespace", (Object)application);
                    document.put("version", (Object)version);
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(mongoCollectionFile.getName()).insertOne((Object)document);
                }
            }
        }
        log.info("Mongo OK");
    }

    public void addApplicationVersion(String newVersion, String oldVersion) throws InterruptedException {
        this.addNeo4jVersion(newVersion, oldVersion);
        if (Neo4j2Manager.getNeo4jManager() != null) {
            this.addNeo4j2Version(newVersion, oldVersion);
        }
        this.addMongoVersion(newVersion, oldVersion);
    }

    public void addApplicationVersion(String version) throws InterruptedException {
        String prodVersion = this.deployerProgressService.getProdVersion();
        this.addNeo4jVersion(version, prodVersion);
        if (Neo4j2Manager.getNeo4jManager() != null) {
            this.addNeo4j2Version(version, prodVersion);
        }
        this.addMongoVersion(version, prodVersion);
    }

    private void addNeo4jVersion(String version, String prodVersion) throws InterruptedException {
        ConcurrentHashMap nodeNeo4jIdMap = new ConcurrentHashMap();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", prodVersion);
        List nodeResultList = Neo4j1Manager.getNeo4jManager().ExecuteQuery("match (node) where node.version = $version and not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) return node", param);
        List relationList = Neo4j1Manager.getNeo4jManager().ExecuteQuery("match (startNode)-[relation]->(endNode) where startNode.version = $version and endNode.version = $version and not any(startNodeLabel in labels(startNode) WHERE startNodeLabel in ['TenantEntity']) return id(startNode) as startNodeId,type(relation) as relationType,id(endNode) as endNodeId", param);
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        Iterator iterator = nodeResultList.iterator();
        while (iterator.hasNext()) {
            Map nodeResult;
            Map finalNodeResult = nodeResult = (Map)iterator.next();
            executorService.submit(() -> {
                Object nodeObj = finalNodeResult.get("node");
                if (!(nodeObj instanceof Node)) {
                    return;
                }
                Node node = (Node)nodeObj;
                StringBuffer nodeCypher = new StringBuffer("create (node");
                node.labels().forEach(label -> nodeCypher.append(String.format(":%s", label)));
                nodeCypher.append("{");
                Map properties = node.asMap();
                List filteredProps = properties.entrySet().stream().filter(entry -> !"version".equals(entry.getKey())).collect(Collectors.toList());
                for (Map.Entry entry2 : filteredProps) {
                    String key = (String)entry2.getKey();
                    Object value = entry2.getValue();
                    if (key.contains(".")) {
                        nodeCypher.append(String.format("`%s`:", key));
                    } else {
                        nodeCypher.append(String.format("%s:", key));
                    }
                    if (value instanceof String) {
                        String strValue = (String)value;
                        strValue = strValue.replace("'", "\"");
                        nodeCypher.append(String.format("'%s',", strValue));
                        continue;
                    }
                    if (value instanceof Collection) {
                        nodeCypher.append("[");
                        Collection collValue = (Collection)value;
                        for (Object item : collValue) {
                            if (item instanceof String) {
                                nodeCypher.append(String.format("'%s'", item)).append(",");
                                continue;
                            }
                            nodeCypher.append(item).append(",");
                        }
                        if (!collValue.isEmpty()) {
                            nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                        }
                        nodeCypher.append("],");
                        continue;
                    }
                    nodeCypher.append(value).append(",");
                }
                nodeCypher.append(String.format("version:'%s'}) return id(node) as nodeId", version));
                List newNodeResultList = Neo4j1Manager.getNeo4jManager().ExecuteQuery(StringEscapeUtils.escapeJava((String)nodeCypher.toString()));
                if (!newNodeResultList.isEmpty()) {
                    Long newNodeNeo4jId = (Long)((Map)newNodeResultList.get(0)).get("nodeId");
                    nodeNeo4jIdMap.put(node.id(), newNodeNeo4jId);
                }
            });
        }
        executorService.shutdown();
        while (!executorService.awaitTermination(2L, TimeUnit.SECONDS)) {
            log.info("neo4jNode copy Ing...");
        }
        relationList.forEach(relation -> {
            relation.put("startNodeId", nodeNeo4jIdMap.get(relation.get("startNodeId")));
            relation.put("endNodeId", nodeNeo4jIdMap.get(relation.get("endNodeId")));
        });
        ArrayList<MyStatement> relationStatementList = new ArrayList<MyStatement>();
        for (Map relation2 : relationList) {
            int startNodeId = (Integer)relation2.get("startNodeId");
            int endNodeId = (Integer)relation2.get("endNodeId");
            String relationType = (String)relation2.get("relationType");
            String relationCypher = String.format("MATCH (startNode),(endNode) WHERE id(startNode)=%d AND id(endNode)=%d MERGE (startNode)-[relation:%s]->(endNode)", startNodeId, endNodeId, relationType);
            relationStatementList.add(new MyStatement(relationCypher));
        }
        executorService = Executors.newFixedThreadPool(10);
        for (Map relation2 : relationList) {
            executorService.submit(() -> {
                int startNodeId = (Integer)relation2.get("startNodeId");
                int endNodeId = (Integer)relation2.get("endNodeId");
                String relationCypher = String.format("match (startNode),(endNode) WHERE id(startNode)=%d and id(endNode)=%d merge (startNode)-[relation:%s]->(endNode)", startNodeId, endNodeId, relation2.get("relationType"));
                Neo4j1Manager.getNeo4jManager().ExecuteNoQuery(relationCypher);
            });
        }
        executorService.shutdown();
        while (!executorService.awaitTermination(2L, TimeUnit.SECONDS)) {
            log.info("\u91cd\u65b0\u7ed1\u5b9a\u5173\u7cfb\u4e2d~");
        }
    }

    private void addNeo4j2Version(String version, String prodVersion) throws InterruptedException {
        ConcurrentHashMap nodeNeo4jIdMap = new ConcurrentHashMap();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", prodVersion);
        List nodeResultList = Neo4j2Manager.getNeo4jManager().ExecuteQuery("MATCH (node) WHERE node.version = $version AND NOT ANY(label IN labels(node) WHERE label IN ['TenantEntity', 'AppEntity']) RETURN node", params);
        HashMap<String, String> paramsVersion = new HashMap<String, String>();
        paramsVersion.put("version", prodVersion);
        params.put("version", prodVersion);
        List relationList = Neo4j2Manager.getNeo4jManager().ExecuteQuery("match (startNode)-[relation]->(endNode) where startNode.version = $version and endNode.version = $version and not any(startNodeLabel in labels(startNode) WHERE startNodeLabel in ['TenantEntity'])return id(startNode) as startNodeId,type(relation) as relationType,id(endNode) as endNodeId", paramsVersion);
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        Iterator iterator = nodeResultList.iterator();
        while (iterator.hasNext()) {
            Map nodeResult;
            Map finalNodeResult = nodeResult = (Map)iterator.next();
            executorService.submit(() -> {
                Object nodeObj = finalNodeResult.get("node");
                if (!(nodeObj instanceof Node)) {
                    return;
                }
                Node node = (Node)nodeObj;
                StringBuffer nodeCypher = new StringBuffer("create (node");
                node.labels().forEach(label -> nodeCypher.append(String.format(":%s", label)));
                nodeCypher.append("{");
                Map properties = node.asMap();
                List filteredProps = properties.entrySet().stream().filter(entry -> !"version".equals(entry.getKey())).collect(Collectors.toList());
                for (Map.Entry entry2 : filteredProps) {
                    String key = (String)entry2.getKey();
                    Object value = entry2.getValue();
                    if (key.contains(".")) {
                        nodeCypher.append(String.format("`%s`:", key));
                    } else {
                        nodeCypher.append(String.format("%s:", key));
                    }
                    if (value instanceof String) {
                        String strValue = (String)value;
                        strValue = strValue.replace("'", "\"");
                        nodeCypher.append(String.format("'%s',", strValue));
                        continue;
                    }
                    if (value instanceof Collection) {
                        nodeCypher.append("[");
                        Collection collValue = (Collection)value;
                        for (Object item : collValue) {
                            if (item instanceof String) {
                                nodeCypher.append(String.format("'%s'", item)).append(",");
                                continue;
                            }
                            nodeCypher.append(item).append(",");
                        }
                        if (!collValue.isEmpty()) {
                            nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                        }
                        nodeCypher.append("],");
                        continue;
                    }
                    nodeCypher.append(value).append(",");
                }
                nodeCypher.append(String.format("version:'%s'}) return id(node) as nodeId", version));
                List newNodeResultList = Neo4j2Manager.getNeo4jManager().ExecuteQuery(StringEscapeUtils.escapeJava((String)nodeCypher.toString()));
                if (!newNodeResultList.isEmpty()) {
                    Long newNodeNeo4jId = (Long)((Map)newNodeResultList.get(0)).get("nodeId");
                    nodeNeo4jIdMap.put(node.id(), newNodeNeo4jId);
                }
            });
        }
        executorService.shutdown();
        while (!executorService.awaitTermination(2L, TimeUnit.SECONDS)) {
            log.info("neo4jNode copy Ing...");
        }
        relationList.forEach(relation -> {
            relation.put("startNodeId", nodeNeo4jIdMap.get(relation.get("startNodeId")));
            relation.put("endNodeId", nodeNeo4jIdMap.get(relation.get("endNodeId")));
        });
        ArrayList<MyStatement> relationStatementList = new ArrayList<MyStatement>();
        for (Map relation2 : relationList) {
            String relationCypher = StrUtil.format((CharSequence)"match (startNode),(endNode) WHERE id(startNode)={} and id(endNode)={} merge (startNode)-[relation:{}]->(endNode)", (Object[])new Object[]{relation2.get("startNodeId"), relation2.get("endNodeId"), relation2.get("relationType")});
            relationStatementList.add(new MyStatement(relationCypher));
        }
        executorService = Executors.newFixedThreadPool(10);
        for (Map relation2 : relationList) {
            executorService.submit(() -> {
                String relationCypher = StrUtil.format((CharSequence)"match (startNode),(endNode) WHERE id(startNode)={} and id(endNode)={} merge (startNode)-[relation:{}]->(endNode)", (Object[])new Object[]{relation2.get("startNodeId"), relation2.get("endNodeId"), relation2.get("relationType")});
                Neo4j2Manager.getNeo4jManager().ExecuteNoQuery(relationCypher);
            });
        }
        executorService.shutdown();
        while (!executorService.awaitTermination(2L, TimeUnit.SECONDS)) {
            log.info("\u91cd\u65b0\u7ed1\u5b9a\u5173\u7cfb\u4e2d~");
        }
    }

    private void addMongoVersion(String newVersion, String oldVersion) {
        List initMongoList = this.getMongoCollection();
        Bson bson = Filters.eq((String)"version", (Object)oldVersion);
        for (HashMap initMongo : initMongoList) {
            ((List)initMongo.get("collectionName")).forEach(collection -> {
                ArrayList newDocuments = new ArrayList();
                FindIterable documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)initMongo.get("dbName")).getCollection(collection).find(bson);
                documents.forEach(document -> {
                    Document newDocument = new Document((Map)document);
                    newDocument.remove((Object)"_id");
                    newDocument.put("version", (Object)newVersion);
                    newDocuments.add(newDocument);
                });
                if (!newDocuments.isEmpty()) {
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)initMongo.get("dbName")).getCollection(collection).insertMany(newDocuments);
                }
            });
        }
    }

    public List<HashMap<String, Object>> getMongoCollection() {
        ArrayList<HashMap<String, Object>> initMongoList = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> param1 = new HashMap<String, Object>();
        param1.put("dbName", "knowledgegraphSystem");
        param1.put("collectionName", Lists.newArrayList((Object[])new String[]{"activityConfigs", "application", "applicationRelation", "bizRelatedReports", "monitorRuleProductConfig", "serviceConfig", "taskConfigs", "transformActionRule", "taskMonitorRule", "variableDefinition", "applicationRecommendation", "digitalStaff"}));
        initMongoList.add(param1);
        HashMap<String, Object> param2 = new HashMap<String, Object>();
        param2.put("dbName", "preset");
        param2.put("collectionName", Lists.newArrayList((Object[])new String[]{"rules"}));
        initMongoList.add(param2);
        HashMap<String, Object> param3 = new HashMap<String, Object>();
        param3.put("dbName", "tagSystem");
        param3.put("collectionName", Lists.newArrayList((Object[])new String[]{"taggingData"}));
        initMongoList.add(param3);
        HashMap<String, Object> param4 = new HashMap<String, Object>();
        param4.put("dbName", "datamap");
        param4.put("collectionName", Lists.newArrayList((Object[])new String[]{"activity", "dataDescription", "dataGroup", "dataMap", "dataState", "flowGraph", "pageView", "project", "task"}));
        initMongoList.add(param4);
        return initMongoList;
    }

    public void deleteApplicationVersion(String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        List tenantEntity = Neo4jManager.getNeo4jManager().ExecuteQuery("match (tenantEntity) where tenantEntity.version=$version return tenantEntity", param);
        Iterator iterator = tenantEntity.iterator();
        if (iterator.hasNext()) {
            throw new BusinessException("There is also a tenant association for the current version, deletion prohibited!");
        }
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node) where node.version=$version detach delete node", param);
        Bson bson = Filters.eq((String)"version", (Object)version);
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("dbName").getCollection("collection").deleteMany(bson);
    }

    public void checkTagData(MyDesignerData myTagData, Application application) {
        List tagIdList = myTagData.getTagDetailList().stream().map(TagDetailDO::getTagId).collect(Collectors.toList());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("version", application.getVersion());
        param.put("tagIdList", tagIdList);
        List tagResult = Neo4jManager.getNeo4jManager().ExecuteQuery("match(tag:Tag) where tag.version=$version and tag.id in $tagIdList return tag.id as tagId,tag.code as tagCode,tag.category as tagCategory", param);
        block0: for (TagDetailDO tagDetail : myTagData.getTagDetailList()) {
            for (Map tag : tagResult) {
                if (!tag.get("tagId").equals(tagDetail.getTagId())) continue;
                if (tag.get("tagCode").equals(tagDetail.getCode()) && tag.get("tagCategory").equals(tagDetail.getCategory())) continue block0;
                RuntimeException exception = new RuntimeException("tag" + String.valueOf(tag.get("tagId")) + ":" + String.valueOf(tag.get("tagCode")) + "(" + String.valueOf(tag.get("tagCategory")) + ") was modified to " + tagDetail.getCode() + "(" + tagDetail.getCategory() + "), please check");
                this.deployerProgressService.updatePublishEvent(application, (Exception)exception);
                throw exception;
            }
        }
        List myDocumentList = myTagData.getMyDocumentList().stream().filter(myDocument -> myDocument.getColName().equals("tag-definition")).collect(Collectors.toList());
        List myTagDefinitionList = myDocumentList.stream().map(document -> Document.parse((String)document.getDocument())).collect(Collectors.toList());
        Set myTagDefinitionCodeSet = myTagDefinitionList.stream().map(document -> document.getString((Object)"code")).collect(Collectors.toSet());
        Bson bson = Filters.in((String)"code", myTagDefinitionCodeSet);
        FindIterable tagDefinitionList = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("uibot_tag").getCollection("tag-definition").find(bson);
        for (Document tagDefinition : tagDefinitionList) {
            for (Document myTagDefinition : myTagDefinitionList) {
                if (!Objects.equals(tagDefinition.get((Object)"code"), myTagDefinition.get((Object)"code"))) continue;
                tagDefinition.remove((Object)"_id").equals(myTagDefinition.remove((Object)"_id"));
                if (tagDefinition.equals((Object)myTagDefinition)) continue;
                RuntimeException exception = new RuntimeException("Modification of tag-definition" + String.valueOf(tagDefinition.get((Object)"code")) + ":[" + String.valueOf(tagDefinition) + "] is not allowed, Please check");
                this.deployerProgressService.updatePublishEvent(application, (Exception)exception);
                throw exception;
            }
        }
    }

    public void checkDemoDesignerData(MyDesignerData myDesignerData, Application application) {
        ArrayList nameSpace = new ArrayList();
        application.getApplicationCode().forEach(applicationCode -> nameSpace.add(this.getNameSpace(applicationCode, application)));
        for (MyDocument myDocument : myDesignerData.getMyDocumentList()) {
            Document document = Document.parse((String)myDocument.getDocument());
            if (document.get((Object)"application").equals("common") || nameSpace.contains(document.get((Object)"application"))) continue;
            RuntimeException exception = new RuntimeException("The data does not correspond to the project to be published:" + myDocument.getDocument());
            this.deployerProgressService.updatePublishEvent(application, (Exception)exception);
            throw exception;
        }
    }

    public void runDemoDesignerData(MyDesignerData myDesignerData, Application application) {
        log.info("\u66f4\u65b0demo_data\u6570\u636e\u81f3" + application.getVersion());
        log.info("\u5f00\u59cb\u6e05\u9664neo4j\u6570\u636e: " + application.getVersion());
        List myStatementList = myDesignerData.getMyStatementList();
        boolean cleanCommon = false;
        for (MyStatement myStatement2 : myStatementList) {
            if (!myStatement2.getStatement().contains("Create (action:Action:EspAction")) continue;
            cleanCommon = true;
            break;
        }
        if (cleanCommon) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("version", application.getVersion());
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("MATCH (node)  where node.version =$version and node.nameSpace in ['espCommon','common'] and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node", param);
        }
        application.getApplicationCode().forEach(applicationCode -> {
            String nameSpace = this.getNameSpace(applicationCode, application);
            log.info("\u6e05\u9664neo4j\u6570\u636e" + applicationCode + ": " + application.getVersion());
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("nameSpace", nameSpace);
            param.put("version", application.getVersion());
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("MATCH (node)  where node.version =$version and node.nameSpace =$nameSpace and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node", param);
        });
        log.info("\u66f4\u65b0neo4j\u6570\u636e");
        myStatementList.forEach(myStatement -> {
            String text = myStatement.getStatement();
            text = text.replace("version:'paas'", "version:'" + application.getVersion() + "'").replace("version = 'paas'", "version = '" + application.getVersion() + "'");
            myStatement.setStatement(text);
        });
        int listSize = myStatementList.size();
        int toIndex = 100;
        for (int i = 0; i < myStatementList.size(); i += 100) {
            if (i + 100 > listSize) {
                toIndex = listSize - i;
            }
            List subStatementList = myStatementList.subList(i, i + toIndex);
            String commitUrl = this.httpNeo4jConfig.getUrl() + "/db/data/transaction/commit";
            HttpHeaders httpHeaders = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            httpHeaders.setContentType(type);
            httpHeaders.set("X-Stream", "true");
            httpHeaders.set("Authorization", this.httpNeo4jConfig.getPassword());
            JSONObject body = new JSONObject();
            body.put("statements", subStatementList);
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
            JSONObject response = (JSONObject)this.restTemplate.postForObject(commitUrl, (Object)httpEntity, JSONObject.class, new Object[0]);
            log.info("transactionCommit response:{}", (Object)response);
            if (this.httpNeo4j2Config == null) continue;
            String commit2Url = this.httpNeo4j2Config.getUrl() + "/db/data/transaction/commit";
            JSONObject response2 = (JSONObject)this.restTemplate.postForObject(commit2Url, (Object)httpEntity, JSONObject.class, new Object[0]);
            log.info("transactionCommit2 response2:{}", (Object)response2);
        }
        ArrayList initMongoList = new ArrayList();
        List myDocumentList = myDesignerData.getMyDocumentList();
        for (MyDocument myDocument2 : myDocumentList) {
            boolean needContinue = false;
            for (HashMap hashMap : initMongoList) {
                if (!myDocument2.getDbName().equals(hashMap.get("dbName")) || !myDocument2.getColName().equals(hashMap.get("collectionName")) || !Document.parse((String)myDocument2.getDocument()).getString((Object)"application").equals(hashMap.get("application"))) continue;
                needContinue = true;
                break;
            }
            if (needContinue) continue;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("dbName", myDocument2.getDbName());
            param.put("collectionName", myDocument2.getColName());
            param.put("application", Document.parse((String)myDocument2.getDocument()).getString((Object)"application"));
            initMongoList.add(param);
        }
        log.info("\u5f00\u59cb\u6e05\u9664mongo\u6570\u636e: " + application.getVersion());
        for (HashMap hashMap : initMongoList) {
            log.info("\u6e05\u9664mongo\u6570\u636e" + (String)hashMap.get("application") + ": " + application.getVersion());
            Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)application.getVersion()), Filters.eq((String)"application", (Object)((String)hashMap.get("application")))});
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)hashMap.get("dbName")).getCollection((String)hashMap.get("collectionName")).deleteMany(bson);
        }
        log.info("\u66f4\u65b0mongo\u6570\u636e");
        myDocumentList.forEach(myDocument -> {
            Document document = Document.parse((String)myDocument.getDocument());
            document.remove((Object)"_id");
            document.put("version", (Object)application.getVersion());
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(myDocument.getDbName()).getCollection(myDocument.getColName()).insertOne((Object)document);
        });
        log.info("\u66f4\u65b0demo_data\u6570\u636e\u81f3" + application.getVersion() + "\u5b8c\u6210");
    }

    private String getNameSpace(String applicationCode, Application application) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appCode", applicationCode);
        List appResult = Neo4jManager.getNeo4jManager().ExecuteQuery("match (app:AppEntity) where app.code=$appCode return app.namespace as nameSpace", param);
        Iterator iterator = appResult.iterator();
        if (!iterator.hasNext()) {
            RuntimeException exception = new RuntimeException("The application to be published does not exist. Please check the input parameters");
            this.deployerProgressService.updatePublishEvent(application, (Exception)exception);
            throw exception;
        }
        Map next = (Map)iterator.next();
        return (String)next.get("nameSpace");
    }

    public void runDemoTagData(MyDesignerData myTagData, Application application) {
        log.info("\u66f4\u65b0tag_data\u6570\u636e\u81f3" + application.getVersion());
        Set<String> resourceIdSet = myTagData.getMyDocumentList().stream().filter(myDocument -> "taggingData".equals(myDocument.getColName())).map(myDocument -> Document.parse((String)myDocument.getDocument()).getString((Object)"resourceId")).collect(Collectors.toSet());
        Set<String> tagDefinitionCodeSet = myTagData.getMyDocumentList().stream().filter(myDocument -> "tag-definition".equals(myDocument.getColName())).map(myDocument -> Document.parse((String)myDocument.getDocument()).getString((Object)"code")).collect(Collectors.toSet());
        log.info("\u6e05\u9664mongo\u6570\u636e" + String.valueOf(resourceIdSet) + ": " + application.getVersion());
        resourceIdSet.forEach(resourceId -> {
            Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)application.getVersion()), Filters.eq((String)"resourceId", (Object)resourceId)});
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("tagSystem").getCollection("taggingData").deleteMany(bson);
        });
        if ("DEV".equals(this.environment)) {
            tagDefinitionCodeSet.forEach(tagDefinitionCode -> {
                Bson bson = Filters.eq((String)"code", (Object)tagDefinitionCode);
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("uibot_tag").getCollection("tag-definition").deleteMany(bson);
            });
        }
        log.info("\u66f4\u65b0mongo\u6570\u636e");
        myTagData.getMyDocumentList().forEach(myDocument -> {
            if ("tag-definition".equals(myDocument.getColName())) {
                Document document = Document.parse((String)myDocument.getDocument());
                if ("DEV".equals(this.environment)) {
                    document.remove((Object)"_id");
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("uibot_tag").getCollection("tag-definition").insertOne((Object)document);
                } else {
                    Bson filter = Filters.eq((String)"code", (Object)document.getString((Object)"code"));
                    document.remove((Object)"_id");
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("uibot_tag").getCollection("tag-definition").updateOne(filter, (Bson)new Document("$set", (Object)document), new UpdateOptions().upsert(true));
                }
            } else if ("taggingData".equals(myDocument.getColName())) {
                Document document = Document.parse((String)myDocument.getDocument());
                document.remove((Object)"_id");
                document.put("version", (Object)application.getVersion());
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("tagSystem").getCollection("taggingData").insertOne((Object)document);
            }
        });
        log.info("\u66f4\u65b0neo4j\u6570\u636e");
        List tagIdList = myTagData.getTagDetailList().stream().map(TagDetailDO::getTagId).collect(Collectors.toList());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("version", application.getVersion());
        param.put("tagIdList", tagIdList);
        List tagResult = Neo4jManager.getNeo4jManager().ExecuteQuery("match(tag:Tag) where tag.version=$version and tag.id in $tagIdList return tag.id as tagId,tag.code as tagCode,tag.category as tagCategory", param);
        List tagDetailList = myTagData.getTagDetailList();
        Iterator iterator = tagDetailList.iterator();
        block0: while (iterator.hasNext()) {
            TagDetailDO tagDetail2 = (TagDetailDO)iterator.next();
            for (Map tag : tagResult) {
                if (!tag.get("tagId").equals(tagDetail2.getTagId())) continue;
                if (!"DEV".equals(this.environment)) {
                    iterator.remove();
                    continue block0;
                }
                log.info("\u6e05\u9664neo4j\u6570\u636e: " + String.valueOf(tag.get("tagId")));
                HashMap<String, String> param2 = new HashMap<String, String>();
                param2.put("version", application.getVersion());
                param2.put("id", (String)tag.get("tagId"));
                Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(tag:Tag) where tag.version=$version and tag.id = $id optional match (tag)-[:TRANSLATION]->(language:Language)  detach delete tag,language", param2);
                continue block0;
            }
        }
        tagDetailList.forEach(tagDetail -> {
            HashMap param1 = new HashMap();
            param.put("tagCode", tagDetail.getCode());
            param.put("tagName", tagDetail.getName());
            param.put("tagId", tagDetail.getTagId());
            param.put("tagCategory", tagDetail.getCategory());
            param.put("version", application.getVersion());
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("create (tag:Tag{code:$tagCode,scope:['column'],name:$tagName,id:$tagId,category:$tagCategory,version:$version,status:1})", param1);
            if (!StringUtils.isEmpty((Object)tagDetail.getEnName())) {
                HashMap<String, Object> param2 = new HashMap<String, Object>();
                param2.put("tagId", tagDetail.getTagId());
                param2.put("locale", "en_US");
                param2.put("name", tagDetail.getEnName());
                param2.put("version", application.getVersion());
                Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (tag:Tag {id:$tagId,version:$version}) create (tag)-[:TRANSLATION]->(:Language {locale:$locale,name:$name,version:$version})", param2);
            }
            if (!StringUtils.isEmpty((Object)tagDetail.getTwName())) {
                HashMap<String, Object> param3 = new HashMap<String, Object>();
                param3.put("tagId", tagDetail.getTagId());
                param3.put("locale", "zh_TW");
                param3.put("name", tagDetail.getTwName());
                param3.put("version", application.getVersion());
                Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (tag:Tag {id:$tagId,version:$version}) create (tag)-[:TRANSLATION]->(:Language {locale:$locale,name:$name,version:$version})", param3);
            }
        });
        List<TagDetailDO> activityTag = tagDetailList.stream().filter(tagDetail -> "ACTIVITY".equals(tagDetail.getCategory())).collect(Collectors.toList());
        activityTag.forEach(tagDetail -> {
            HashMap<String, Object> param4 = new HashMap<String, Object>();
            param4.put("tagId", tagDetail.getTagId());
            param4.put("relatedId", tagDetail.getCode());
            param4.put("version", application.getVersion());
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (tag:Tag {id:$tagId,version:$version}) create (related:RelatedObject {id:$relatedId,version:$version})-[:USE]->(tag)", param4);
        });
        List<TagDetailDO> roleActivityTag = tagDetailList.stream().filter(tagDetail -> "ROLE__ACTIVITY".equals(tagDetail.getCategory())).collect(Collectors.toList());
        roleActivityTag.forEach(tagDetail -> {
            String relatedId = tagDetail.getCode().split("__")[0];
            HashMap<String, Object> param5 = new HashMap<String, Object>();
            param5.put("tagId", tagDetail.getTagId());
            param5.put("relatedId", relatedId);
            param5.put("version", application.getVersion());
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (tag:Tag {id:$tagId,version:$version}) match (related:RelatedObject {id:$relatedId,version:$version}) merge (related)-[:USE]->(tag)", param5);
        });
        log.info("\u66f4\u65b0tag_data\u6570\u636e\u81f3" + application.getVersion() + "\u5b8c\u6210");
    }

    public List<String> getTenantListByApplication(String applicationCode) {
        ArrayList<String> tenantList = new ArrayList<String>();
        String prodVersion = this.deployerProgressService.getProdVersion();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", prodVersion);
        param.put("applicationCode", applicationCode);
        List tenantListResult = Neo4jManager.getNeo4jManager().ExecuteQuery("match (tenant:TenantEntity)-[:USE]->(app:AppEntity) where tenant.version=$version and app.code=$applicationCode return tenant.tenantId as tenantId", param);
        tenantListResult.forEach(tenantResult -> tenantList.add((String)tenantResult.get("tenantId")));
        log.info("\u83b7\u53d6\u6b63\u5f0f\u533a{}\u79df\u6237\u4fe1\u606f:{}", (Object)applicationCode, tenantList);
        return tenantList;
    }

    public String getTemplateTenantByApplicationAndTenant(String applicationCode, Application application, String tenantId) {
        List cloudProductNamesWithRetry;
        log.info("\u901a\u8fc7\u5e94\u7528\u5730\u7aef\u4ea7\u54c1\u67e5\u627e\u6a21\u677f\u79df\u6237\u4fe1\u606f");
        try {
            cloudProductNamesWithRetry = this.espService.getCloudProductNames(tenantId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RuntimeException exception = new RuntimeException("Failed to query the tenant's local product information");
            this.deployerProgressService.updatePublishEvent(application, (Exception)exception);
            throw exception;
        }
        List templateTenant = this.findTemplateTenant(cloudProductNamesWithRetry, applicationCode);
        log.info("\u901a\u8fc7\u5e94\u7528\u5730\u7aef\u4ea7\u54c1\u67e5\u627e\u6a21\u677f\u79df\u6237\u4fe1\u606f:{}", (Object)templateTenant);
        if (templateTenant == null || templateTenant.size() != 1) {
            RuntimeException exception = new RuntimeException("Find multiple or empty template tenants through the application's local product:" + String.valueOf(templateTenant));
            this.deployerProgressService.updatePublishEvent(application, (Exception)exception);
            throw exception;
        }
        return (String)templateTenant.get(0);
    }

    public List<String> findTemplateTenant(List<String> products, String appCode) {
        log.info("findTemplateTenant appCode:{}, products:{}", (Object)appCode, products);
        if (CollectionUtils.isEmpty(products)) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"app", (Object)appCode), Filters.in((String)"product", products)});
        FindIterable documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("knowledgegraphSystem").getCollection("productTemplateTenant").find(bson);
        documents.forEach(document -> resultList.add(document.getString((Object)"tenantId")));
        return resultList;
    }

    public void modifyDifferenceData(String applicationCode, String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        param.put("applicationCode", applicationCode);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (tag:Tag) where tag.version=$version and tag.athena_namespace=$applicationCode and tag.category='ROLE__ACTIVITY' and tag.code starts with 'performer__' match (relatedObject:RelatedObject) where relatedObject.id='performer' and relatedObject.version=$version merge (relatedObject)-[:USE]->(tag)", param);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (tag:Tag) where tag.version=$version and tag.athena_namespace=$applicationCode and tag.category='ROLE__ACTIVITY' and tag.code starts with 'charge__' match (relatedObject:RelatedObject) where relatedObject.id='charge' and relatedObject.version=$version merge (relatedObject)-[:USE]->(tag)", param);
    }

    public void publishAthenaDataJustForCompare(String application, String version) {
        this.executeNeo4jDataJustForCompare(application, version);
        this.executeMongoDataJustForCompare(application, version);
    }

    private void executeNeo4jDataJustForCompare(String application, String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("application", application);
        HashMap relationTableMap = new HashMap();
        JSONObject neo4jNodeKeyJson = (JSONObject)FileUtils.readObjectFromFilePath((String)"neo4jNodeKey.json", JSONObject.class);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node{nameSpace:$application}) where not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) and (node.tenantId=\"SYSTEM\" or node.tenantId is null) detach delete node", param);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node{athena_namespace:$application}) where not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) and (node.tenantId=\"SYSTEM\" or node.tenantId is null) detach delete node", param);
        File applicationFile = SafeFileUtils.createFile((String)(FileUtils.gitFilePath + "athenaData/" + application + "/neo4j"));
        File[] labelsFile = applicationFile.listFiles();
        if (labelsFile != null && labelsFile.length > 0) {
            for (File labelFile : labelsFile) {
                File[] subLabelsOrNodesFile;
                String labelName = labelFile.getName();
                String labelPK = neo4jNodeKeyJson.getString(labelName);
                if (StringUtils.isEmpty((Object)labelPK)) {
                    throw new BusinessException("Please add corresponding PK of " + labelName);
                }
                for (File subLabelOrNodeFile : subLabelsOrNodesFile = labelFile.listFiles()) {
                    this.executeNode(subLabelOrNodeFile, application, version, labelPK, relationTableMap);
                }
            }
        }
        this.executeNodeRelationTable(neo4jNodeKeyJson, relationTableMap);
        log.info("Neo4j OK");
    }

    private void executeMongoDataJustForCompare(String application, String version) {
        File[] mongoDbsFile;
        File applicationFile = SafeFileUtils.createFile((String)(FileUtils.gitFilePath + "athenaData/" + application + "/mongo"));
        for (File mongoDbFile : mongoDbsFile = applicationFile.listFiles()) {
            File[] mongoCollectionsFile;
            String dbName = mongoDbFile.getName();
            for (File mongoCollectionFile : mongoCollectionsFile = mongoDbFile.listFiles()) {
                File[] mongoDocumentsFile;
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(mongoCollectionFile.getName()).deleteMany((Bson)new BasicDBObject("athena_namespace", (Object)application));
                for (File mongoDocumentFile : mongoDocumentsFile = mongoCollectionFile.listFiles()) {
                    JSONObject mongoDocument = (JSONObject)FileUtils.readObjectFromFilePath2((String)mongoDocumentFile.getPath(), JSONObject.class);
                    Document document = Document.parse((String)mongoDocument.toString());
                    document.remove((Object)"_id");
                    document.remove((Object)"application");
                    document.remove((Object)"isMigrate");
                    document.put("athena_namespace", (Object)application);
                    document.put("version", (Object)version);
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(mongoCollectionFile.getName()).insertOne((Object)document);
                }
            }
        }
        log.info("Mongo OK");
    }

    public void publishTransferDataToRuntimeDb(String application, String version) {
        this.executeNeo4jDataJustForTransferData(application, version);
        this.executeMongoDataJustForTransferData(application, version);
    }

    private void executeNeo4jDataJustForTransferData(String application, String version) {
        HashMap relationTableMap = new HashMap();
        JSONObject neo4jNodeKeyJson = (JSONObject)FileUtils.readObjectFromFilePath((String)"neo4jNodeKey.json", JSONObject.class);
        String applicationNew = this.compareService.getApplicationByAppCode(application);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("application", applicationNew);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node{nameSpace:$application}) where not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) and (node.tenantId=\"SYSTEM\" or node.tenantId is null) detach delete node", param);
        param.put("application", application);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node{athena_namespace:$application}) where not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) and (node.tenantId=\"SYSTEM\" or node.tenantId is null) detach delete node", param);
        File applicationFile = SafeFileUtils.createFile((String)(FileUtils.gitFilePath + "athenaData/" + application + "/neo4j"));
        File[] labelsFile = applicationFile.listFiles();
        if (labelsFile != null && labelsFile.length > 0) {
            for (File labelFile : labelsFile) {
                File[] subLabelsOrNodesFile;
                String labelName = labelFile.getName();
                String labelPK = neo4jNodeKeyJson.getString(labelName);
                if (StringUtils.isEmpty((Object)labelPK)) {
                    throw new BusinessException("Please add corresponding PK of " + labelName);
                }
                for (File subLabelOrNodeFile : subLabelsOrNodesFile = labelFile.listFiles()) {
                    this.executeNode(subLabelOrNodeFile, application, version, labelPK, relationTableMap);
                }
            }
        }
        this.executeNodeRelationTable(neo4jNodeKeyJson, relationTableMap);
        log.info("Neo4j OK");
    }

    private void executeMongoDataJustForTransferData(String application, String version) {
        File[] mongoDbsFile;
        File applicationFile = SafeFileUtils.createFile((String)(FileUtils.gitFilePath + "athenaData/" + application + "/mongo"));
        for (File mongoDbFile : mongoDbsFile = applicationFile.listFiles()) {
            File[] mongoCollectionsFile;
            String dbName = mongoDbFile.getName();
            for (File mongoCollectionFile : mongoCollectionsFile = mongoDbFile.listFiles()) {
                File[] mongoDocumentsFile;
                String applicationNew = this.compareService.getApplicationByAppCode(application);
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(mongoCollectionFile.getName()).deleteMany(Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)applicationNew), Filters.eq((String)"athena_namespace", (Object)application)}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.and((Bson[])new Bson[]{Filters.ne((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM")})})}));
                for (File mongoDocumentFile : mongoDocumentsFile = mongoCollectionFile.listFiles()) {
                    JSONObject mongoDocument = (JSONObject)FileUtils.readObjectFromFilePath2((String)mongoDocumentFile.getPath(), JSONObject.class);
                    Document document = Document.parse((String)mongoDocument.toString());
                    document.remove((Object)"_id");
                    document.remove((Object)"isMigrate");
                    document.remove((Object)"application");
                    document.put("athena_namespace", (Object)application);
                    document.put("version", (Object)version);
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(mongoCollectionFile.getName()).insertOne((Object)document);
                }
            }
        }
        log.info("Mongo OK");
    }
}

