/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.GitLabConfig;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.compile.CompileData;
import com.digiwin.athena.athenadeployer.domain.compile.CompileResult;
import com.digiwin.athena.athenadeployer.domain.compile.CompileVersion;
import com.digiwin.athena.athenadeployer.domain.deploy.FileNum;
import com.digiwin.athena.athenadeployer.service.AthenaDataService;
import com.digiwin.athena.athenadeployer.service.CompileService;
import com.digiwin.athena.athenadeployer.service.DesignerDataService;
import com.digiwin.athena.athenadeployer.service.JGitService;
import com.digiwin.athena.athenadeployer.utils.DeployUtil;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import com.digiwin.athena.athenadeployer.utils.SafeFileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.bson.types.Binary;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CompileServiceImpl
implements CompileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompileServiceImpl.class);
    @Autowired
    private GitLabConfig gitLabConfig;
    @Autowired
    private JGitService jGitService;
    @Autowired
    private DesignerDataService designerDataService;
    @Autowired
    private AthenaDataService athenaDataService;
    @Autowired(required=false)
    @Qualifier(value="designerMongoTemplate")
    private MongoTemplate designerMongoTemplate;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${design.zipPath}")
    private String designZipPath;
    private static ConcurrentHashMap<String, ReentrantLock> LOCK_MAP = new ConcurrentHashMap();

    public String compile(String application, String branch) {
        ReentrantLock lock = (ReentrantLock)LOCK_MAP.get(application);
        if (lock == null) {
            lock = new ReentrantLock();
            LOCK_MAP.put(application, lock);
        }
        Boolean lockResult = false;
        try {
            lockResult = lock.tryLock();
            if (lockResult.booleanValue()) {
                log.info("\u6b63\u5728\u7f16\u8bd1...");
                this.designerDataService.deleteDesignerData();
                String applicationUrl = (String)this.gitLabConfig.getApplication().get(application);
                try {
                    this.jGitService.cloneRemoteRepository(this.gitLabConfig.getUrl() + "/" + applicationUrl, branch, Constant.DESIGNER_DATA_PATH + File.separator + application);
                }
                catch (IOException | GitAPIException e) {
                    log.error("git clone error\uff0c", e);
                    throw new BusinessException("git clone error");
                }
                this.saveCompileData(application);
                JSONObject compileVersion = this.queryCompileVersion(application);
                compileVersion.put("majorVersion", (Object)(compileVersion.getIntValue("majorVersion") + 1));
                compileVersion.remove((Object)"_id");
                this.designerMongoTemplate.save((Object)compileVersion, "compileVersion");
                String string = compileVersion.getString("minorVersion") + "." + compileVersion.getInteger("majorVersion");
                return string;
            }
            try {
                log.info("{}\u6b63\u5728\u53d1\u5e03...", (Object)application);
                throw new BusinessException("The current app is being published, please wait!");
            }
            catch (Exception e) {
                log.error("compile error\uff0c", (Throwable)e);
                throw new BusinessException("compile error");
            }
        }
        finally {
            if (lockResult.booleanValue()) {
                log.info("\u91ca\u653e\u9501compileApplication\uff1a{}", (Object)application);
                lock.unlock();
            }
        }
    }

    public CompileVersion queryLatestVersion(String application) {
        JSONObject jsonObject = this.queryCompileVersion(application);
        return (CompileVersion)jsonObject.toJavaObject(CompileVersion.class);
    }

    public List<CompileData> queryLatestCompileData(List<String> applicationList) {
        ArrayList<CompileData> compileDataList = new ArrayList<CompileData>();
        for (String application : applicationList) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application));
            query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"version"})).limit(1);
            query.fields().include("application").include("fileNumList").include("version");
            CompileData compiledData = (CompileData)this.designerMongoTemplate.findOne(query, CompileData.class, "compiledData");
            if (compiledData == null) {
                throw new BusinessException(StrUtil.format((CharSequence)"{}:The compilation package for this application was not found. Please compile before deploying!", (Object[])new Object[]{application}));
            }
            compileDataList.add(compiledData);
        }
        return compileDataList;
    }

    public String upZipPackage(String application) {
        CompileVersion compileVersionObj = this.queryLatestVersion(application);
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        String compileVersion = compileVersionObj.getMinorVersion() + "." + decimalFormat.format(compileVersionObj.getMajorVersion());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("version").is((Object)compileVersion));
        JSONObject compiledData = (JSONObject)this.designerMongoTemplate.findOne(query, JSONObject.class, "compiledData");
        byte[] bytes = ((Binary)compiledData.get((Object)"file")).getData();
        String compileDataZipPath = StrUtil.format((CharSequence)(Constant.DESIGNER_DATA_PATH + File.separator + application + File.separator + "{}.zip"), (Object[])new Object[]{application});
        FileUtil.writeBytes((byte[])bytes, (String)compileDataZipPath);
        ZipUtil.unzip((String)compileDataZipPath, (String)(Constant.DESIGNER_DATA_PATH + File.separator + application));
        return compileVersion;
    }

    public void saveCompileData(String application) {
        String version = this.calculateVersion(application);
        String designDataZipPath = StrUtil.format((CharSequence)(this.designZipPath + "design_{}.zip"), (Object[])new Object[]{version});
        File designDataFileZip = ZipUtil.zip((String)(Constant.DESIGNER_DATA_PATH + application), (String)designDataZipPath, (boolean)false);
        this.athenaDataService.deleteTempAthenaData();
        this.designerDataService.compileDesignerData(application);
        CompileResult mongoCompileResult = this.mongoCompileResult2File(application);
        List mongoDataFiles = mongoCompileResult.getFiles();
        CompileResult neo4jCompileResult = this.cypherList2File(application);
        List cypherFiles = neo4jCompileResult.getFiles();
        mongoDataFiles.addAll(cypherFiles);
        String compiledDataZipPath = StrUtil.format((CharSequence)(this.compileZipPath + "compiled_{}.zip"), (Object[])new Object[]{version});
        File zipFile = ZipUtil.zip((String)this.compileDataPath, (String)compiledDataZipPath, (boolean)false);
        List mongoFileNumList = mongoCompileResult.getFileNumList();
        List neo4jFileNumList = neo4jCompileResult.getFileNumList();
        mongoFileNumList.addAll(neo4jFileNumList);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("file", (Object)FileUtil.readBytes((File)zipFile));
        jsonObject.put("designData", (Object)FileUtil.readBytes((File)designDataFileZip));
        jsonObject.put("version", (Object)version);
        jsonObject.put("application", (Object)application);
        jsonObject.put("fileNumList", (Object)mongoFileNumList);
        this.designerMongoTemplate.save((Object)jsonObject, "compiledData");
        FileUtil.del((File)zipFile);
        FileUtil.del((File)designDataFileZip);
        for (File file : mongoDataFiles) {
            FileUtil.del((File)file);
        }
    }

    private CompileResult mongoCompileResult2File(String application) {
        File[] mongoDbsFile;
        CompileResult compileResult = new CompileResult();
        String version = this.calculateVersion(application);
        ArrayList<FileNum> fileNumList = new ArrayList<FileNum>();
        ArrayList<File> files = new ArrayList<File>();
        File applicationFile = SafeFileUtils.createFile((String)(FileUtils.gitFilePath + "athenaData/" + application + "/mongo"));
        for (File mongoDbFile : mongoDbsFile = applicationFile.listFiles()) {
            File[] mongoCollectionsFile;
            String directorName = mongoDbFile.getName();
            FileNum fileNum = new FileNum();
            fileNum.setLabel(directorName);
            for (File mongoCollectionFile : mongoCollectionsFile = mongoDbFile.listFiles()) {
                String fileName = mongoCollectionFile.getName();
                String filePath = this.compileDataPath + directorName + File.separator + fileName + File.separator + version + ".json";
                ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
                File[] mongoDocumentsFile = mongoCollectionFile.listFiles();
                FileNum childFileNum = new FileNum();
                childFileNum.setLabel(fileName).setNum(Integer.valueOf(mongoDocumentsFile.length));
                fileNum.addChild(childFileNum);
                for (File mongoDocumentFile : mongoDocumentsFile) {
                    JSONObject jsonObject = (JSONObject)FileUtils.readObjectFromFilePath2((String)mongoDocumentFile.getPath(), JSONObject.class);
                    jsonObject.remove((Object)"_id");
                    jsonObject.remove((Object)"application");
                    jsonObject.put("athena_namespace", (Object)application);
                    jsonObject.put("compileVersion", (Object)version);
                    dataList.add(jsonObject);
                }
                File file = SafeFileUtils.createFile((String)filePath);
                FileUtil.writeLines(dataList, (File)file, (String)"utf-8");
                files.add(file);
            }
            fileNumList.add(fileNum);
        }
        compileResult.setFiles(files).setFileNumList(fileNumList);
        return compileResult;
    }

    private String calculateVersion(String application) {
        JSONObject compileVersion = this.queryCompileVersion(application);
        Integer versionMajorNum = compileVersion.getInteger("majorVersion") + 1;
        String versionMinorNum = compileVersion.getString("minorVersion");
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        String version = versionMinorNum + "." + decimalFormat.format(versionMajorNum);
        return version;
    }

    private JSONObject queryCompileVersion(String application) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        query.addCriteria((CriteriaDefinition)criteria);
        query.limit(1);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"majorVersion")}));
        query.fields().include("majorVersion").include("minorVersion").include("application");
        JSONObject compileVersion = (JSONObject)this.designerMongoTemplate.findOne(query, JSONObject.class, "compileVersion");
        if (compileVersion != null) {
            return compileVersion;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("majorVersion", (Object)1);
        jsonObject.put("minorVersion", (Object)"1.0.0");
        jsonObject.put("application", (Object)application);
        return jsonObject;
    }

    private CompileResult cypherList2File(String application) {
        CompileResult compileResult = new CompileResult();
        ArrayList<FileNum> fileNumList = new ArrayList<FileNum>();
        FileNum fileNum = new FileNum();
        fileNum.setLabel("neo4j");
        String version = this.calculateVersion(application);
        HashMap relationTableMap = new HashMap();
        JSONObject neo4jNodeKeyJson = (JSONObject)FileUtils.readObjectFromFilePath((String)"neo4jNodeKey.json", JSONObject.class);
        File applicationFile = SafeFileUtils.createFile((String)(FileUtils.gitFilePath + "athenaData/" + application + "/neo4j"));
        File[] labelsFile = applicationFile.listFiles();
        if (labelsFile == null || labelsFile.length <= 0) {
            compileResult.setFiles(new ArrayList()).setFileNumList(new ArrayList());
            return compileResult;
        }
        ArrayList<String> nodeCypherList = new ArrayList<String>();
        ArrayList<FileNum> childFileNumList = new ArrayList<FileNum>();
        for (File labelFile : labelsFile) {
            String labelName = labelFile.getName();
            String labelPK = neo4jNodeKeyJson.getString(labelName);
            if (StringUtils.isEmpty((Object)labelPK)) {
                throw new BusinessException("Please add corresponding PK of " + labelName);
            }
            File[] subLabelsOrNodesFile = labelFile.listFiles();
            FileNum childFileNum = new FileNum();
            childFileNum.setLabel(labelName).setNum(Integer.valueOf(subLabelsOrNodesFile.length));
            childFileNumList.add(childFileNum);
            for (File subLabelOrNodeFile : subLabelsOrNodesFile) {
                String nodeCypher = this.getNodeCypher(subLabelOrNodeFile, application, version, labelPK, relationTableMap);
                nodeCypherList.add(nodeCypher);
            }
        }
        fileNum.setChildren(childFileNumList);
        fileNumList.add(fileNum);
        List relationCypherList = DeployUtil.getRelationCypherList((JSONObject)neo4jNodeKeyJson, relationTableMap);
        ArrayList<String> cypherList = new ArrayList<String>();
        cypherList.addAll(nodeCypherList);
        cypherList.addAll(relationCypherList);
        File file = SafeFileUtils.createFile((String)(this.compileDataPath + File.separator + "cypher" + File.separator + version + ".json"));
        FileUtil.writeLines(cypherList, (File)file, (String)"utf-8");
        compileResult.setFiles((List)Lists.newArrayList((Object[])new File[]{file})).setFileNumList(fileNumList);
        return compileResult;
    }

    public String getNodeCypher(File nodeFile, String application, String version, String labelPK, Map<JSONObject, JSONArray> relationTableMap) {
        JSONObject nodeJson = (JSONObject)FileUtils.readObjectFromFilePath2((String)nodeFile.getPath(), JSONObject.class);
        JSONArray labels = nodeJson.getJSONArray("labels");
        JSONArray relationTables = nodeJson.getJSONArray("relationTable");
        StringBuffer nodeCypher = new StringBuffer("create (node");
        labels.forEach(label -> nodeCypher.append(String.format(":%s", label)));
        nodeCypher.append("{");
        Set nodeProperties = nodeJson.entrySet();
        nodeProperties.stream().filter(nodeProperty -> !"application".equals(nodeProperty.getKey()) && !"version".equals(nodeProperty.getKey()) && !"nameSpace".equals(nodeProperty.getKey()) && !"labels".equals(nodeProperty.getKey()) && !"relationTable".equals(nodeProperty.getKey())).forEach(nodeProperty -> {
            if (((String)nodeProperty.getKey()).equals("lang")) {
                JSONObject lang = (JSONObject)nodeProperty.getValue();
                Set langProperties = lang.entrySet();
                langProperties.forEach(langProperty -> {
                    String langKey = (String)langProperty.getKey();
                    JSONObject langValue = (JSONObject)langProperty.getValue();
                    Set langValueProperties = langValue.entrySet();
                    langValueProperties.forEach(langValueProperty -> {
                        String langValueKey = (String)langValueProperty.getKey();
                        String langValueValue = (String)langValueProperty.getValue();
                        nodeCypher.append(String.format("`lang.%s.%s`:'%s',", langKey, langValueKey, langValueValue));
                    });
                });
            } else if (!labels.get(0).equals("MonitorRule") || !((String)nodeProperty.getKey()).equals("product")) {
                if (((String)nodeProperty.getKey()).contains(".")) {
                    nodeCypher.append(String.format("`%s`:", nodeProperty.getKey()));
                } else {
                    nodeCypher.append(String.format("%s:", nodeProperty.getKey()));
                }
                if (nodeProperty.getValue() instanceof String) {
                    String propertyValue2 = (String)nodeProperty.getValue();
                    propertyValue2 = propertyValue2.replace("'", "\"");
                    nodeCypher.append(String.format("'%s',", propertyValue2));
                } else if (nodeProperty.getValue() instanceof Collection) {
                    List propertyValueList = (List)nodeProperty.getValue();
                    if (!propertyValueList.isEmpty() && propertyValueList.get(0) instanceof Map) {
                        String propertyValue3 = JSON.toJSONString(nodeProperty.getValue());
                        propertyValue3 = propertyValue3.replace("'", "\"");
                        nodeCypher.append(String.format("'%s',", propertyValue3));
                    } else {
                        nodeCypher.append("[");
                        propertyValueList.forEach(propertyValue -> {
                            if (propertyValue instanceof String) {
                                nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                            } else {
                                nodeCypher.append(propertyValue).append(",");
                            }
                        });
                        if (!propertyValueList.isEmpty()) {
                            nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                        }
                        nodeCypher.append("],");
                    }
                } else if (nodeProperty.getValue() instanceof Map) {
                    String propertyValue4 = JSON.toJSONString(nodeProperty.getValue());
                    propertyValue4 = propertyValue4.replace("'", "\"");
                    nodeCypher.append(String.format("'%s',", propertyValue4));
                } else {
                    nodeCypher.append(nodeProperty.getValue()).append(",");
                }
            }
        });
        nodeCypher.append(String.format("nameSpace:'%s',athena_namespace:'%s',version:'{athena_version}',compileVersion:'%s'})", application, application, version));
        JSONObject nodeKey = new JSONObject();
        nodeKey.put("label", labels.get(0));
        nodeKey.put("labelPK", nodeJson.get((Object)labelPK));
        nodeKey.put("application", (Object)application);
        nodeKey.put("compileVersion", (Object)version);
        nodeKey.put("version", (Object)"{athena_version}");
        if (relationTables != null) {
            relationTableMap.put(nodeKey, relationTables);
        }
        return nodeCypher.toString();
    }
}

