/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import com.digiwin.athena.athenadeployer.dao.mongo.CronJobExecutionTimeDao;
import com.digiwin.athena.athenadeployer.domain.SysCronJobExecutionTime;
import com.digiwin.athena.athenadeployer.service.CronJobExecutionTimeService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CronJobExecutionTimeServiceImpl
implements CronJobExecutionTimeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CronJobExecutionTimeServiceImpl.class);
    private CronJobExecutionTimeDao cronJobExecutionTimeDao;

    @Autowired
    public void setCronJobExecutionTimeDao(CronJobExecutionTimeDao cronJobExecutionTimeDao) {
        this.cronJobExecutionTimeDao = cronJobExecutionTimeDao;
    }

    public SysCronJobExecutionTime getLastExecuteTime(String jobName) throws ParseException {
        SysCronJobExecutionTime sysCronJobExecutionTime = this.cronJobExecutionTimeDao.selectByJobName(jobName);
        if (sysCronJobExecutionTime == null) {
            String initTime = "2000-01-01 00:00:00";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            sysCronJobExecutionTime = new SysCronJobExecutionTime();
            sysCronJobExecutionTime.setJobName(jobName);
            sysCronJobExecutionTime.setLastExecuteTime(simpleDateFormat.parse(initTime));
            sysCronJobExecutionTime.setCreateDate(new Date());
            sysCronJobExecutionTime.setEditDate(new Date());
            sysCronJobExecutionTime.setCreateBy("SYSTEM");
            sysCronJobExecutionTime.setEditBy("SYSTEM");
            this.cronJobExecutionTimeDao.insert(sysCronJobExecutionTime);
        }
        return sysCronJobExecutionTime;
    }

    public void updateLastExecuteTime(String jobName, Date curExecuteTime) throws ParseException {
        SysCronJobExecutionTime sysCronJobExecutionTime = this.getLastExecuteTime(jobName);
        sysCronJobExecutionTime.setLastExecuteTime(curExecuteTime);
        sysCronJobExecutionTime.setEditDate(new Date());
        this.cronJobExecutionTimeDao.save(sysCronJobExecutionTime);
    }
}

