/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.neo4j.Neo4jManager;
import com.digiwin.athena.athenadeployer.domain.Application;
import com.digiwin.athena.athenadeployer.domain.Cql;
import com.digiwin.athena.athenadeployer.neo4j.CqlMapper;
import com.digiwin.athena.athenadeployer.service.DataVersionService;
import com.digiwin.athena.athenadeployer.service.DeployerProgressService;
import com.digiwin.athena.athenadeployer.utils.DeployUtil;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class DataVersionServiceImpl
implements DataVersionService {
    @Generated
    private static final Logger log = LogManager.getLogger(DataVersionServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DeployerProgressService deployerProgressService;

    public void updateTenantVersion(Application application) {
        log.info("update the version of tenantId:" + String.valueOf(application.getTenantId()) + " to" + application.getVersion());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantId", application.getTenantId());
        param.put("version", application.getVersion());
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (tenant:TenantEntity) where tenant.tenantId in $tenantId set tenant.version=$version", param);
        Bson filter = Filters.in((String)"tenantId", (Iterable)application.getTenantId());
        Document update = new Document("$set", (Object)new Document().append("version", (Object)(application.getVersion().split("\\.")[0] + ".x")));
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantConfig").updateMany(filter, (Bson)update);
        HashMap<String, List> param2 = new HashMap<String, List>();
        param2.put("tenantId", application.getTenantId());
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (tenant:TenantEntity)-[oldRelation]-(node) where tenant.tenantId in $tenantId and not any(label in labels(node) WHERE label in ['AppEntity']) delete oldRelation", param2);
        HashMap<String, List> param3 = new HashMap<String, List>();
        param3.put("tenantId", application.getTenantId());
        param3.put("appCode", application.getApplicationCode());
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(t:TenantEntity) where t.tenantId in $tenantId match(app:AppEntity) where app.code in $appCode  merge (t)-[:USE]->(app)", param3);
        application.getTenantId().forEach(arg_0 -> this.updateTenantVersionRelation(arg_0));
        log.info("\u66f4\u65b0" + String.valueOf(application.getTenantId()) + "\u7684\u7248\u672c\u81f3" + application.getVersion() + "\u5b8c\u6210");
    }

    public void updateTenantVersion(String version, List<String> tenantIdList) {
        log.info("\u66f4\u65b0\u79df\u6237\u7248\u672c\uff1a\u79df\u6237:{},\u7248\u672c:{} ...", tenantIdList, (Object)version);
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        cqlList.add(CqlMapper.updateTenantVersion(tenantIdList, (String)version));
        Bson filter = Filters.in((String)"tenantId", tenantIdList);
        Document update = new Document("$set", (Object)new Document().append("version", (Object)(version.split("\\.")[0] + ".x")));
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantConfig").updateMany(filter, (Bson)update);
        cqlList.add(CqlMapper.deleteTenantOldRelation(tenantIdList));
        cqlList.add(CqlMapper.mergeTenantAppRelation(tenantIdList));
        for (String tenantId : tenantIdList) {
            cqlList.addAll(this.updateTenantVersionRelation2(tenantId));
        }
        Neo4jManager.getNeo4jManager().ExecuteTransactionNoQuery(cqlList);
        log.info("\u66f4\u65b0\u79df\u6237\u7248\u672c\u5b8c\u6210\uff1a\u79df\u6237:{},\u7248\u672c:{} ...", tenantIdList, (Object)version);
    }

    private List<Cql> updateTenantVersionRelation2(String tenantId) {
        log.info("\u66f4\u65b0{}\u5173\u8054\u7684\u7248\u672c", (Object)tenantId);
        Cql cql = CqlMapper.queryTenantAppList((String)tenantId);
        List tenantUseAppList = Neo4jManager.getNeo4jManager().ExecuteQuery(cql.getCql(), cql.getParams());
        ArrayList<Cql> transactionCqlList = new ArrayList<Cql>();
        transactionCqlList.addAll(CqlMapper.mergeTenantAndCommonActionRelation((String)tenantId));
        transactionCqlList.add(CqlMapper.mergeTenantAndCommonTaskRelation((String)tenantId));
        transactionCqlList.add(CqlMapper.mergeTenantAndCommonActivityRelation((String)tenantId));
        tenantUseAppList.forEach(tenantUseApp -> {
            List cqlList = DeployUtil.createTenantNodeRelation((String)tenantId, (String)String.valueOf(tenantUseApp.get("appNamespace")));
            transactionCqlList.addAll(cqlList);
            this.updateDTDTenantVersion(tenantId, String.valueOf(tenantUseApp.get("appNamespace")), String.valueOf(tenantUseApp.get("version")));
        });
        log.info("\u66f4\u65b0\u5b8c\u6210: \u66f4\u65b0{}\u5173\u8054\u7684\u7248\u672c", (Object)tenantId);
        return transactionCqlList;
    }

    private void updateDTDTenantVersion(String tenantId, String application, String version) {
        Bson projectFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"version", (Object)version)});
        FindIterable projectDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("project").find(projectFilter);
        projectDocuments.forEach(projectDocument -> {
            Bson tenantProductRelationFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"objectType", (Object)"project"), Filters.eq((String)"objectCode", (Object)projectDocument.getString((Object)"code"))});
            FindIterable tenantProductRelationDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").find(tenantProductRelationFilter);
            AtomicInteger tenantProductRelationCount = new AtomicInteger();
            tenantProductRelationDocuments.forEach(tenantProductRelationDocument -> tenantProductRelationCount.getAndIncrement());
            if (tenantProductRelationCount.get() < 1) {
                Document tenantProductRelation = new Document();
                tenantProductRelation.put("tenantId", (Object)tenantId);
                tenantProductRelation.put("objectType", (Object)"project");
                tenantProductRelation.put("objectCode", (Object)projectDocument.getString((Object)"code"));
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").insertOne((Object)tenantProductRelation);
            }
        });
    }

    private void updateTenantVersionRelation(String tenantId) {
        log.info("\u66f4\u65b0{}\u5173\u8054\u7684\u7248\u672c", (Object)tenantId);
        JSONArray ucTenantArray = (JSONArray)FileUtils.readObjectFromFilePath((String)"uc_tenant.json", JSONArray.class);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        List tenantUseAppList = Neo4jManager.getNeo4jManager().ExecuteQuery("match (tenant:TenantEntity)-[:USE]-(app:AppEntity) where tenant.tenantId=$tenantId return tenant.tenantId as tenantId,tenant.version as version,app.code as appCode,app.namespace as appNamespace", param);
        ArrayList<Cql> statementsAndParams = new ArrayList<Cql>();
        statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match (commonAction:Action) where commonAction.nameSpace in['espCommon','common'] and commonAction.version=te.version and commonAction.tenantId is null merge (te)-[:ACTION]->(commonAction)"));
        statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match (commonAction:Action) where commonAction.nameSpace in['espCommon','common'] and commonAction.version=te.version and commonAction.tenantId=te.tenantId merge (te)-[:ACTION]->(commonAction)"));
        if (ucTenantArray != null) {
            for (int i = 0; i < ucTenantArray.size(); ++i) {
                JSONObject ucTenant = ucTenantArray.getJSONObject(i);
                if (ucTenant.get((Object)"associationTenant") == null) continue;
                Object[] associationTenants = ucTenant.getJSONArray("associationTenant").toArray();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("associationTenant", associationTenants);
                params.put("ucTenant", ucTenant.getString("ucTenant"));
                statementsAndParams.add(new Cql().setCql("match (te:TenantEntity) where te.tenantId in $associationTenant match (action:Action) where action.nameSpace in['espCommon','common'] and action.version=te.version and action.tenantId=$ucTenant merge (te)-[:ACTION]->(action)").setParams(params));
            }
        }
        statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match (commonTask:Task) where commonTask.nameSpace ='common' and commonTask.version=te.version merge (te)-[:TASK]->(commonTask)"));
        statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match (commonActivity:Activity) where commonActivity.nameSpace ='common' and commonActivity.version=te.version merge (te)-[:ACTIVITY]->(commonActivity)"));
        tenantUseAppList.forEach(tenantUseApp -> {
            List cqlList = DeployUtil.createTenantNodeRelation((String)tenantId, (String)String.valueOf(tenantUseApp.get("appNamespace")));
            for (Cql cql : cqlList) {
                statementsAndParams.add(cql);
            }
            Bson projectFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", tenantUseApp.get("appNamespace")), Filters.eq((String)"version", tenantUseApp.get("version"))});
            FindIterable projectDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("project").find(projectFilter);
            projectDocuments.forEach(projectDocument -> {
                Bson tenantProductRelationFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"objectType", (Object)"project"), Filters.eq((String)"objectCode", (Object)projectDocument.getString((Object)"code"))});
                FindIterable tenantProductRelationDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").find(tenantProductRelationFilter);
                AtomicInteger tenantProductRelationCount = new AtomicInteger();
                tenantProductRelationDocuments.forEach(tenantProductRelationDocument -> tenantProductRelationCount.getAndIncrement());
                if (tenantProductRelationCount.get() < 1) {
                    Document tenantProductRelation = new Document();
                    tenantProductRelation.put("tenantId", (Object)tenantId);
                    tenantProductRelation.put("objectType", (Object)"project");
                    tenantProductRelation.put("objectCode", (Object)projectDocument.getString((Object)"code"));
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").insertOne((Object)tenantProductRelation);
                }
            });
        });
        Neo4jManager.getNeo4jManager().ExecuteTransactionNoQuery(statementsAndParams);
        log.info("\u66f4\u65b0\u5b8c\u6210: \u66f4\u65b0{}\u5173\u8054\u7684\u7248\u672c", (Object)tenantId);
    }

    public void switchProdDataVersion(Application application) {
        log.info("\u66f4\u65b0" + application.getVersion() + "\u81f3\u6b63\u5f0f\u7248\u672c");
        JSONArray ucTenantArray = (JSONArray)FileUtils.readObjectFromFilePath((String)"uc_tenant.json", JSONArray.class);
        String odlProdVersion = this.deployerProgressService.getProdVersion();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", odlProdVersion);
        List prodTenantList = Neo4jManager.getNeo4jManager().ExecuteQuery("match (tenant:TenantEntity) where tenant.version=$version return tenant.tenantId as tenantId", param);
        ArrayList<Cql> statementsAndParams = new ArrayList<Cql>();
        prodTenantList.forEach(prodTenant -> {
            statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + String.valueOf(prodTenant.get("tenantId")) + "'}) match (commonAction:Action) where commonAction.nameSpace in['espCommon','common'] and commonAction.version='" + application.getVersion() + "' and commonAction.tenantId is null merge (te)-[:ACTION]->(commonAction)"));
            statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + String.valueOf(prodTenant.get("tenantId")) + "'}) match (commonAction:Action) where commonAction.nameSpace in['espCommon','common'] and commonAction.version='" + application.getVersion() + "' and commonAction.tenantId=te.tenantId merge (te)-[:ACTION]->(commonAction)"));
            if (ucTenantArray != null) {
                for (int i = 0; i < ucTenantArray.size(); ++i) {
                    JSONObject ucTenant = ucTenantArray.getJSONObject(i);
                    if (ucTenant.get((Object)"associationTenant") == null) continue;
                    Object[] associationTenants = ucTenant.getJSONArray("associationTenant").toArray();
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("associationTenant", associationTenants);
                    params.put("ucTenant", ucTenant.getString("ucTenant"));
                    statementsAndParams.add(new Cql().setCql("match (te:TenantEntity) where te.tenantId in $associationTenant match (action:Action) where action.nameSpace in['espCommon','common'] and action.version='" + application.getVersion() + "' and action.tenantId=$ucTenant merge (te)-[:ACTION]->(action)").setParams(params));
                }
            }
            statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + String.valueOf(prodTenant.get("tenantId")) + "'}) match (commonTask:Task) where commonTask.nameSpace ='common' and commonTask.version='" + application.getVersion() + "' merge (te)-[:TASK]->(commonTask)"));
            statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + String.valueOf(prodTenant.get("tenantId")) + "'}) match (commonActivity:Activity) where commonActivity.nameSpace ='common' and commonActivity.version='" + application.getVersion() + "' merge (te)-[:ACTIVITY]->(commonActivity)"));
        });
        List prodTenantUseAppList = Neo4jManager.getNeo4jManager().ExecuteQuery("match (tenant:TenantEntity)-[:USE]-(app:AppEntity) where tenant.version=$version return tenant.tenantId as tenantId,app.code as appCode,app.namespace as appNamespace", param);
        prodTenantUseAppList.forEach(prodTenantUseApp -> {
            statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + String.valueOf(prodTenantUseApp.get("tenantId")) + "'}) match(task:Task) where task.nameSpace = '" + String.valueOf(prodTenantUseApp.get("appNamespace")) + "' and task.version='" + application.getVersion() + "' merge (te)-[:TASK]->(task)"));
            statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + String.valueOf(prodTenantUseApp.get("tenantId")) + "'}) match(activity:Activity) where activity.nameSpace = '" + String.valueOf(prodTenantUseApp.get("appNamespace")) + "' and activity.version='" + application.getVersion() + "' and activity.inclusionTenant is null merge (te)-[:ACTIVITY]->(activity)"));
            statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + String.valueOf(prodTenantUseApp.get("tenantId")) + "'}) match(activity:Activity) where activity.nameSpace = '" + String.valueOf(prodTenantUseApp.get("appNamespace")) + "' and activity.version='" + application.getVersion() + "' and activity.inclusionTenant is not null and te.tenantId in activity.inclusionTenant merge (te)-[:ACTIVITY]->(activity)"));
            if (ucTenantArray != null) {
                for (int i = 0; i < ucTenantArray.size(); ++i) {
                    JSONObject ucTenant = ucTenantArray.getJSONObject(i);
                    if (ucTenant.get((Object)"associationTenant") == null || !ucTenant.getString("ucTenant").equals(prodTenantUseApp.get("tenantId"))) continue;
                    Object[] associationTenants = ucTenant.getJSONArray("associationTenant").toArray();
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("nameSpace", prodTenantUseApp.get("appNamespace"));
                    params.put("associationTenant", associationTenants);
                    params.put("ucTenant", ucTenant.getString("ucTenant"));
                    statementsAndParams.add(new Cql().setCql("match(te:TenantEntity) where te.tenantId in $associationTenant match(activity:Activity) where activity.nameSpace=$nameSpace and activity.version='" + application.getVersion() + "' and activity.inclusionTenant is not null and $ucTenant in activity.inclusionTenant merge (te)-[:ACTIVITY]->(activity)").setParams(params));
                }
            }
            statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + String.valueOf(prodTenantUseApp.get("tenantId")) + "'}) match(me:Mechanism) where me.nameSpace = '" + String.valueOf(prodTenantUseApp.get("appNamespace")) + "' and me.version='" + application.getVersion() + "' merge (te)-[:MECHANISM]->(me)"));
            statementsAndParams.add(new Cql().setCql("match (te:TenantEntity{tenantId:'" + String.valueOf(prodTenantUseApp.get("tenantId")) + "'}) match(action:Action) where action.nameSpace = '" + String.valueOf(prodTenantUseApp.get("appNamespace")) + "' and action.version='" + application.getVersion() + "' merge (te)-[:ACTION]->(action)"));
            Bson projectFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", prodTenantUseApp.get("appNamespace")), Filters.eq((String)"version", (Object)application.getVersion())});
            FindIterable projectDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("project").find(projectFilter);
            projectDocuments.forEach(projectDocument -> {
                Bson tenantProductRelationFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", prodTenantUseApp.get("tenantId")), Filters.eq((String)"objectType", (Object)"project"), Filters.eq((String)"objectCode", (Object)projectDocument.getString((Object)"code"))});
                FindIterable tenantProductRelationDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").find(tenantProductRelationFilter);
                AtomicInteger tenantProductRelationCount = new AtomicInteger();
                tenantProductRelationDocuments.forEach(tenantProductRelationDocument -> tenantProductRelationCount.getAndIncrement());
                if (tenantProductRelationCount.get() < 1) {
                    Document tenantProductRelation = new Document();
                    tenantProductRelation.put("tenantId", prodTenantUseApp.get("tenantId"));
                    tenantProductRelation.put("objectType", (Object)"project");
                    tenantProductRelation.put("objectCode", (Object)projectDocument.getString((Object)"code"));
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").insertOne((Object)tenantProductRelation);
                }
            });
        });
        HashMap<String, String> param2 = new HashMap<String, String>();
        param2.put("version", odlProdVersion);
        param2.put("newVersion", application.getVersion());
        statementsAndParams.add(new Cql().setCql("match (tenant:TenantEntity) where tenant.version=$version set tenant.version=$newVersion").setParams(param2));
        Bson filter = Filters.eq((String)"version", (Object)odlProdVersion);
        Document update = new Document("$set", (Object)new Document().append("version", (Object)(application.getVersion().split("\\.")[0] + ".x")));
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantConfig").updateMany(filter, (Bson)update);
        statementsAndParams.add(new Cql().setCql("match (app:AppEntity) where app.version=$version set app.version=$newVersion").setParams(param2));
        statementsAndParams.add(new Cql().setCql("match (tenant:TenantEntity)-[relation]-(node) where node.version=$version delete relation").setParams(param));
        Neo4jManager.getNeo4jManager().ExecuteTransactionNoQuery(statementsAndParams);
        log.info("\u66f4\u65b0" + application.getVersion() + "\u81f3\u6b63\u5f0f\u7248\u672c\u5b8c\u6210");
    }
}

